﻿---
title: Winlogbeat fields
description: Fields from the Windows Event Log. All fields specific to the Windows Event Log are defined here. This is a non-exhaustive list of parameters that are...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/exported-fields-winlog
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Winlogbeat fields
Fields from the Windows Event Log.
<definitions>
  <definition term="event.original">
    The raw XML representation of the event obtained from Windows. This field is only available on operating systems supporting the Windows Event Log API (Microsoft Windows Vista and newer). This field is not included by default and must be enabled by setting `include_xml: true` as a configuration option for an individual event log. The XML representation of the event is useful for troubleshooting purposes. The data in the fields reported by Winlogbeat can be compared to the data in the XML to diagnose problems.
  </definition>
</definitions>


## winlog

All fields specific to the Windows Event Log are defined here.
<definitions>
  <definition term="winlog.activity_id">
    A globally unique identifier that identifies the current activity. The events that are published with this identifier are part of the same activity.
    type: keyword
    required: False
  </definition>
  <definition term="winlog.computer_name">
    The name of the computer that generated the record. When using Windows event forwarding, this name can differ from `agent.hostname`.
    type: keyword
    required: True
  </definition>
  <definition term="winlog.computerObject.domain">
    The domain of the account that was added, modified or deleted in the event.
    type: keyword
    required: False
  </definition>
  <definition term="winlog.computerObject.id">
    A globally unique identifier that identifies the target device.
    type: keyword
    required: False
  </definition>
  <definition term="winlog.computerObject.name">
    The account name that was added, modified or deleted in the event.
    type: keyword
    required: False
  </definition>
  <definition term="winlog.event_data">
    The event-specific data. This field is mutually exclusive with `user_data`. If you are capturing event data on versions prior to Windows Vista, the parameters in `event_data` are named `param1`, `param2`, and so on, because event log parameters are unnamed in earlier versions of Windows.
    type: object
    required: False
  </definition>
</definitions>


## event_data

This is a non-exhaustive list of parameters that are used in Windows events. By having these fields defined in the template they can be used in dashboards and machine-learning jobs.
<definitions>
  <definition term="winlog.event_data.AuthenticationPackageName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Binary">
    type: keyword
  </definition>
  <definition term="winlog.event_data.BitlockerUserInputTime">
    type: keyword
  </definition>
  <definition term="winlog.event_data.BootMode">
    type: keyword
  </definition>
  <definition term="winlog.event_data.BootType">
    type: keyword
  </definition>
  <definition term="winlog.event_data.BuildVersion">
    type: keyword
  </definition>
  <definition term="winlog.event_data.CallTrace">
    type: keyword
  </definition>
  <definition term="winlog.event_data.ClientInfo">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Company">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Configuration">
    type: keyword
  </definition>
  <definition term="winlog.event_data.CorruptionActionState">
    type: keyword
  </definition>
  <definition term="winlog.event_data.CreationUtcTime">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Description">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Detail">
    type: keyword
  </definition>
  <definition term="winlog.event_data.DeviceName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.DeviceNameLength">
    type: keyword
  </definition>
  <definition term="winlog.event_data.DeviceTime">
    type: keyword
  </definition>
  <definition term="winlog.event_data.DeviceVersionMajor">
    type: keyword
  </definition>
  <definition term="winlog.event_data.DeviceVersionMinor">
    type: keyword
  </definition>
  <definition term="winlog.event_data.DriveName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.DriverName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.DriverNameLength">
    type: keyword
  </definition>
  <definition term="winlog.event_data.DwordVal">
    type: keyword
  </definition>
  <definition term="winlog.event_data.EntryCount">
    type: keyword
  </definition>
  <definition term="winlog.event_data.EventType">
    type: keyword
  </definition>
  <definition term="winlog.event_data.EventNamespace">
    type: keyword
  </definition>
  <definition term="winlog.event_data.ExtraInfo">
    type: keyword
  </definition>
  <definition term="winlog.event_data.FailureName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.FailureNameLength">
    type: keyword
  </definition>
  <definition term="winlog.event_data.FileVersion">
    type: keyword
  </definition>
  <definition term="winlog.event_data.FinalStatus">
    type: keyword
  </definition>
  <definition term="winlog.event_data.GrantedAccess">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Group">
    type: keyword
  </definition>
  <definition term="winlog.event_data.IdleImplementation">
    type: keyword
  </definition>
  <definition term="winlog.event_data.IdleStateCount">
    type: keyword
  </definition>
  <definition term="winlog.event_data.ImpersonationLevel">
    type: keyword
  </definition>
  <definition term="winlog.event_data.IntegrityLevel">
    type: keyword
  </definition>
  <definition term="winlog.event_data.IpAddress">
    type: keyword
  </definition>
  <definition term="winlog.event_data.IpPort">
    type: keyword
  </definition>
  <definition term="winlog.event_data.KeyLength">
    type: keyword
  </definition>
  <definition term="winlog.event_data.LastBootGood">
    type: keyword
  </definition>
  <definition term="winlog.event_data.LastShutdownGood">
    type: keyword
  </definition>
  <definition term="winlog.event_data.LmPackageName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.LogonGuid">
    type: keyword
  </definition>
  <definition term="winlog.event_data.LogonId">
    type: keyword
  </definition>
  <definition term="winlog.event_data.LogonProcessName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.LogonType">
    type: keyword
  </definition>
  <definition term="winlog.event_data.MajorVersion">
    type: keyword
  </definition>
  <definition term="winlog.event_data.MaximumPerformancePercent">
    type: keyword
  </definition>
  <definition term="winlog.event_data.MemberName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.MemberSid">
    type: keyword
  </definition>
  <definition term="winlog.event_data.MinimumPerformancePercent">
    type: keyword
  </definition>
  <definition term="winlog.event_data.MinimumThrottlePercent">
    type: keyword
  </definition>
  <definition term="winlog.event_data.MinorVersion">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Name">
    type: keyword
  </definition>
  <definition term="winlog.event_data.NewProcessId">
    type: keyword
  </definition>
  <definition term="winlog.event_data.NewProcessName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.NewSchemeGuid">
    type: keyword
  </definition>
  <definition term="winlog.event_data.NewThreadId">
    type: keyword
  </definition>
  <definition term="winlog.event_data.NewTime">
    type: keyword
  </definition>
  <definition term="winlog.event_data.NominalFrequency">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Number">
    type: keyword
  </definition>
  <definition term="winlog.event_data.OldSchemeGuid">
    type: keyword
  </definition>
  <definition term="winlog.event_data.OldTime">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Operation">
    type: keyword
  </definition>
  <definition term="winlog.event_data.OriginalFileName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Path">
    type: keyword
  </definition>
  <definition term="winlog.event_data.PerformanceImplementation">
    type: keyword
  </definition>
  <definition term="winlog.event_data.PreviousCreationUtcTime">
    type: keyword
  </definition>
  <definition term="winlog.event_data.PreviousTime">
    type: keyword
  </definition>
  <definition term="winlog.event_data.PrivilegeList">
    type: keyword
  </definition>
  <definition term="winlog.event_data.ProcessId">
    type: keyword
  </definition>
  <definition term="winlog.event_data.ProcessName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.ProcessPath">
    type: keyword
  </definition>
  <definition term="winlog.event_data.ProcessPid">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Product">
    type: keyword
  </definition>
  <definition term="winlog.event_data.PuaCount">
    type: keyword
  </definition>
  <definition term="winlog.event_data.PuaPolicyId">
    type: keyword
  </definition>
  <definition term="winlog.event_data.QfeVersion">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Query">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Reason">
    type: keyword
  </definition>
  <definition term="winlog.event_data.SchemaVersion">
    type: keyword
  </definition>
  <definition term="winlog.event_data.ScriptBlockText">
    type: keyword
  </definition>
  <definition term="winlog.event_data.ServiceName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.ServiceVersion">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Session">
    type: keyword
  </definition>
  <definition term="winlog.event_data.ShutdownActionType">
    type: keyword
  </definition>
  <definition term="winlog.event_data.ShutdownEventCode">
    type: keyword
  </definition>
  <definition term="winlog.event_data.ShutdownReason">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Signature">
    type: keyword
  </definition>
  <definition term="winlog.event_data.SignatureStatus">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Signed">
    type: keyword
  </definition>
  <definition term="winlog.event_data.StartAddress">
    type: keyword
  </definition>
  <definition term="winlog.event_data.StartFunction">
    type: keyword
  </definition>
  <definition term="winlog.event_data.StartModule">
    type: keyword
  </definition>
  <definition term="winlog.event_data.StartTime">
    type: keyword
  </definition>
  <definition term="winlog.event_data.State">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Status">
    type: keyword
  </definition>
  <definition term="winlog.event_data.StopTime">
    type: keyword
  </definition>
  <definition term="winlog.event_data.SubjectDomainName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.SubjectLogonId">
    type: keyword
  </definition>
  <definition term="winlog.event_data.SubjectUserName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.SubjectUserSid">
    type: keyword
  </definition>
  <definition term="winlog.event_data.TSId">
    type: keyword
  </definition>
  <definition term="winlog.event_data.TargetDomainName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.TargetImage">
    type: keyword
  </definition>
  <definition term="winlog.event_data.TargetInfo">
    type: keyword
  </definition>
  <definition term="winlog.event_data.TargetLogonGuid">
    type: keyword
  </definition>
  <definition term="winlog.event_data.TargetLogonId">
    type: keyword
  </definition>
  <definition term="winlog.event_data.TargetProcessGUID">
    type: keyword
  </definition>
  <definition term="winlog.event_data.TargetProcessId">
    type: keyword
  </definition>
  <definition term="winlog.event_data.TargetServerName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.TargetUserName">
    type: keyword
  </definition>
  <definition term="winlog.event_data.TargetUserSid">
    type: keyword
  </definition>
  <definition term="winlog.event_data.TerminalSessionId">
    type: keyword
  </definition>
  <definition term="winlog.event_data.TokenElevationType">
    type: keyword
  </definition>
  <definition term="winlog.event_data.TransmittedServices">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Type">
    type: keyword
  </definition>
  <definition term="winlog.event_data.UserSid">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Version">
    type: keyword
  </definition>
  <definition term="winlog.event_data.Workstation">
    type: keyword
  </definition>
  <definition term="winlog.event_data.param1">
    type: keyword
  </definition>
  <definition term="winlog.event_data.param2">
    type: keyword
  </definition>
  <definition term="winlog.event_data.param3">
    type: keyword
  </definition>
  <definition term="winlog.event_data.param4">
    type: keyword
  </definition>
  <definition term="winlog.event_data.param5">
    type: keyword
  </definition>
  <definition term="winlog.event_data.param6">
    type: keyword
  </definition>
  <definition term="winlog.event_data.param7">
    type: keyword
  </definition>
  <definition term="winlog.event_data.param8">
    type: keyword
  </definition>
  <definition term="winlog.event_id">
    The event identifier. The value is specific to the source of the event.
    type: keyword
    required: True
  </definition>
  <definition term="winlog.keywords">
    The keywords are used to classify an event.
    type: keyword
    required: False
  </definition>
  <definition term="winlog.channel">
    The name of the channel from which this record was read. This value is one of the names from the `event_logs` collection in the configuration.
    type: keyword
    required: True
  </definition>
  <definition term="winlog.record_id">
    The record ID of the event log record. The first record written to an event log is record number 1, and other records are numbered sequentially. If the record number reaches the maximum value (2^32^ for the Event Logging API and 2^64^ for the Windows Event Log API), the next record number will be 0.
    type: keyword
    required: True
  </definition>
  <definition term="winlog.related_activity_id">
    A globally unique identifier that identifies the activity to which control was transferred to. The related events would then have this identifier as their `activity_id` identifier.
    type: keyword
    required: False
  </definition>
  <definition term="winlog.opcode">
    The opcode defined in the event. Task and opcode are typically used to identify the location in the application from where the event was logged.
    type: keyword
    required: False
  </definition>
  <definition term="winlog.provider_guid">
    A globally unique identifier that identifies the provider that logged the event.
    type: keyword
    required: False
  </definition>
  <definition term="winlog.process.pid">
    The process_id of the Client Server Runtime Process.
    type: long
    required: False
  </definition>
  <definition term="winlog.provider_name">
    The source of the event log record (the application or service that logged the record).
    type: keyword
    required: True
  </definition>
  <definition term="winlog.task">
    The task defined in the event. Task and opcode are typically used to identify the location in the application from where the event was logged. The category used by the Event Logging API (on pre Windows Vista operating systems) is written to this field.
    type: keyword
    required: False
  </definition>
  <definition term="winlog.time_created">
    The event creation time.
    type: date
    required: False
  </definition>
  <definition term="winlog.trustAttribute">
    The decimal value of attributes for new trust created to a domain.
    type: keyword
    required: False
  </definition>
  <definition term="winlog.trustDirection">
    The direction of new trust created to a domain. Possible values are `TRUST_DIRECTION_DISABLED`, `TRUST_DIRECTION_INBOUND`, `TRUST_DIRECTION_OUTBOUND` and `TRUST_DIRECTION_BIDIRECTIONAL`
    type: keyword
    required: False
  </definition>
  <definition term="winlog.trustType">
    The account name that was added, modified or deleted in the event. Possible values are `TRUST_TYPE_DOWNLEVEL`, `TRUST_TYPE_UPLEVEL`, `TRUST_TYPE_MIT` and `TRUST_TYPE_DCE`
    type: keyword
    required: False
  </definition>
  <definition term="winlog.process.thread.id">
    type: long
    required: False
  </definition>
  <definition term="winlog.user_data">
    The event specific data. This field is mutually exclusive with `event_data`.
    type: object
    required: False
  </definition>
  <definition term="winlog.user.identifier">
    The Windows security identifier (SID) of the account associated with this event. If Winlogbeat cannot resolve the SID to a name, then the `user.name`, `user.domain`, and `user.type` fields will be omitted from the event. If you discover Winlogbeat not resolving SIDs, review the log for clues as to what the problem may be.
    type: keyword
    example: S-1-5-21-3541430928-2051711210-1391384369-1001
    required: False
  </definition>
  <definition term="winlog.user.name">
    Name of the user associated with this event.
    type: keyword
  </definition>
  <definition term="winlog.user.domain">
    The domain that the account associated with this event is a member of.
    type: keyword
    required: False
  </definition>
  <definition term="winlog.user.type">
    The type of account associated with this event.
    type: keyword
    required: False
  </definition>
  <definition term="winlog.version">
    The version number of the event's definition.
    type: long
    required: False
  </definition>
</definitions>