﻿---
title: Security module fields
description: These are the event fields specific to the module for the Security log. Data related to a Windows logon. 
url: https://www.elastic.co/docs/reference/beats/winlogbeat/exported-fields-security
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Beta
---

# Security module fields
These are the event fields specific to the module for the Security log.

## winlog.logon

Data related to a Windows logon.
<definitions>
  <definition term="winlog.logon.type">
    Logon type name. This is the descriptive version of the `winlog.event_data.LogonType` ordinal. This is an enrichment added by the Security module.
    type: keyword
    example: RemoteInteractive
  </definition>
  <definition term="winlog.logon.id">
    Logon ID that can be used to associate this logon with other events related to the same logon session.
    type: keyword
  </definition>
  <definition term="winlog.logon.failure.reason">
    The reason the logon failed.
    type: keyword
  </definition>
  <definition term="winlog.logon.failure.status">
    The reason the logon failed. This is textual description based on the value of the hexadecimal `Status` field.
    type: keyword
  </definition>
  <definition term="winlog.logon.failure.sub_status">
    Additional information about the logon failure. This is a textual description based on the value of the hexidecimal `SubStatus` field.
    type: keyword
  </definition>
</definitions>