﻿---
title: PowerShell module fields
description: These are the event fields specific to the module for the Microsoft-Windows-PowerShell/Operational and Windows PowerShell logs. Data related to the executed...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/exported-fields-powershell
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Beta
---

# PowerShell module fields
These are the event fields specific to the module for the Microsoft-Windows-PowerShell/Operational and Windows PowerShell logs.
<definitions>
  <definition term="powershell.id">
    Shell Id.
    type: keyword
    example: Microsoft Powershell
  </definition>
  <definition term="powershell.pipeline_id">
    Pipeline id.
    type: keyword
    example: 1
  </definition>
  <definition term="powershell.runspace_id">
    Runspace id.
    type: keyword
    example: 4fa9074d-45ab-4e53-9195-e91981ac2bbb
  </definition>
  <definition term="powershell.sequence">
    Sequence number of the powershell execution.
    type: long
    example: 1
  </definition>
  <definition term="powershell.total">
    Total number of messages in the sequence.
    type: long
    example: 10
  </definition>
</definitions>


## powershell.command

Data related to the executed command.
<definitions>
  <definition term="powershell.command.path">
    Path of the executed command.
    type: keyword
    example: C:\Windows\system32\cmd.exe
  </definition>
  <definition term="powershell.command.name">
    Name of the executed command.
    type: keyword
    example: cmd.exe
  </definition>
  <definition term="powershell.command.type">
    Type of the executed command.
    type: keyword
    example: Application
  </definition>
  <definition term="powershell.command.value">
    The invoked command.
    type: text
    example: Import-LocalizedData  LocalizedData -filename ArchiveResources
  </definition>
  <definition term="powershell.command.invocation_details">
    An array of objects containing detailed information of the executed command.
    type: array
  </definition>
  <definition term="powershell.command.invocation_details.type">
    The type of detail.
    type: keyword
    example: CommandInvocation
  </definition>
  <definition term="powershell.command.invocation_details.related_command">
    The command to which the detail is related to.
    type: keyword
    example: Add-Type
  </definition>
  <definition term="powershell.command.invocation_details.name">
    Only used for ParameterBinding detail type. Indicates the parameter name.
    type: keyword
    example: AssemblyName
  </definition>
  <definition term="powershell.command.invocation_details.value">
    The value of the detail. The meaning of it will depend on the detail type.
    type: text
    example: System.IO.Compression.FileSystem
  </definition>
</definitions>


## powershell.connected_user

Data related to the connected user executing the command.
<definitions>
  <definition term="powershell.connected_user.domain">
    User domain.
    type: keyword
    example: VAGRANT
  </definition>
  <definition term="powershell.connected_user.name">
    User name.
    type: keyword
    example: vagrant
  </definition>
</definitions>


## powershell.engine

Data related to the PowerShell engine.
<definitions>
  <definition term="powershell.engine.version">
    Version of the PowerShell engine version used to execute the command.
    type: keyword
    example: 5.1.17763.1007
  </definition>
  <definition term="powershell.engine.previous_state">
    Previous state of the PowerShell engine.
    type: keyword
    example: Available
  </definition>
  <definition term="powershell.engine.new_state">
    New state of the PowerShell engine.
    type: keyword
    example: Stopped
  </definition>
</definitions>


## powershell.file

Data related to the executed script file.
<definitions>
  <definition term="powershell.file.script_block_id">
    Id of the executed script block.
    type: keyword
    example: 50d2dbda-7361-4926-a94d-d9eadfdb43fa
  </definition>
  <definition term="powershell.file.script_block_text">
    Text of the executed script block.
    type: text
    example: .\a_script.ps1
  </definition>
  <definition term="powershell.process.executable_version">
    Version of the engine hosting process executable.
    type: keyword
    example: 5.1.17763.1007
  </definition>
</definitions>


## powershell.provider

Data related to the PowerShell engine host.
<definitions>
  <definition term="powershell.provider.new_state">
    New state of the PowerShell provider.
    type: keyword
    example: Active
  </definition>
  <definition term="powershell.provider.name">
    Provider name.
    type: keyword
    example: Variable
  </definition>
</definitions>