﻿---
title: Kubernetes fields
description: Kubernetes metadata added by the kubernetes processor 
url: https://www.elastic.co/docs/reference/beats/winlogbeat/exported-fields-kubernetes-processor
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Kubernetes fields
Kubernetes metadata added by the kubernetes processor
<definitions>
  <definition term="kubernetes.pod.name">
    Kubernetes pod name
    type: keyword
  </definition>
  <definition term="kubernetes.pod.uid">
    Kubernetes Pod UID
    type: keyword
  </definition>
  <definition term="kubernetes.pod.ip">
    Kubernetes Pod IP
    type: ip
  </definition>
  <definition term="kubernetes.namespace">
    Kubernetes namespace
    type: keyword
  </definition>
  <definition term="kubernetes.node.name">
    Kubernetes node name
    type: keyword
  </definition>
  <definition term="kubernetes.node.hostname">
    Kubernetes hostname as reported by the node’s kernel
    type: keyword
  </definition>
  <definition term="kubernetes.labels.*">
    Kubernetes labels map
    type: object
  </definition>
  <definition term="kubernetes.annotations.*">
    Kubernetes annotations map
    type: object
  </definition>
  <definition term="kubernetes.selectors.*">
    Kubernetes selectors map
    type: object
  </definition>
  <definition term="kubernetes.replicaset.name">
    Kubernetes replicaset name
    type: keyword
  </definition>
  <definition term="kubernetes.deployment.name">
    Kubernetes deployment name
    type: keyword
  </definition>
  <definition term="kubernetes.statefulset.name">
    Kubernetes statefulset name
    type: keyword
  </definition>
  <definition term="kubernetes.container.name">
    Kubernetes container name (different than the name from the runtime)
    type: keyword
  </definition>
</definitions>