﻿---
title: Legacy Winlogbeat alias fields
description: Field aliases based on Winlogbeat 6.x that point to the fields for this version of Winlogbeat. These are added to the index template when migration.6_to_7.enable:...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/exported-fields-eventlog
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Legacy Winlogbeat alias fields
Field aliases based on Winlogbeat 6.x that point to the fields for this version of Winlogbeat. These are added to the index template when `migration.6_to_7.enable: true` is set in the configuration.
<definitions>
  <definition term="activity_id">
    type: alias
    alias to: winlog.activity_id
  </definition>
  <definition term="computer_name">
    type: alias
    alias to: winlog.computer_name
  </definition>
  <definition term="event_id">
    type: alias
    alias to: winlog.event_id
  </definition>
  <definition term="keywords">
    type: alias
    alias to: winlog.keywords
  </definition>
  <definition term="log_name">
    type: alias
    alias to: winlog.channel
  </definition>
  <definition term="message_error">
    type: alias
    alias to: error.message
  </definition>
  <definition term="record_number">
    type: alias
    alias to: winlog.record_id
  </definition>
  <definition term="related_activity_id">
    type: alias
    alias to: winlog.related_activity_id
  </definition>
  <definition term="opcode">
    type: alias
    alias to: winlog.opcode
  </definition>
  <definition term="provider_guid">
    type: alias
    alias to: winlog.provider_guid
  </definition>
  <definition term="process_id">
    type: alias
    alias to: winlog.process.pid
  </definition>
  <definition term="source_name">
    type: alias
    alias to: winlog.provider_name
  </definition>
  <definition term="task">
    type: alias
    alias to: winlog.task
  </definition>
  <definition term="thread_id">
    type: alias
    alias to: winlog.process.thread.id
  </definition>
  <definition term="user.identifier">
    type: alias
    alias to: winlog.user.identifier
  </definition>
  <definition term="user.type">
    type: alias
    alias to: winlog.user.type
  </definition>
  <definition term="version">
    type: alias
    alias to: winlog.version
  </definition>
  <definition term="xml">
    type: alias
    alias to: event.original
  </definition>
</definitions>