﻿---
title: Directory layout
description: The directory layout of an installation is as follows: You can change these settings by using CLI flags or setting path options in the configuration file...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/directory-layout
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Directory layout
The directory layout of an installation is as follows:
<tip>
  Archive installation has a different layout. See [zip, tar.gz, or tgz](#directory-layout-archive).
</tip>


| Type   | Description                                      | Default Location   | Config Option |
|--------|--------------------------------------------------|--------------------|---------------|
| home   | Home of the Winlogbeat installation.             |                    | `path.home`   |
| bin    | The location for the binary files.               | `{path.home}/bin`  |               |
| config | The location for configuration files.            | `{path.home}`      | `path.config` |
| data   | The location for persistent data files.          | `{path.home}/data` | `path.data`   |
| logs   | The location for the logs created by Winlogbeat. | `{path.home}/logs` | `path.logs`   |

You can change these settings by using CLI flags or setting [path options](https://www.elastic.co/docs/reference/beats/winlogbeat/configuration-path) in the configuration file.

## Default paths

Winlogbeat uses the following default paths unless you explicitly change them.

#### zip, tar.gz, or tgz


| Type   | Description                                      | Location              |
|--------|--------------------------------------------------|-----------------------|
| home   | Home of the Winlogbeat installation.             | `{extract.path}`      |
| bin    | The location for the binary files.               | `{extract.path}`      |
| config | The location for configuration files.            | `{extract.path}`      |
| data   | The location for persistent data files.          | `{extract.path}/data` |
| logs   | The location for the logs created by Winlogbeat. | `{extract.path}/logs` |

For the zip, tar.gz, or tgz distributions, these paths are based on the location of the extracted binary file. This means that if you start Winlogbeat with the following simple command, all paths are set correctly:
```sh
Start-Service winlogbeat
```