﻿---
title: Configure Winlogbeat
description: To configure Winlogbeat, edit the configuration file. The default configuration file is called  winlogbeat.yml. The location of the file varies by platform...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/configuring-howto-winlogbeat
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure Winlogbeat
<tip>
  To get started quickly, read [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-installation-configuration).
</tip>

To configure Winlogbeat, edit the configuration file. The default configuration file is called  `winlogbeat.yml`. The location of the file varies by platform. To locate the file, see [Directory layout](https://www.elastic.co/docs/reference/beats/winlogbeat/directory-layout).
There’s also a full example configuration file called `winlogbeat.reference.yml` that shows all non-deprecated options.
<tip>
  See the [Config File Format](https://www.elastic.co/docs/reference/beats/libbeat/config-file-format) for more about the structure of the config file.
</tip>

The following topics describe how to configure Winlogbeat:
- [Winlogbeat](https://www.elastic.co/docs/reference/beats/winlogbeat/configuration-winlogbeat-options)
- [General settings](https://www.elastic.co/docs/reference/beats/winlogbeat/configuration-general-options)
- [Project paths](https://www.elastic.co/docs/reference/beats/winlogbeat/configuration-path)
- [Output](https://www.elastic.co/docs/reference/beats/winlogbeat/configuring-output)
- [SSL](https://www.elastic.co/docs/reference/beats/winlogbeat/configuration-ssl)
- [Index lifecycle management (ILM)](https://www.elastic.co/docs/reference/beats/winlogbeat/ilm)
- [Elasticsearch index template](https://www.elastic.co/docs/reference/beats/winlogbeat/configuration-template)
- [Kibana endpoint](https://www.elastic.co/docs/reference/beats/winlogbeat/setup-kibana-endpoint)
- [Kibana dashboards](https://www.elastic.co/docs/reference/beats/winlogbeat/configuration-dashboards)
- [Processors](https://www.elastic.co/docs/reference/beats/winlogbeat/filtering-enhancing-data)
- [Internal queue](https://www.elastic.co/docs/reference/beats/winlogbeat/configuring-internal-queue)
- [Logging](https://www.elastic.co/docs/reference/beats/winlogbeat/configuration-logging)
- [HTTP endpoint](https://www.elastic.co/docs/reference/beats/winlogbeat/http-endpoint)
- [Instrumentation](https://www.elastic.co/docs/reference/beats/winlogbeat/configuration-instrumentation)
- [*winlogbeat.reference.yml*](https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-reference-yml)