﻿---
title: Settings for internal collection
description: Use the following settings to configure internal collection when you are not using Metricbeat to collect monitoring data. You specify these settings in...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/configuration-monitor
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Settings for internal collection
Use the following settings to configure internal collection when you are not using Metricbeat to collect monitoring data.
You specify these settings in the X-Pack monitoring section of the `winlogbeat.yml` config file:

## `monitoring.enabled`

The `monitoring.enabled` config is a boolean setting to enable or disable X-Pack monitoring. If set to `true`, monitoring is enabled.
The default value is `false`.

## `monitoring.elasticsearch`

The Elasticsearch instances that you want to ship your Winlogbeat metrics to. This configuration option contains the following fields:

## `monitoring.cluster_uuid`

The `monitoring.cluster_uuid` config identifies the Elasticsearch cluster under which the monitoring data will appear in the Stack Monitoring UI.

### `api_key`

The detail of the API key to be used to send monitoring information to Elasticsearch. See [*Grant access using API keys*](https://www.elastic.co/docs/reference/beats/winlogbeat/beats-api-keys) for more information.

### `bulk_max_size`

The maximum number of metrics to bulk in a single Elasticsearch bulk API index request. The default is `50`. For more information, see [Elasticsearch](https://www.elastic.co/docs/reference/beats/winlogbeat/elasticsearch-output).

### `backoff.init`

The number of seconds to wait before trying to reconnect to Elasticsearch after a network error. After waiting `backoff.init` seconds, Winlogbeat tries to reconnect. If the attempt fails, the backoff timer is increased exponentially up to `backoff.max`. After a successful connection, the backoff timer is reset. The default is 1s.

### `backoff.max`

The maximum number of seconds to wait before attempting to connect to Elasticsearch after a network error. The default is 60s.

### `compression_level`

The gzip compression level. Setting this value to `0` disables compression. The compression level must be in the range of `1` (best speed) to `9` (best compression). The default value is `0`. Increasing the compression level reduces the network usage but increases the CPU usage.

### `headers`

Custom HTTP headers to add to each request. For more information, see [Elasticsearch](https://www.elastic.co/docs/reference/beats/winlogbeat/elasticsearch-output).

### `hosts`

The list of Elasticsearch nodes to connect to. Monitoring metrics are distributed to these nodes in round robin order. For more information, see [Elasticsearch](https://www.elastic.co/docs/reference/beats/winlogbeat/elasticsearch-output).

### `max_retries`

The number of times to retry sending the monitoring metrics after a failure. After the specified number of retries, the metrics are typically dropped. The default value is `3`. For more information, see [Elasticsearch](https://www.elastic.co/docs/reference/beats/winlogbeat/elasticsearch-output).

### `parameters`

Dictionary of HTTP parameters to pass within the url with index operations.

### `password`

The password that Winlogbeat uses to authenticate with the Elasticsearch instances for shipping monitoring data.

### `metrics.period`

The time interval (in seconds) when metrics are sent to the Elasticsearch cluster. A new snapshot of Winlogbeat metrics is generated and scheduled for publishing each period. The default value is 10 * time.Second.

### `state.period`

The time interval (in seconds) when state information are sent to the Elasticsearch cluster. A new snapshot of Winlogbeat state is generated and scheduled for publishing each period. The default value is 60 * time.Second.

### `protocol`

The name of the protocol to use when connecting to the Elasticsearch cluster. The options are: `http` or `https`. The default is `http`. If you specify a URL for `hosts`, however, the value of protocol is overridden by the scheme you specify in the URL.

### `proxy_url`

The URL of the proxy to use when connecting to the Elasticsearch cluster. For more information, see [Elasticsearch](https://www.elastic.co/docs/reference/beats/winlogbeat/elasticsearch-output).

### `timeout`

The HTTP request timeout in seconds for the Elasticsearch request. The default is `90`.

### `ssl`

Configuration options for Transport Layer Security (TLS) or Secure Sockets Layer (SSL) parameters like the certificate authority (CA) to use for HTTPS-based connections. If the `ssl` section is missing, the host CAs are used for HTTPS connections to Elasticsearch. For more information, see [SSL](https://www.elastic.co/docs/reference/beats/winlogbeat/configuration-ssl).

### `username`

The user ID that Winlogbeat uses to authenticate with the Elasticsearch instances for shipping monitoring data.