﻿---
title: Winlogbeat command reference
description: Winlogbeat provides a command-line interface for starting Winlogbeat and performing common tasks, like testing configuration files and loading dashboards...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/command-line-options
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Winlogbeat command reference
Winlogbeat provides a command-line interface for starting Winlogbeat and performing common tasks, like testing configuration files and loading dashboards.
The command-line also supports [global flags](#global-flags) for controlling global behaviors.
Some of the features described here require an Elastic license. For more information, see [[https://www.elastic.co/subscriptions](https://www.elastic.co/subscriptions)](https://www.elastic.co/subscriptions) and [License Management](https://www.elastic.co/docs/deploy-manage/license/manage-your-license-in-self-managed-cluster).

| Commands                        |                                                                                                                                    |
|---------------------------------|------------------------------------------------------------------------------------------------------------------------------------|
| [`export`](#export-command)     | Exports the configuration, index template, pipeline, or ILM policy to stdout.                                                      |
| [`help`](#help-command)         | Shows help for any command.                                                                                                        |
| [`keystore`](#keystore-command) | Manages the [secrets keystore](https://www.elastic.co/docs/reference/beats/winlogbeat/keystore).                                   |
| [`run`](#run-command)           | Runs Winlogbeat. This command is used by default if you start Winlogbeat without specifying a command.                             |
| [`setup`](#setup-command)       | Sets up the initial environment, including the index template, ILM policy and write alias, and Kibana dashboards (when available). |
| [`test`](#test-command)         | Tests the configuration.                                                                                                           |
| [`version`](#version-command)   | Shows information about the current version.                                                                                       |

Also see [Global flags](#global-flags).

## `export` command

Exports the configuration, index template, pipeline, or ILM policy to stdout. You can use this command to quickly view your configuration, see the contents of the index template and the ILM policy, export a dashboard from Kibana, or export ingest pipelines.
**SYNOPSIS**
```sh
winlogbeat export SUBCOMMAND [FLAGS]
```

**SUBCOMMANDS**
<definitions>
  <definition term="config">
    Exports the current configuration to stdout. If you use the `-c` flag, this command exports the configuration that’s defined in the specified file.
  </definition>
  <definition term="dashboard">
    Exports a dashboard. You can use this option to store a dashboard on disk in a module and load it automatically. For example, to export the dashboard to a JSON file, run:
    ```shell
    winlogbeat export dashboard --id="DASHBOARD_ID" > dashboard.json
    ```
    To find the `DASHBOARD_ID`, look at the URL for the dashboard in Kibana. By default, `export dashboard` writes the dashboard to stdout. The example shows how to write the dashboard to a JSON file so that you can import it later. The JSON file will contain the dashboard with all visualizations and searches. You must load the index pattern separately for Winlogbeat.
    To load the dashboard, copy the generated `dashboard.json` file into the `kibana/6/dashboard` directory of Winlogbeat, and run `winlogbeat setup --dashboards` to import the dashboard.
    If Kibana is not running on `localhost:5061`, you must also adjust the Winlogbeat configuration under `setup.kibana`.
  </definition>
  <definition term="template">
    Exports the index template to stdout. You can specify the `--es.version` flag to further define what gets exported. Furthermore you can export the template to a file instead of `stdout` by defining a directory via `--dir`.
  </definition>
</definitions>


<definitions>
  <definition term="ilm-policy">
    Exports the index lifecycle management policy to stdout. You can specify the `--es.version` and a `--dir` to which the policy should be exported as a file rather than exporting to `stdout`.
  </definition>
</definitions>


<definitions>
  <definition term="pipeline">
    Exports the ingest piplines.  You must specify the `--es.version` to specify which version of Elasticsearch the pipelines should be compatible with. You can optionally specify `--dir` to control where the pipelines are written.
  </definition>
</definitions>

**FLAGS**
<definitions>
  <definition term="--es.version VERSION">
    When used with [`template`](#template-subcommand), exports an index template that is compatible with the specified version.  When used with [`ilm-policy`](#ilm-policy-subcommand), exports the ILM policy if the specified ES version is enabled for ILM.  When used with [`pipeline`](#pipeline-subcommand), exports versions of the pipeline that is compatible with the specified version.
  </definition>
  <definition term="-h, --help">
    Shows help for the `export` command.
  </definition>
  <definition term="--dir DIRNAME">
    Define a directory to which the template, pipelines, and ILM policy should be exported to as files instead of printing them to `stdout`.
  </definition>
  <definition term="--id DASHBOARD_ID">
    When used with [`dashboard`](#dashboard-subcommand), specifies the dashboard ID.
  </definition>
</definitions>

Also see [Global flags](#global-flags).
**EXAMPLES**
```sh
winlogbeat export config
winlogbeat export template --es.version 9.3.0
winlogbeat export dashboard --id="a7b35890-8baa-11e8-9676-ef67484126fb" > dashboard.json
```


## `help` command

Shows help for any command. If no command is specified, shows help for the `run` command.
**SYNOPSIS**
```sh
winlogbeat help COMMAND_NAME [FLAGS]
```

<definitions>
  <definition term="COMMAND_NAME">
    Specifies the name of the command to show help for.
  </definition>
</definitions>

**FLAGS**
<definitions>
  <definition term="-h, --help">
    Shows help for the `help` command.
  </definition>
</definitions>

Also see [Global flags](#global-flags).
**EXAMPLE**
```sh
winlogbeat help export
```


## `keystore` command

Manages the [secrets keystore](https://www.elastic.co/docs/reference/beats/winlogbeat/keystore).
**SYNOPSIS**
```sh
winlogbeat keystore SUBCOMMAND [FLAGS]
```

**SUBCOMMANDS**
<definitions>
  <definition term="add KEY">
    Adds the specified key to the keystore. Use the `--force` flag to overwrite an existing key. Use the `--stdin` flag to pass the value through `stdin`.
  </definition>
  <definition term="create">
    Creates a keystore to hold secrets. Use the `--force` flag to overwrite the existing keystore.
  </definition>
  <definition term="list">
    Lists the keys in the keystore.
  </definition>
  <definition term="remove KEY">
    Removes the specified key from the keystore.
  </definition>
</definitions>

**FLAGS**
<definitions>
  <definition term="--force">
    Valid with the `add` and `create` subcommands. When used with `add`, overwrites the specified key. When used with `create`, overwrites the keystore.
  </definition>
  <definition term="--stdin">
    When used with `add`, uses the stdin as the source of the key’s value.
  </definition>
  <definition term="-h, --help">
    Shows help for the `keystore` command.
  </definition>
</definitions>

Also see [Global flags](#global-flags).
**EXAMPLES**
```sh
winlogbeat keystore create
winlogbeat keystore add ES_PWD
winlogbeat keystore remove ES_PWD
winlogbeat keystore list
```

See [Secrets keystore](https://www.elastic.co/docs/reference/beats/winlogbeat/keystore) for more examples.

## `run` command

Runs Winlogbeat. This command is used by default if you start Winlogbeat without specifying a command.
**SYNOPSIS**
```sh
winlogbeat run [FLAGS]
```

Or:
```sh
winlogbeat [FLAGS]
```

**FLAGS**
<definitions>
  <definition term="-N, --N">
    Disables publishing for testing purposes. This option disables all outputs except the [File output](https://www.elastic.co/docs/reference/beats/winlogbeat/file-output).
  </definition>
  <definition term="--cpuprofile FILE">
    Writes CPU profile data to the specified file. This option is useful for troubleshooting Winlogbeat.
  </definition>
  <definition term="-h, --help">
    Shows help for the `run` command.
  </definition>
  <definition term="--httpprof [HOST]:PORT">
    Starts an http server for profiling. This option is useful for troubleshooting and profiling Winlogbeat.
  </definition>
  <definition term="--memprofile FILE">
    Writes memory profile data to the specified output file. This option is useful for troubleshooting Winlogbeat.
  </definition>
  <definition term="--system.hostfs MOUNT_POINT">
    Specifies the mount point of the host’s filesystem for use in monitoring a host. This flag is depricated, and an alternate hostfs should be specified via the `hostfs` module config value.
  </definition>
</definitions>

Also see [Global flags](#global-flags).
**EXAMPLE**
```sh
winlogbeat run -e
```

Or:
```sh
winlogbeat -e
```


## `setup` command

Sets up the initial environment, including the index template, ILM policy and write alias, and Kibana dashboards (when available)
- The index template ensures that fields are mapped correctly in Elasticsearch. If index lifecycle management is enabled it also ensures that the defined ILM policy and write alias are connected to the indices matching the index template. The ILM policy takes care of the lifecycle of an index, when to do a rollover, when to move an index from the hot phase to the next phase, etc.
- The Kibana dashboards make it easier for you to visualize Winlogbeat data in Kibana.

This command sets up the environment without actually running Winlogbeat and ingesting data. Specify optional flags to set up a subset of assets.
**SYNOPSIS**
```sh
winlogbeat setup [FLAGS]
```

**FLAGS**
<definitions>
  <definition term="--dashboards">
    Sets up the Kibana dashboards (when available). This option loads the dashboards from the Winlogbeat package. For more options, such as loading customized dashboards, see [Importing Existing Beat Dashboards](https://www.elastic.co/docs/extend/beats/import-dashboards).
  </definition>
  <definition term="-h, --help">
    Shows help for the `setup` command.
  </definition>
  <definition term="--index-management">
    Sets up components related to Elasticsearch index management including template, ILM policy, and write alias (if supported and configured).
  </definition>
</definitions>

Also see [Global flags](#global-flags).
**EXAMPLES**
```sh
winlogbeat setup --dashboards
winlogbeat setup --index-management
```


## `test` command

Tests the configuration.
**SYNOPSIS**
```sh
winlogbeat test SUBCOMMAND [FLAGS]
```

**SUBCOMMANDS**
<definitions>
  <definition term="config">
    Tests the configuration settings.
  </definition>
  <definition term="output">
    Tests that Winlogbeat can connect to the output by using the current settings.
  </definition>
</definitions>

**FLAGS**
<definitions>
  <definition term="-h, --help">
    Shows help for the `test` command.
  </definition>
</definitions>

Also see [Global flags](#global-flags).
**EXAMPLE**
```sh
winlogbeat test config
```


## `version` command

Shows information about the current version.
**SYNOPSIS**
```sh
winlogbeat version [FLAGS]
```

**FLAGS**
<definitions>
  <definition term="-h, --help">
    Shows help for the `version` command.
  </definition>
</definitions>

Also see [Global flags](#global-flags).
**EXAMPLE**
```sh
winlogbeat version
```


## Global flags

These global flags are available whenever you run Winlogbeat.
<definitions>
  <definition term="-E, --E "SETTING_NAME=VALUE"">
    Overrides a specific configuration setting. You can specify multiple overrides. For example:
    ```sh
    winlogbeat -E "name=mybeat" -E "output.elasticsearch.hosts=['http://myhost:9200']"
    ```
    This setting is applied to the currently running Winlogbeat process. The Winlogbeat configuration file is not changed.
  </definition>
  <definition term="-c, --c FILE">
    Specifies the configuration file to use for Winlogbeat. The file you specify here is relative to `path.config`. If the `-c` flag is not specified, the default config file, `winlogbeat.yml`, is used.
  </definition>
  <definition term="-d, --d SELECTORS">
    Enables debugging for the specified selectors. For the selectors, you can specify a comma-separated list of components, or you can use `-d "*"` to enable debugging for all components. For example, `-d "publisher"` displays all the publisher-related messages.
  </definition>
  <definition term="-e, --e">
    Logs to stderr and disables syslog/file output.
  </definition>
  <definition term="--environment">
    For logging purposes, specifies the environment that Winlogbeat is running in. This setting is used to select a default log output when no log output is configured. Supported values are: `systemd`, `container`, `macos_service`, and `windows_service`. If `systemd` or `container` is specified, Winlogbeat will log to stdout and stderr by default.
  </definition>
  <definition term="--path.config">
    Sets the path for configuration files. See the [Directory layout](https://www.elastic.co/docs/reference/beats/winlogbeat/directory-layout) section for details.
  </definition>
  <definition term="--path.data">
    Sets the path for data files. See the [Directory layout](https://www.elastic.co/docs/reference/beats/winlogbeat/directory-layout) section for details.
  </definition>
  <definition term="--path.home">
    Sets the path for miscellaneous files. See the [Directory layout](https://www.elastic.co/docs/reference/beats/winlogbeat/directory-layout) section for details.
  </definition>
  <definition term="--path.logs">
    Sets the path for log files. See the [Directory layout](https://www.elastic.co/docs/reference/beats/winlogbeat/directory-layout) section for details.
  </definition>
  <definition term="--strict.perms">
    Sets strict permission checking on configuration files. The default is `--strict.perms=true`. See [Config file ownership and permissions](https://www.elastic.co/docs/reference/beats/libbeat/config-file-permissions) for more information.
  </definition>
  <definition term="-v, --v">
    Logs INFO-level messages.
  </definition>
</definitions>