﻿---
title: Grant access using API keys
description: Instead of using usernames and passwords, you can use API keys to grant access to Elasticsearch resources. You can set API keys to expire at a certain...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/beats-api-keys
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Grant access using API keys
Instead of using usernames and passwords, you can use API keys to grant access to Elasticsearch resources. You can set API keys to expire at a certain time, and you can explicitly invalidate them. Any user with the `manage_api_key` or `manage_own_api_key` cluster privilege can create API keys.
Winlogbeat instances typically send both collected data and monitoring information to Elasticsearch. If you are sending both to the same cluster, you can use the same API key. For different clusters, you need to use an API key per cluster.
<note>
  For security reasons, we recommend using a unique API key per Winlogbeat instance. You can create as many API keys per user as necessary.
</note>

<important>
  Review [*Grant users access to secured resources*](https://www.elastic.co/docs/reference/beats/winlogbeat/feature-roles) before creating API keys for Winlogbeat.
</important>


## Create an API key for publishing

To create an API key to use for writing data to Elasticsearch, use the [Create API key API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-api-key), for example:
```json

{
  "name": "winlogbeat_host001", <1>
  "role_descriptors": {
    "winlogbeat_writer": { <2>
      "cluster": ["monitor", "read_ilm", "read_pipeline"],
      "index": [
        {
          "names": ["winlogbeat-*"],
          "privileges": ["view_index_metadata", "create_doc", "auto_configure"]
        }
      ]
    }
  }
}
```

<note>
  See [Create a *publishing* user](https://www.elastic.co/docs/reference/beats/winlogbeat/privileges-to-publish-events) for the list of privileges required to publish events.
</note>

The return value will look something like this:
```json
{
  "id":"TiNAGG4BaaMdaH1tRfuU", 
  "name":"winlogbeat_host001",
  "api_key":"KnR6yE41RrSowb0kQ0HWoA" 
}
```

You can now use this API key in your `winlogbeat.yml` configuration file like this:
```yaml
output.elasticsearch:
  api_key: TiNAGG4BaaMdaH1tRfuU:KnR6yE41RrSowb0kQ0HWoA 
```


## Create an API key for monitoring

To create an API key to use for sending monitoring data to Elasticsearch, use the [Create API key API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-api-key), for example:
```json

{
  "name": "winlogbeat_host001", <1>
  "role_descriptors": {
    "winlogbeat_monitoring": { <2>
      "cluster": ["monitor"],
      "index": [
        {
          "names": [".monitoring-beats-*"],
          "privileges": ["create_index", "create"]
        }
      ]
    }
  }
}
```

<note>
  See [Create a *monitoring* user](https://www.elastic.co/docs/reference/beats/winlogbeat/privileges-to-publish-monitoring) for the list of privileges required to send monitoring data.
</note>

The return value will look something like this:
```json
{
  "id":"TiNAGG4BaaMdaH1tRfuU", 
  "name":"winlogbeat_host001",
  "api_key":"KnR6yE41RrSowb0kQ0HWoA" 
}
```

You can now use this API key in your `winlogbeat.yml` configuration file like this:
```yaml
monitoring.elasticsearch:
  api_key: TiNAGG4BaaMdaH1tRfuU:KnR6yE41RrSowb0kQ0HWoA 
```


## Learn more about API keys

See the Elasticsearch API key documentation for more information:
- [Create API key](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-api-key)
- [Get API key information](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-get-api-key)
- [Invalidate API key](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-invalidate-api-key)