﻿---
title: Beats
description: Beats are lightweight data shippers that send operational data to Elasticsearch. Elastic provides separate Beats for different types of data, such as...
url: https://www.elastic.co/docs/reference/beats/serverless/beats
products:
  - Beats
  - Elastic Cloud Serverless
---

# Beats
Beats are lightweight data shippers that send operational data to Elasticsearch. Elastic provides separate Beats for different types of data, such as logs, metrics, and uptime. Depending on what data you want to collect, you may need to install multiple shippers on a single host.

| Data                   | Beats                                                                |
|------------------------|----------------------------------------------------------------------|
| Audit data             | [Auditbeat](https://www.elastic.co/docs/reference/beats/auditbeat)   |
| Log files and journals | [Filebeat](https://www.elastic.co/docs/reference/beats/filebeat)     |
| Availability           | [Heartbeat](https://www.elastic.co/docs/reference/beats/heartbeat)   |
| Metrics                | [Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat) |
| Network traffic        | [Packetbeat](https://www.elastic.co/docs/reference/beats/packetbeat) |
| Windows event logs     | [Winlogbeat](https://www.elastic.co/docs/reference/beats/winlogbeat) |

Beats can send data to Elasticsearch directly or through Logstash, where you can further process and enhance the data before visualizing it in Kibana.
<admonition title="Authenticating with Elasticsearch">
  When you use Beats to export data to an Elasticsearch Serverless project, the Beats require an API key to authenticate with Elasticsearch. Refer to [Create API key](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/search-connection-details#create-an-api-key-serverless) for the steps to set up your API key, and to [Grant access using API keys](https://www.elastic.co/docs/reference/beats/filebeat/beats-api-keys) in the Filebeat documentation for an example of how to configure your Beats to use the key.
</admonition>

Check out [Get started with Beats](https://www.elastic.co/docs/reference/beats) for some next steps.