﻿---
title: Secure Packetbeat
description: The following topics provide information about securing the Packetbeat process and connecting to a cluster that has security features enabled. You can...
url: https://www.elastic.co/docs/reference/beats/packetbeat/securing-packetbeat
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Secure Packetbeat
The following topics provide information about securing the Packetbeat process and connecting to a cluster that has security features enabled.
You can use role-based access control and optionally, API keys to grant Packetbeat users access to secured resources.
- [*Grant users access to secured resources*](https://www.elastic.co/docs/reference/beats/packetbeat/feature-roles)
- [*Grant access using API keys*](https://www.elastic.co/docs/reference/beats/packetbeat/beats-api-keys).

After privileged users have been created, use authentication to connect to a secured Elastic cluster.
- [*Secure communication with Elasticsearch*](https://www.elastic.co/docs/reference/beats/packetbeat/securing-communication-elasticsearch)
- [*Secure communication with Logstash*](https://www.elastic.co/docs/reference/beats/packetbeat/configuring-ssl-logstash)

On Linux, Packetbeat can take advantage of secure computing mode to restrict the system calls that a process can issue.
- [*Use Linux Secure Computing Mode (seccomp)*](https://www.elastic.co/docs/reference/beats/packetbeat/linux-seccomp)