﻿---
title: Replace fields from events
description: The replace processor takes a list of fields to search for a matching value and replaces the matching value with a specified string. The replace processor...
url: https://www.elastic.co/docs/reference/beats/packetbeat/replace-fields
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Replace fields from events
The `replace` processor takes a list of fields to search for a matching value and replaces the matching value with a specified string.
The `replace` processor cannot be used to create a completely new value.
<tip>
  You can use this processor to truncate a field value or replace it with a new string value. You can also use this processor to mask PII information.
</tip>


## Example

The following example changes the path from `/usr/bin` to `/usr/local/bin`:
```yaml
  - replace:
      fields:
        - field: "file.path"
          pattern: "/usr/"
          replacement: "/usr/local/"
      ignore_missing: false
      fail_on_error: true
```


## Configuration settings


| Name             | Required | Default | Description                                                                                                                                                                                                                                                                                                                                                                                                                                 |
|------------------|----------|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `fields`         | Yes      |         | List of one or more items. Each item contains a `field: field-name`, `pattern: regex-pattern`, and `replacement: replacement-string`, where:* `field` is the original field name. You can use the `@metadata.` prefix in this field to replace values in the event metadata instead of event fields.* `pattern` is the regex pattern to match the field’s value* `replacement` is the replacement string to use to update the field’s value |
| `ignore_missing` | No       | `false` | Whether to ignore missing fields. If `true`, no error is logged if the specified field is missing.                                                                                                                                                                                                                                                                                                                                          |
| `fail_on_error`  | No       | `true`  | Whether to fail replacement of field values if an error occurs.If `true` and there’s an error, the replacement of field values is stopped, and the original event is returned.If `false`, replacement continues even if an error occurs during replacement.                                                                                                                                                                                 |

See [Conditions](/docs/reference/beats/packetbeat/defining-processors#conditions) for a list of supported conditions.