﻿---
title: Fields show up as nested JSON in Kibana
description: When Packetbeat exports a field of type dictionary, and the keys are not known in advance, the Discovery page in Kibana will display the field as a nested...
url: https://www.elastic.co/docs/reference/beats/packetbeat/refresh-index-pattern
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Fields show up as nested JSON in Kibana
When Packetbeat exports a field of type dictionary, and the keys are not known in advance, the Discovery page in Kibana will display the field as a nested JSON object:
```shell
http.response.headers = {
        "content-length": 12,
        "content-type": "application/json"
}
```

To fix this you need to [reload the index pattern](https://www.elastic.co/docs/explore-analyze/find-and-organize/data-views) in Kibana under the Management→Index Patterns, and the index pattern will be updated with a field for each key available in the dictionary:
```shell
http.response.headers.content-length = 12
http.response.headers.content-type = "application/json"
```