﻿---
title: Start Packetbeat
description: Before starting Packetbeat: Follow the steps in Quick start: installation and configuration to install, configure, and set up the Packetbeat environment.Make...
url: https://www.elastic.co/docs/reference/beats/packetbeat/packetbeat-starting
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Start Packetbeat
Before starting Packetbeat:
- Follow the steps in [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/packetbeat/packetbeat-installation-configuration) to install, configure, and set up the Packetbeat environment.
- Make sure Kibana and Elasticsearch are running.
- Make sure the user specified in `packetbeat.yml` is [authorized to publish events](https://www.elastic.co/docs/reference/beats/packetbeat/privileges-to-publish-events).

To start Packetbeat, run:
<tab-set>
  <tab-item title="DEB">
    ```sh
    sudo service packetbeat start
    ```

    <note>
      If you use an `init.d` script to start Packetbeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/packetbeat/command-line-options)). To specify flags, start Packetbeat in the foreground.
    </note>
    Also see [Packetbeat and systemd](https://www.elastic.co/docs/reference/beats/packetbeat/running-with-systemd).
  </tab-item>

  <tab-item title="RPM">
    ```sh
    sudo service packetbeat start
    ```

    <note>
      If you use an `init.d` script to start Packetbeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/packetbeat/command-line-options)). To specify flags, start Packetbeat in the foreground.
    </note>
    Also see [Packetbeat and systemd](https://www.elastic.co/docs/reference/beats/packetbeat/running-with-systemd).
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    sudo chown root packetbeat.yml 
    sudo ./packetbeat -e
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    sudo chown root packetbeat.yml 
    sudo ./packetbeat -e
    ```
  </tab-item>

  <tab-item title="Windows">
    ```sh
    PS C:\Program Files\packetbeat> Start-Service packetbeat
    ```
    By default Windows log files are stored in `C:\Program Files\Packetbeat-Data\logs`.
    <note>
      In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\packetbeat\logs`.
    </note>
  </tab-item>
</tab-set>