﻿---
title: Capture PgSQL traffic
description: The pgsql sections of the packetbeat.yml config file specifies configuration options for the PgSQL protocols. Also see Common protocol options. The maximum...
url: https://www.elastic.co/docs/reference/beats/packetbeat/packetbeat-pgsql-options
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Capture PgSQL traffic
The `pgsql` sections of the `packetbeat.yml` config file specifies configuration options for the PgSQL protocols.
```yaml
packetbeat.protocols:

- type: pgsql
  ports: [5432]
```


## Configuration options

Also see [Common protocol options](https://www.elastic.co/docs/reference/beats/packetbeat/common-protocol-options).

### `max_rows`

The maximum number of rows from the SQL message to publish to Elasticsearch. The default is 10 rows.

### `max_row_length`

The maximum length in bytes of a row from the SQL message to publish to Elasticsearch. The default is 1024 bytes.