﻿---
title: Capture MySQL traffic
description: The mysql section of the packetbeat.yml config file specifies configuration options for the MySQL protocols. Also see Common protocol options. The maximum...
url: https://www.elastic.co/docs/reference/beats/packetbeat/packetbeat-mysql-options
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Capture MySQL traffic
The `mysql` section of the `packetbeat.yml` config file specifies configuration options for the MySQL protocols.
```yaml
packetbeat.protocols:

- type: mysql
  ports: [3306,3307]
```


## Configuration options

Also see [Common protocol options](https://www.elastic.co/docs/reference/beats/packetbeat/common-protocol-options).

### `max_rows`

The maximum number of rows from the SQL message to publish to Elasticsearch. The default is 10 rows.

### `max_row_length`

The maximum length in bytes of a row from the SQL message to publish to Elasticsearch. The default is 1024 bytes.

## `statement_timeout`

The duration for which prepared statements are cached after their last use. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h". The default is `1h`.