﻿---
title: Capture Memcache traffic
description: The memcache section of the packetbeat.yml config file specifies configuration options for the memcache protocol. Here is a sample configuration section...
url: https://www.elastic.co/docs/reference/beats/packetbeat/packetbeat-memcache-options
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Capture Memcache traffic
The `memcache` section of the `packetbeat.yml` config file specifies configuration options for the memcache protocol. Here is a sample configuration section for memcache:
```yaml
packetbeat.protocols:
- type: memcache
  ports: [11211]
  parseunknown: false
  maxvalues: 0
  maxbytespervalue: 100
  transaction_timeout: 200
  udptransactiontimeout: 200
```


## Configuration options

Also see [Common protocol options](https://www.elastic.co/docs/reference/beats/packetbeat/common-protocol-options).

### `parseunknown`

When this option is enabled, it forces the memcache text protocol parser to accept unknown commands.
<note>
  The unknown commands MUST NOT contain a data part.
</note>


### `maxvalues`

The maximum number of values to store in the message (multi-get). All values will be base64 encoded.
The possible settings for this option are:
- `maxvalue: -1`, which stores all values (text based protocol multi-get)
- `maxvalue: 0`, which stores no values (default)
- `maxvalue: N`, which stores up to N values


### `maxbytespervalue`

The maximum number of bytes to be copied for each value element.
<note>
  Values will be base64 encoded, so the actual size in the JSON document will be 4 times the value that you specify for `maxbytespervalue`.
</note>


### `udptransactiontimeout`

The transaction timeout in milliseconds. The defaults is 10000 milliseconds.
<note>
  Quiet messages in UDP binary protocol get responses only if there is an error. The memcache protocol analyzer will wait for the number of milliseconds specified by `udptransactiontimeout` before publishing quiet messages. Non-quiet messages or quiet requests with an error response are published immediately.
</note>