﻿---
title: Packetbeat quick start: installation and configuration
description: The best way to understand the value of a network packet analytics system like Packetbeat is to try it on your own traffic. This guide describes how to...
url: https://www.elastic.co/docs/reference/beats/packetbeat/packetbeat-installation-configuration
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Packetbeat quick start: installation and configuration
The best way to understand the value of a network packet analytics system like Packetbeat is to try it on your own traffic.
This guide describes how to get started quickly with network packets analytics. You’ll learn how to:
- install Packetbeat on each system you want to monitor
- specify the network devices and protocols to sniff
- parse the packet data into fields and send it to Elasticsearch
- visualize the packet data in Kibana

![Packetbeat Overview dashboard](https://www.elastic.co/docs/reference/beats/packetbeat/images/packetbeat-overview-dashboard.png)

## Before you begin

- You need Elasticsearch for storing and searching your data, and Kibana for visualizing and managing it.
  <applies-switch>
  <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
  To get started quickly, spin up a deployment of [Elastic Cloud Hosted](https://www.elastic.co/cloud). The Elastic Cloud Hosted is available on AWS, GCP, and Azure. [Try it out for free](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
  </applies-item>

  <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
  To install and run Elasticsearch and Kibana, see [Installing the Elastic Stack](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch).
  </applies-item>
  </applies-switch>
- On most platforms, Packetbeat requires the libpcap packet capture library. Depending on your OS, you might need to install it:
  <tab-set>
  <tab-item title="DEB">
  ```sh
  sudo apt-get install libpcap0.8
  ```
  </tab-item>

  <tab-item title="RPM">
  ```sh
  sudo yum install libpcap
  ```
  </tab-item>

  <tab-item title="MacOS">
  You probably do not need to install libpcap.
  </tab-item>

  <tab-item title="Linux">
  You probably do not need to install libpcap.
  </tab-item>

  <tab-item title="Windows">
  You probably do not need to install libpcap. The default distribution of Packetbeat for Windows comes bundled with the Npcap library.For the OSS-only distribution, you must download and install a packet sniffing library, such as [Npcap](https://nmap.org/npcap/), that implements the [libpcap](https://github.com/the-tcpdump-group/libpcap) interfaces.If you use Npcap, make sure you install it in WinPcap API-compatible mode. If you plan to capture traffic from the loopback device (127.0.0.1 traffic), also select the option to support loopback traffic.
  </tab-item>
  </tab-set>


## Step 1: Install Packetbeat

<tab-set>
  <tab-item title="DEB">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/packetbeat/packetbeat-9.3.0-amd64.deb
    sudo dpkg -i packetbeat-9.3.0-amd64.deb
    ```
  </tab-item>

  <tab-item title="RPM">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/packetbeat/packetbeat-9.3.0-x86_64.rpm
    sudo rpm -vi packetbeat-9.3.0-x86_64.rpm
    ```
  </tab-item>

  <tab-item title="MacOS">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/packetbeat/packetbeat-9.3.0-darwin-x86_64.tar.gz
    tar xzvf packetbeat-9.3.0-darwin-x86_64.tar.gz
    ```
  </tab-item>

  <tab-item title="Linux">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/packetbeat/packetbeat-9.3.0-linux-x86_64.tar.gz
    tar xzvf packetbeat-9.3.0-linux-x86_64.tar.gz
    ```
  </tab-item>

  <tab-item title="Windows">
    1. Download the [Packetbeat Windows zip file](https://artifacts.elastic.co/downloads/beats/packetbeat/packetbeat-9.3.0-windows-x86_64.zip).
    2. Extract the contents of the zip file into `C:\Program Files`.
    3. Rename the `packetbeat-[version]-windows-x86_64` directory to `Packetbeat`.
    4. Open a PowerShell prompt as an Administrator (right-click the PowerShell icon and select *Run As Administrator*).
    5. From the PowerShell prompt, run the following commands to install Packetbeat as a Windows service:

    ```shell
    PS > cd 'C:\Program Files\Packetbeat'
    PS C:\Program Files\Packetbeat> .\install-service-packetbeat.ps1
    ```

    <note>
      If script execution is disabled on your system, you need to set the execution policy for the current session to allow the script to run. For example: `PowerShell.exe -ExecutionPolicy UnRestricted -File .\install-service-packetbeat.ps1`.
    </note>

    <important applies-to="Elastic Stack: Generally available since 9.0.6">
      The base folder has changed from `C:\ProgramData\` to `C:\Program Files\`
      because the latter has stricter permissions. The home path (base for
      state and logs) is now `C:\Program Files\Packetbeat-Data`.The install script (`install-service-packetbeat.ps1`) will check whether
      `C:\ProgramData\Packetbeat` exits and move it to `C:\Program Files\Packetbeat-Data`.
      For more details on the installation script refer to: [install script](https://www.elastic.co/docs/reference/beats/packetbeat/packetbeat-installation-script).
    </important>
  </tab-item>
</tab-set>

The commands shown are for AMD platforms, but ARM packages are also available. Refer to the [download page](https://www.elastic.co/downloads/beats/packetbeat) for the full list of available packages.

### Other installation options

- [APT or YUM](https://www.elastic.co/docs/reference/beats/packetbeat/setup-repositories)
- [Download page](https://www.elastic.co/downloads/beats/packetbeat)
- [Docker](https://www.elastic.co/docs/reference/beats/packetbeat/running-on-docker)


## Step 2: Connect to the Elastic Stack

Connections to Elasticsearch and Kibana are required to set up Packetbeat.
Set the connection information in `packetbeat.yml`. To locate this configuration file, see [Directory layout](https://www.elastic.co/docs/reference/beats/packetbeat/directory-layout).
<applies-switch>
  <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
    Specify the [cloud.id](https://www.elastic.co/docs/reference/beats/packetbeat/configure-cloud-id) of your Elastic Cloud Hosted deployment, and set [cloud.auth](https://www.elastic.co/docs/reference/beats/packetbeat/configure-cloud-id) to a user who is authorized to set up Packetbeat. For example:
    ```yaml
    cloud.id: "staging:dXMtZWFzdC0xLmF3cy5mb3VuZC5pbyRjZWM2ZjI2MWE3NGJmMjRjZTMzYmI4ODExYjg0Mjk0ZiRjNmMyY2E2ZDA0MjI0OWFmMGNjN2Q3YTllOTYyNTc0Mw=="
    cloud.auth: "packetbeat_setup:YOUR_PASSWORD" 
    ```
  </applies-item>

  <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
    1. Set the host and port where Packetbeat can find the Elasticsearch installation, and set the username and password of a user who is authorized to set up Packetbeat. For example:
       ```yaml
       output.elasticsearch:
         hosts: ["https://myEShost:9200"]
         username: "packetbeat_internal"
         password: "YOUR_PASSWORD" 
         ssl:
           enabled: true
           ca_trusted_fingerprint: "b9a10bbe64ee9826abeda6546fc988c8bf798b41957c33d05db736716513dc9c" 
       ```
    2. If you plan to use our pre-built Kibana dashboards, configure the Kibana endpoint. Skip this step if Kibana is running on the same host as Elasticsearch.
       ```yaml
         setup.kibana:
           host: "mykibanahost:5601" 
           username: "my_kibana_user" <2> 
           password: "YOUR_PASSWORD"
       ```
  </applies-item>
</applies-switch>

To learn more about required roles and privileges, see [*Grant users access to secured resources*](https://www.elastic.co/docs/reference/beats/packetbeat/feature-roles).
<note>
  You can send data to other [outputs](https://www.elastic.co/docs/reference/beats/packetbeat/configuring-output), such as Logstash, but that requires additional configuration and setup.
</note>


## Step 3: Configure sniffing

In `packetbeat.yml`, configure the network devices and protocols to capture traffic from.
1. Set the sniffer type. By default, Packetbeat uses `pcap`, which uses the libpcap library and works on most platforms.
   On Linux, set the sniffer type to `af_packet` to use memory-mapped sniffing. This option is faster than libpcap and doesn’t require a kernel module, but it’s Linux-specific:
   ```yaml
   packetbeat.interfaces.type: af_packet
   ```
2. Specify the network device to capture traffic from. For example:
   ```yaml
   packetbeat.interfaces.device: eth0
   ```
   <tip>
   On Linux, specify `packetbeat.interfaces.device: any` to capture all messages sent or received by the server where Packetbeat is installed. The `any` setting does not work on macOS.
   </tip>
   To see a list of available devices, run:
   <tab-set>
   <tab-item title="DEB">
   ```shell
   packetbeat devices
   ```
   </tab-item>

   <tab-item title="RPM">
   ```shell
   packetbeat devices
   ```
   </tab-item>

   <tab-item title="MacOS">
   ```shell
   ./packetbeat devices
   ```
   </tab-item>

   <tab-item title="Linux">
   ```shell
   ./packetbeat devices
   ```
   </tab-item>

   <tab-item title="Windows">
   ```shell
   PS C:\Program Files\Packetbeat> .\packetbeat.exe devices

   0: \Device\NPF_{113535AD-934A-452E-8D5F-3004797DE286} (Intel(R) PRO/1000 MT Desktop Adapter)
   ```
   In this example, there’s only one network card, with the index 0, installed on the system. If there are multiple network cards, remember the index of the device you want to use for capturing the traffic.Modify the `device` setting to point to the index of the device:
   ```shell
   packetbeat.interfaces.device: 0
   ```
   </tab-item>
   </tab-set>
   For more information about these settings, see Traffic sniffing.
3. In the `protocols` section, configure the ports where Packetbeat can find each protocol. If you use any non-standard ports, add them here. Otherwise, use the default values.
   ```yaml
   packetbeat.protocols:

   - type: dhcpv4
     ports: [67, 68]

   - type: dns
     ports: [53]

   - type: http
     ports: [80, 8080, 8081, 5000, 8002]

   - type: memcache
     ports: [11211]

   - type: mysql
     ports: [3306,3307]

   - type: pgsql
     ports: [5432]

   - type: redis
     ports: [6379]

   - type: thrift
     ports: [9090]

   - type: mongodb
     ports: [27017]

   - type: cassandra
     ports: [9042]

   - type: tls
     ports: [443, 993, 995, 5223, 8443, 8883, 9243]
   ```

<tip>
  To test your configuration file, change to the directory where the Packetbeat binary is installed, and run Packetbeat in the foreground with the following options specified: `sudo ./packetbeat test config -e`. Make sure your config files are in the path expected by Packetbeat (see [Directory layout](https://www.elastic.co/docs/reference/beats/packetbeat/directory-layout)), or use the `-c` flag to specify the path to the config file. Depending on your OS, you might run into file ownership issues when you run this test. See [Config File Ownership and Permissions](https://www.elastic.co/docs/reference/beats/libbeat/config-file-permissions) for more information.
</tip>

For more information about configuring Packetbeat, also see:
- [Configure Packetbeat](https://www.elastic.co/docs/reference/beats/packetbeat/configuring-howto-packetbeat)
- [Config file format](https://www.elastic.co/docs/reference/beats/libbeat/config-file-format)
- [`packetbeat.reference.yml`](https://www.elastic.co/docs/reference/beats/packetbeat/packetbeat-reference-yml): This reference configuration file shows all non-deprecated options. You’ll find it in the same location as `packetbeat.yml`.


## Step 4: Set up assets

Packetbeat comes with predefined assets for parsing, indexing, and visualizing your data. To load these assets:
1. Make sure the user specified in packetbeat.yml is [authorized to set up Packetbeat](https://www.elastic.co/docs/reference/beats/packetbeat/privileges-to-setup-beats).
2. From the installation directory, run:
   <tab-set>
   <tab-item title="DEB">
   ```sh
   packetbeat setup -e
   ```
   </tab-item>

   <tab-item title="RPM">
   ```sh
   packetbeat setup -e
   ```
   </tab-item>

   <tab-item title="MacOS">
   ```sh
   ./packetbeat setup -e
   ```
   </tab-item>

   <tab-item title="Linux">
   ```sh
   ./packetbeat setup -e
   ```
   </tab-item>

   <tab-item title="Windows">
   ```sh
   PS > .\packetbeat.exe setup -e
   ```
   </tab-item>
   </tab-set>
   `-e` is optional and sends output to standard error instead of the configured log output.

By default Windows log files are stored in `C:\Program Files\Packetbeat-Data\logs`.
<note>
  In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\packetbeat\logs`.
</note>

This step loads the recommended [index template](https://www.elastic.co/docs/manage-data/data-store/templates) for writing to Elasticsearch and deploys the sample dashboards for visualizing the data in Kibana.
<tip>
  A connection to Elasticsearch (or Elastic Cloud Hosted) is required to set up the initial environment. If you’re using a different output, such as Logstash, see [Load the index template manually](/docs/reference/beats/packetbeat/packetbeat-template#load-template-manually) and [Load Kibana dashboards](https://www.elastic.co/docs/reference/beats/packetbeat/load-kibana-dashboards).
</tip>


## Step 5: Start Packetbeat

Before starting Packetbeat, modify the user credentials in `packetbeat.yml` and specify a user who is [authorized to publish events](https://www.elastic.co/docs/reference/beats/packetbeat/privileges-to-publish-events).
To start Packetbeat, run:
<tab-set>
  <tab-item title="DEB">
    ```sh
    sudo service packetbeat start
    ```

    <note>
      If you use an `init.d` script to start Packetbeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/packetbeat/command-line-options)). To specify flags, start Packetbeat in the foreground.
    </note>
    Also see [Packetbeat and systemd](https://www.elastic.co/docs/reference/beats/packetbeat/running-with-systemd).
  </tab-item>

  <tab-item title="RPM">
    ```sh
    sudo service packetbeat start
    ```

    <note>
      If you use an `init.d` script to start Packetbeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/packetbeat/command-line-options)). To specify flags, start Packetbeat in the foreground.
    </note>
    Also see [Packetbeat and systemd](https://www.elastic.co/docs/reference/beats/packetbeat/running-with-systemd).
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    sudo chown root packetbeat.yml 
    sudo ./packetbeat -e
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    sudo chown root packetbeat.yml 
    sudo ./packetbeat -e
    ```
  </tab-item>

  <tab-item title="Windows">
    ```sh
    PS C:\Program Files\packetbeat> Start-Service packetbeat
    ```
    By default Windows log files are stored in `C:\Program Files\Packetbeat-Data\logs`.
    <note>
      In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\packetbeat\logs`.
    </note>
  </tab-item>
</tab-set>

Packetbeat should begin streaming data to Elasticsearch.

## Step 6: View your data in Kibana

Packetbeat comes with pre-built Kibana dashboards and UIs for visualizing log data. You loaded the dashboards earlier when you ran the `setup` command.
To open the dashboards:
1. Launch Kibana:
   <applies-switch>
   <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
   1. [Log in](https://cloud.elastic.co/) to your Elastic Cloud account.
   2. Navigate to the Kibana endpoint in your deployment.
   </applies-item>

   <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
   Point your browser to [http://localhost:5601](http://localhost:5601), replacing `localhost` with the name of the Kibana host.
   </applies-item>
   </applies-switch>
2. In the side navigation, click **Discover**. To see Packetbeat data, make sure the predefined `packetbeat-*` data view is selected.
   <tip>
   If you don’t see data in Kibana, try changing the time filter to a larger range. By default, Kibana shows the last 15 minutes.
   </tip>
3. In the side navigation, click **Dashboard**, then select the dashboard that you want to open.

The dashboards are provided as examples. We recommend that you [customize](https://www.elastic.co/docs/explore-analyze/dashboards) them to meet your needs.
<tip>
  To populate the client locations map in the overview dashboard, follow the steps described in [*Enrich events with geoIP information*](https://www.elastic.co/docs/reference/beats/packetbeat/packetbeat-geoip).
</tip>


## What’s next?

Now that you have your data streaming into Elasticsearch, learn how to unify your logs, metrics, uptime, and application performance data.
1. Ingest data from other sources by installing and configuring other Elastic Beats:
   | Elastic Beats                                                                                              | To capture                      |
   |------------------------------------------------------------------------------------------------------------|---------------------------------|
   | [Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-configuration) | Infrastructure metrics          |
   | [Filebeat](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration)       | Logs                            |
   | [Winlogbeat](https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-installation-configuration) | Windows event logs              |
   | [Heartbeat](https://www.elastic.co/docs/reference/beats/heartbeat/heartbeat-installation-configuration)    | Uptime information              |
   | [APM](https://www.elastic.co/docs/solutions/observability/apm)                                             | Application performance metrics |
   | [Auditbeat](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-installation-configuration)    | Audit events                    |
2. Use the Observability apps in Kibana to search across all your data:
   | Elastic apps                                                                                                           | Use to                                                           |
   |------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------|
   | [Metrics app](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics) | Explore metrics about systems and services across your ecosystem |
   | [Logs app](https://www.elastic.co/docs/solutions/observability/logs/explore-logs)                                      | Tail related log data in real time                               |
   | [Uptime app](https://www.elastic.co/docs/solutions/observability/synthetics#monitoring-uptime)                         | Monitor availability issues across your apps and services        |
   | [APM app](https://www.elastic.co/docs/solutions/observability/apm/overviews)                                           | Monitor application performance                                  |
   | [SIEM app](https://www.elastic.co/docs/solutions/security)                                                             | Analyze security events                                          |