﻿---
title: Capture DNS traffic
description: The dns section of the packetbeat.yml config file specifies configuration options for the DNS protocol. The DNS protocol supports processing DNS messages...
url: https://www.elastic.co/docs/reference/beats/packetbeat/packetbeat-dns-options
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Capture DNS traffic
The `dns` section of the `packetbeat.yml` config file specifies configuration options for the DNS protocol. The DNS protocol supports processing DNS messages on TCP and UDP. Here is a sample configuration section for DNS:
```yaml
packetbeat.protocols:
- type: dns
  ports: [53]
  include_authorities: true
  include_additionals: true
```


## Configuration options

Also see [Common protocol options](https://www.elastic.co/docs/reference/beats/packetbeat/common-protocol-options).

### `include_authorities`

If this option is enabled, dns.authority fields (authority resource records) are added to DNS events. The default is false.

### `include_additionals`

If this option is enabled, dns.additionals fields (additional resource records) are added to DNS events. The default is false.