﻿---
title: Load ingest pipelines
description: Packetbeat modules are implemented using Elasticsearch ingest node pipelines.  The events receive their transformations within Elasticsearch.  The ingest...
url: https://www.elastic.co/docs/reference/beats/packetbeat/load-ingest-pipelines
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Load ingest pipelines
Packetbeat modules are implemented using Elasticsearch ingest node pipelines.  The events receive their transformations within Elasticsearch.  The ingest node pipelines must be loaded into Elasticsearch.  This can happen one of several ways.

## On connection to Elasticsearch

Packetbeat will send ingest pipelines automatically to Elasticsearch if the Elasticsearch output is enabled.
Make sure the user specified in `packetbeat.yml` is [authorized to set up Packetbeat](https://www.elastic.co/docs/reference/beats/packetbeat/privileges-to-setup-beats).
If Packetbeat is sending events to Logstash or another output you need to load the ingest pipelines with the `setup` command or manually.

## Manually install pipelines

Pipelines can be loaded them into Elasticsearch with the `_ingest/pipeline` REST API call. The user making the REST API call will need to have the `ingest_admin` role assigned to them.