﻿---
title: Grant privileges and roles needed to read Packetbeat data from Kibana
description: Kibana users typically need to view dashboards and visualizations that contain Packetbeat data. These users might also need to create and edit dashboards...
url: https://www.elastic.co/docs/reference/beats/packetbeat/kibana-user-privileges
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Grant privileges and roles needed to read Packetbeat data from Kibana
Kibana users typically need to view dashboards and visualizations that contain Packetbeat data. These users might also need to create and edit dashboards and visualizations.
To grant users the required privileges:
1. Create a **reader role**, called something like `packetbeat_reader`, that has the following privilege:
   | Type   | Privilege                                              | Purpose                                                                      |
   |--------|--------------------------------------------------------|------------------------------------------------------------------------------|
   | Index  | `read` on `packetbeat-*` indices                       | Read data indexed by Packetbeat                                              |
   | Spaces | `Read` or `All` on Dashboards, Visualize, and Discover | Allow the user to view, edit, and create dashboards, as well as browse data. |
2. Assign the **reader role**, along with the following built-in roles, to users who need to read Packetbeat data:
   | Role              | Purpose                                                                                                       |
   |-------------------|---------------------------------------------------------------------------------------------------------------|
   | `monitoring_user` | Allow users to monitor the health of Packetbeat itself. Only assign this role to users who manage Packetbeat. |