﻿---
title: Grant users access to secured resources
description: You can use role-based access control to grant users access to secured resources. The roles that you set up depend on your organization’s security requirements...
url: https://www.elastic.co/docs/reference/beats/packetbeat/feature-roles
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Grant users access to secured resources
You can use role-based access control to grant users access to secured resources. The roles that you set up depend on your organization’s security requirements and the minimum privileges required to use specific features.
Typically you need the create the following separate roles:
- [setup role](https://www.elastic.co/docs/reference/beats/packetbeat/privileges-to-setup-beats) for setting up index templates and other dependencies
- [monitoring role](https://www.elastic.co/docs/reference/beats/packetbeat/privileges-to-publish-monitoring) for sending monitoring information
- [writer role](https://www.elastic.co/docs/reference/beats/packetbeat/privileges-to-publish-events)  for publishing events collected by Packetbeat
- [reader role](https://www.elastic.co/docs/reference/beats/packetbeat/kibana-user-privileges) for Kibana users who need to view and create visualizations that access Packetbeat data

Elasticsearch security features provides [built-in roles](https://www.elastic.co/docs/reference/elasticsearch/roles) that grant a subset of the privileges needed by Packetbeat users. When possible, use the built-in roles to minimize the affect of future changes on your security strategy.
Instead of using usernames and passwords, roles and privileges can be assigned to API keys to grant access to Elasticsearch resources. See [*Grant access using API keys*](https://www.elastic.co/docs/reference/beats/packetbeat/beats-api-keys) for more information.