﻿---
title: Detailed TLS fields
description: Detailed TLS-specific event fields. The hello extensions provided by the client. Status request made to the server. The hello extensions provided by the...
url: https://www.elastic.co/docs/reference/beats/packetbeat/exported-fields-tls_detailed
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Detailed TLS fields
Detailed TLS-specific event fields.
<definitions>
  <definition term="tls.client.x509.version">
    Version of x509 format.
    type: keyword
    example: 3
  </definition>
  <definition term="tls.client.x509.issuer.province">
    Province or region within country.
    type: keyword
  </definition>
  <definition term="tls.client.x509.subject.province">
    Province or region within country.
    type: keyword
  </definition>
  <definition term="tls.server.x509.version">
    Version of x509 format.
    type: keyword
    example: 3
  </definition>
  <definition term="tls.server.x509.issuer.province">
    Province or region within country.
    type: keyword
  </definition>
  <definition term="tls.server.x509.subject.province">
    Province or region within country.
    type: keyword
  </definition>
  <definition term="tls.detailed.version">
    The version of the TLS protocol used.
    type: keyword
    example: TLS 1.3
  </definition>
  <definition term="tls.detailed.resumption_method">
    If the session has been resumed, the underlying method used. One of "id" for TLS session ID or "ticket" for TLS ticket extension.
    type: keyword
  </definition>
  <definition term="tls.detailed.client_certificate_requested">
    Whether the server has requested the client to authenticate itself using a client certificate.
    type: boolean
  </definition>
  <definition term="tls.detailed.ocsp_response">
    The result of an OCSP request.
    type: keyword
  </definition>
  <definition term="tls.detailed.client_hello.version">
    The version of the TLS protocol by which the client wishes to communicate during this session.
    type: keyword
  </definition>
  <definition term="tls.detailed.client_hello.random">
    Random data used by the TLS protocol to generate the encryption key.
    type: keyword
  </definition>
  <definition term="tls.detailed.client_hello.session_id">
    Unique number to identify the session for the corresponding connection with the client.
    type: keyword
  </definition>
  <definition term="tls.detailed.client_hello.supported_compression_methods">
    The list of compression methods the client supports. See [https://www.iana.org/assignments/comp-meth-ids/comp-meth-ids.xhtml](https://www.iana.org/assignments/comp-meth-ids/comp-meth-ids.xhtml)
    type: keyword
  </definition>
</definitions>


## extensions

The hello extensions provided by the client.
<definitions>
  <definition term="tls.detailed.client_hello.extensions.server_name_indication">
    List of hostnames
    type: keyword
  </definition>
  <definition term="tls.detailed.client_hello.extensions.application_layer_protocol_negotiation">
    List of application-layer protocols the client is willing to use.
    type: keyword
  </definition>
  <definition term="tls.detailed.client_hello.extensions.session_ticket">
    Length of the session ticket, if provided, or an empty string to advertise support for tickets.
    type: keyword
  </definition>
  <definition term="tls.detailed.client_hello.extensions.supported_versions">
    List of TLS versions that the client is willing to use.
    type: keyword
  </definition>
  <definition term="tls.detailed.client_hello.extensions.supported_groups">
    List of Elliptic Curve Cryptography (ECC) curve groups supported by the client.
    type: keyword
  </definition>
  <definition term="tls.detailed.client_hello.extensions.signature_algorithms">
    List of signature algorithms that may be use in digital signatures.
    type: keyword
  </definition>
  <definition term="tls.detailed.client_hello.extensions.ec_points_formats">
    List of Elliptic Curve (EC) point formats. Indicates the set of point formats that the client can parse.
    type: keyword
  </definition>
</definitions>


## status_request

Status request made to the server.
<definitions>
  <definition term="tls.detailed.client_hello.extensions.status_request.type">
    The type of the status request. Always "ocsp" if present.
    type: keyword
  </definition>
  <definition term="tls.detailed.client_hello.extensions.status_request.responder_id_list_length">
    The length of the list of trusted responders.
    type: short
  </definition>
  <definition term="tls.detailed.client_hello.extensions.status_request.request_extensions">
    The number of certificate extensions for the request.
    type: short
  </definition>
  <definition term="tls.detailed.client_hello.extensions._unparsed_">
    List of extensions that were left unparsed by Packetbeat.
    type: keyword
  </definition>
  <definition term="tls.detailed.server_hello.version">
    The version of the TLS protocol that is used for this session. It is the highest version supported by the server not exceeding the version requested in the client hello.
    type: keyword
  </definition>
  <definition term="tls.detailed.server_hello.random">
    Random data used by the TLS protocol to generate the encryption key.
    type: keyword
  </definition>
  <definition term="tls.detailed.server_hello.selected_compression_method">
    The compression method selected by the server from the list provided in the client hello.
    type: keyword
  </definition>
  <definition term="tls.detailed.server_hello.session_id">
    Unique number to identify the session for the corresponding connection with the client.
    type: keyword
  </definition>
</definitions>


## extensions

The hello extensions provided by the server.
<definitions>
  <definition term="tls.detailed.server_hello.extensions.application_layer_protocol_negotiation">
    Negotiated application layer protocol
    type: keyword
  </definition>
  <definition term="tls.detailed.server_hello.extensions.session_ticket">
    Used to announce that a session ticket will be provided by the server. Always an empty string.
    type: keyword
  </definition>
  <definition term="tls.detailed.server_hello.extensions.supported_versions">
    Negotiated TLS version to be used.
    type: keyword
  </definition>
  <definition term="tls.detailed.server_hello.extensions.ec_points_formats">
    List of Elliptic Curve (EC) point formats. Indicates the set of point formats that the server can parse.
    type: keyword
  </definition>
</definitions>


## status_request

Status request made to the server.
<definitions>
  <definition term="tls.detailed.server_hello.extensions.status_request.response">
    Whether a certificate status request response was made.
    type: boolean
  </definition>
  <definition term="tls.detailed.server_hello.extensions._unparsed_">
    List of extensions that were left unparsed by Packetbeat.
    type: keyword
  </definition>
  <definition term="tls.detailed.server_certificate_chain">
    Chain of trust for the server certificate.
    type: array
  </definition>
  <definition term="tls.detailed.client_certificate_chain">
    Chain of trust for the client certificate.
    type: array
  </definition>
  <definition term="tls.detailed.alert_types">
    An array containing the TLS alert type for every alert received.
    type: keyword
  </definition>
</definitions>