﻿---
title: SIP fields
description: SIP-specific event fields. Information about SIP traffic. 
url: https://www.elastic.co/docs/reference/beats/packetbeat/exported-fields-sip
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# SIP fields
SIP-specific event fields.

## sip

Information about SIP traffic.
<definitions>
  <definition term="sip.code">
    Response status code.
    type: keyword
  </definition>
  <definition term="sip.method">
    Request method.
    type: keyword
  </definition>
  <definition term="sip.status">
    Response status phrase.
    type: keyword
  </definition>
  <definition term="sip.type">
    Either request or response.
    type: keyword
  </definition>
  <definition term="sip.version">
    SIP protocol version.
    type: keyword
  </definition>
  <definition term="sip.uri.original">
    The original URI.
    type: keyword
  </definition>
  <definition term="sip.uri.original.text">
    type: text
  </definition>
  <definition term="sip.uri.scheme">
    The URI scheme.
    type: keyword
  </definition>
  <definition term="sip.uri.username">
    The URI user name.
    type: keyword
  </definition>
  <definition term="sip.uri.host">
    The URI host.
    type: keyword
  </definition>
  <definition term="sip.uri.port">
    The URI port.
    type: keyword
  </definition>
  <definition term="sip.accept">
    Accept header value.
    type: keyword
  </definition>
  <definition term="sip.allow">
    Allowed methods.
    type: keyword
  </definition>
  <definition term="sip.call_id">
    Call ID.
    type: keyword
  </definition>
  <definition term="sip.content_length">
    type: long
  </definition>
  <definition term="sip.content_type">
    type: keyword
  </definition>
  <definition term="sip.max_forwards">
    type: long
  </definition>
  <definition term="sip.supported">
    Supported methods.
    type: keyword
  </definition>
  <definition term="sip.user_agent.original">
    type: keyword
  </definition>
  <definition term="sip.user_agent.original.text">
    type: text
  </definition>
  <definition term="sip.private.uri.original">
    Private original URI.
    type: keyword
  </definition>
  <definition term="sip.private.uri.original.text">
    type: text
  </definition>
  <definition term="sip.private.uri.scheme">
    Private URI scheme.
    type: keyword
  </definition>
  <definition term="sip.private.uri.username">
    Private URI user name.
    type: keyword
  </definition>
  <definition term="sip.private.uri.host">
    Private URI host.
    type: keyword
  </definition>
  <definition term="sip.private.uri.port">
    Private URI port.
    type: keyword
  </definition>
  <definition term="sip.cseq.code">
    Sequence code.
    type: keyword
  </definition>
  <definition term="sip.cseq.method">
    Sequence method.
    type: keyword
  </definition>
  <definition term="sip.via.original">
    The original Via value.
    type: keyword
  </definition>
  <definition term="sip.via.original.text">
    type: text
  </definition>
  <definition term="sip.to.display_info">
    To display info
    type: keyword
  </definition>
  <definition term="sip.to.uri.original">
    To original URI
    type: keyword
  </definition>
  <definition term="sip.to.uri.original.text">
    type: text
  </definition>
  <definition term="sip.to.uri.scheme">
    To URI scheme
    type: keyword
  </definition>
  <definition term="sip.to.uri.username">
    To URI user name
    type: keyword
  </definition>
  <definition term="sip.to.uri.host">
    To URI host
    type: keyword
  </definition>
  <definition term="sip.to.uri.port">
    To URI port
    type: keyword
  </definition>
  <definition term="sip.to.tag">
    To tag
    type: keyword
  </definition>
  <definition term="sip.from.display_info">
    From display info
    type: keyword
  </definition>
  <definition term="sip.from.uri.original">
    From original URI
    type: keyword
  </definition>
  <definition term="sip.from.uri.original.text">
    type: text
  </definition>
  <definition term="sip.from.uri.scheme">
    From URI scheme
    type: keyword
  </definition>
  <definition term="sip.from.uri.username">
    From URI user name
    type: keyword
  </definition>
  <definition term="sip.from.uri.host">
    From URI host
    type: keyword
  </definition>
  <definition term="sip.from.uri.port">
    From URI port
    type: keyword
  </definition>
  <definition term="sip.from.tag">
    From tag
    type: keyword
  </definition>
  <definition term="sip.contact.display_info">
    Contact display info
    type: keyword
  </definition>
  <definition term="sip.contact.uri.original">
    Contact original URI
    type: keyword
  </definition>
  <definition term="sip.contact.uri.original.text">
    type: text
  </definition>
  <definition term="sip.contact.uri.scheme">
    Contat URI scheme
    type: keyword
  </definition>
  <definition term="sip.contact.uri.username">
    Contact URI user name
    type: keyword
  </definition>
  <definition term="sip.contact.uri.host">
    Contact URI host
    type: keyword
  </definition>
  <definition term="sip.contact.uri.port">
    Contact URI port
    type: keyword
  </definition>
  <definition term="sip.contact.transport">
    Contact transport
    type: keyword
  </definition>
  <definition term="sip.contact.line">
    Contact line
    type: keyword
  </definition>
  <definition term="sip.contact.expires">
    Contact expires
    type: keyword
  </definition>
  <definition term="sip.contact.q">
    Contact Q
    type: keyword
  </definition>
  <definition term="sip.auth.scheme">
    Auth scheme
    type: keyword
  </definition>
  <definition term="sip.auth.realm">
    Auth realm
    type: keyword
  </definition>
  <definition term="sip.auth.uri.original">
    Auth original URI
    type: keyword
  </definition>
  <definition term="sip.auth.uri.original.text">
    type: text
  </definition>
  <definition term="sip.auth.uri.scheme">
    Auth URI scheme
    type: keyword
  </definition>
  <definition term="sip.auth.uri.host">
    Auth URI host
    type: keyword
  </definition>
  <definition term="sip.auth.uri.port">
    Auth URI port
    type: keyword
  </definition>
  <definition term="sip.sdp.version">
    SDP version
    type: keyword
  </definition>
  <definition term="sip.sdp.owner.username">
    SDP owner user name
    type: keyword
  </definition>
  <definition term="sip.sdp.owner.session_id">
    SDP owner session ID
    type: keyword
  </definition>
  <definition term="sip.sdp.owner.version">
    SDP owner version
    type: keyword
  </definition>
  <definition term="sip.sdp.owner.ip">
    SDP owner IP
    type: ip
  </definition>
  <definition term="sip.sdp.session.name">
    SDP session name
    type: keyword
  </definition>
  <definition term="sip.sdp.connection.info">
    SDP connection info
    type: keyword
  </definition>
  <definition term="sip.sdp.connection.address">
    SDP connection address
    type: keyword
  </definition>
  <definition term="sip.sdp.body.original">
    SDP original body
    type: keyword
  </definition>
  <definition term="sip.sdp.body.original.text">
    type: text
  </definition>
</definitions>