﻿---
title: NFS fields
description: NFS v4/3 specific event fields. ONC RPC specific event fields. 
url: https://www.elastic.co/docs/reference/beats/packetbeat/exported-fields-nfs
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# NFS fields
NFS v4/3 specific event fields.
<definitions>
  <definition term="nfs.version">
    NFS protocol version number.
    type: long
  </definition>
  <definition term="nfs.minor_version">
    NFS protocol minor version number.
    type: long
  </definition>
  <definition term="nfs.tag">
    NFS v4 COMPOUND operation tag.
  </definition>
  <definition term="nfs.opcode">
    NFS operation name, or main operation name, in case of COMPOUND calls.
  </definition>
  <definition term="nfs.status">
    NFS operation reply status.
  </definition>
</definitions>


## rpc

ONC RPC specific event fields.
<definitions>
  <definition term="rpc.xid">
    RPC message transaction identifier.
  </definition>
  <definition term="rpc.status">
    RPC message reply status.
  </definition>
  <definition term="rpc.auth_flavor">
    RPC authentication flavor.
  </definition>
  <definition term="rpc.cred.uid">
    RPC caller's user id, in case of auth-unix.
    type: long
  </definition>
  <definition term="rpc.cred.gid">
    RPC caller's group id, in case of auth-unix.
    type: long
  </definition>
  <definition term="rpc.cred.gids">
    RPC caller's secondary group ids, in case of auth-unix.
  </definition>
  <definition term="rpc.cred.stamp">
    Arbitrary ID which the caller machine may generate.
    type: long
  </definition>
  <definition term="rpc.cred.machinename">
    The name of the caller's machine.
  </definition>
  <definition term="rpc.call_size">
    RPC call size with argument.
    type: alias
    alias to: source.bytes
  </definition>
  <definition term="rpc.reply_size">
    RPC reply size with argument.
    type: alias
    alias to: destination.bytes
  </definition>
</definitions>