﻿---
title: MongoDb fields
description: MongoDB-specific event fields. These fields mirror closely the fields for the MongoDB wire protocol. The higher level fields (for example, query and resource)...
url: https://www.elastic.co/docs/reference/beats/packetbeat/exported-fields-mongodb
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# MongoDb fields
MongoDB-specific event fields. These fields mirror closely the fields for the MongoDB wire protocol. The higher level fields (for example, `query` and `resource`) apply to MongoDB events as well.
<definitions>
  <definition term="mongodb.error">
    If the MongoDB request has resulted in an error, this field contains the error message returned by the server.
  </definition>
  <definition term="mongodb.fullCollectionName">
    The full collection name. The full collection name is the concatenation of the database name with the collection name, using a dot (.) for the concatenation. For example, for the database foo and the collection bar, the full collection name is foo.bar.
  </definition>
  <definition term="mongodb.numberToSkip">
    Sets the number of documents to omit - starting from the first document in the resulting dataset - when returning the result of the query.
    type: long
  </definition>
  <definition term="mongodb.numberToReturn">
    The requested maximum number of documents to be returned.
    type: long
  </definition>
  <definition term="mongodb.numberReturned">
    The number of documents in the reply.
    type: long
  </definition>
  <definition term="mongodb.startingFrom">
    Where in the cursor this reply is starting.
  </definition>
  <definition term="mongodb.query">
    A JSON document that represents the query. The query will contain one or more elements, all of which must match for a document to be included in the result set. Possible elements include $query, $orderby, $hint, $explain, and $snapshot.
  </definition>
  <definition term="mongodb.returnFieldsSelector">
    A JSON document that limits the fields in the returned documents. The returnFieldsSelector contains one or more elements, each of which is the name of a field that should be returned, and the integer value 1.
  </definition>
  <definition term="mongodb.selector">
    A BSON document that specifies the query for selecting the document to update or delete.
  </definition>
  <definition term="mongodb.update">
    A BSON document that specifies the update to be performed. For information on specifying updates, see the Update Operations documentation from the MongoDB Manual.
  </definition>
  <definition term="mongodb.cursorId">
    The cursor identifier returned in the OP_REPLY. This must be the value that was returned from the database.
  </definition>
</definitions>