﻿---
title: HTTP fields
description: HTTP-specific event fields. Information about the HTTP request and response. HTTP request HTTP response 
url: https://www.elastic.co/docs/reference/beats/packetbeat/exported-fields-http
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# HTTP fields
HTTP-specific event fields.

## http

Information about the HTTP request and response.

## request

HTTP request
<definitions>
  <definition term="http.request.headers">
    A map containing the captured header fields from the request. Which headers to capture is configurable. If headers with the same header name are present in the message, they will be separated by commas.
    type: object
  </definition>
  <definition term="http.request.params">
    type: alias
    alias to: url.query
  </definition>
</definitions>


## response

HTTP response
<definitions>
  <definition term="http.response.status_phrase">
    The HTTP status phrase.
    example: Not Found
  </definition>
  <definition term="http.response.headers">
    A map containing the captured header fields from the response. Which headers to capture is configurable. If headers with the same header name are present in the message, they will be separated by commas.
    type: object
  </definition>
  <definition term="http.response.code">
    type: alias
    alias to: http.response.status_code
  </definition>
  <definition term="http.response.phrase">
    type: alias
    alias to: http.response.status_phrase
  </definition>
</definitions>