﻿---
title: Flow Event fields
description: These fields contain data about the flow itself. 
url: https://www.elastic.co/docs/reference/beats/packetbeat/exported-fields-flows_event
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Flow Event fields
These fields contain data about the flow itself.
<definitions>
  <definition term="flow.final">
    Indicates if event is last event in flow. If final is false, the event reports an intermediate flow state only.
    type: boolean
  </definition>
  <definition term="flow.id">
    Internal flow ID based on connection meta data and address.
  </definition>
  <definition term="flow.vlan">
    VLAN identifier from the 802.1q frame. In case of a multi-tagged frame this field will be an array with the outer tag's VLAN identifier listed first.
    type: long
  </definition>
  <definition term="flow_id">
    type: alias
    alias to: flow.id
  </definition>
  <definition term="final">
    type: alias
    alias to: flow.final
  </definition>
  <definition term="vlan">
    type: alias
    alias to: flow.vlan
  </definition>
  <definition term="source.stats.net_bytes_total">
    type: alias
    alias to: source.bytes
  </definition>
  <definition term="source.stats.net_packets_total">
    type: alias
    alias to: source.packets
  </definition>
  <definition term="dest.stats.net_bytes_total">
    type: alias
    alias to: destination.bytes
  </definition>
  <definition term="dest.stats.net_packets_total">
    type: alias
    alias to: destination.packets
  </definition>
</definitions>