﻿---
title: ECS fields
description: This section defines Elastic Common Schema (ECS) fields—a common set of fields to be used when storing event data in Elasticsearch. This is an exhaustive...
url: https://www.elastic.co/docs/reference/beats/packetbeat/exported-fields-ecs
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# ECS fields
This section defines Elastic Common Schema (ECS) fields—a common set of fields
to be used when storing event data in Elasticsearch.
This is an exhaustive list, and fields listed here are not necessarily used by Packetbeat.
The goal of ECS is to enable and encourage users of Elasticsearch to normalize their event data,
so that they can better analyze, visualize, and correlate the data represented in their events.
<definitions>
  <definition term="See the ECS reference for more information.">
    Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.
    type: date
    example: 2016-05-23T08:05:34.853Z
    required: True
  </definition>
  <definition term="labels">
    Custom key/value pairs. Can be used to add meta information to events. Should not contain nested objects. All values are stored as keyword. Example: `docker` and `k8s` labels.
    type: object
    example: {"application": "foo-bar", "env": "production"}
  </definition>
  <definition term="message">
    For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message.
    type: match_only_text
    example: Hello World
  </definition>
  <definition term="tags">
    List of keywords used to tag each event.
    type: keyword
    example: ["production", "env2"]
  </definition>
</definitions>


## agent

The agent fields contain the data about the software entity, if any, that collects, detects, or observes events on a host, or takes measurements on a host.
Examples include Beats. Agents may also run on observers. ECS agent.* fields shall be populated with details of the agent running on the host or observer where the event happened or the measurement was taken.
<definitions>
  <definition term="agent.build.original">
    Extended build information for the agent. This field is intended to contain any build information that a data source may provide, no specific formatting is required.
    type: keyword
    example: metricbeat version 7.6.0 (amd64), libbeat 7.6.0 [6a23e8f8f30f5001ba344e4e54d8d9cb82cb107c built 2020-02-05 23:10:10 +0000 UTC]
  </definition>
  <definition term="agent.ephemeral_id">
    Ephemeral identifier of this agent (if one exists). This id normally changes across restarts, but `agent.id` does not.
    type: keyword
    example: 8a4f500f
  </definition>
  <definition term="agent.id">
    Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.
    type: keyword
    example: 8a4f500d
  </definition>
  <definition term="agent.name">
    Custom name of the agent. This is a name that can be given to an agent. This can be helpful if for example two Filebeat instances are running on the same host but a human readable separation is needed on which Filebeat instance data is coming from. If no name is given, the name is often left empty.
    type: keyword
    example: foo
  </definition>
  <definition term="agent.type">
    Type of the agent. The agent type always stays the same and should be given by the agent used. In case of Filebeat the agent would always be Filebeat also if two Filebeat instances are run on the same machine.
    type: keyword
    example: filebeat
  </definition>
  <definition term="agent.version">
    Version of the agent.
    type: keyword
    example: 6.0.0-rc2
  </definition>
</definitions>


## as

An autonomous system (AS) is a collection of connected Internet Protocol (IP) routing prefixes under the control of one or more network operators on behalf of a single administrative entity or domain that presents a common, clearly defined routing policy to the internet.
<definitions>
  <definition term="as.number">
    Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.
    type: long
    example: 15169
  </definition>
  <definition term="as.organization.name">
    Organization name.
    type: keyword
    example: Google LLC
  </definition>
  <definition term="as.organization.name.text">
    type: match_only_text
  </definition>
</definitions>


## client

A client is defined as the initiator of a network connection for events regarding sessions, connections, or bidirectional flow records.
For TCP events, the client is the initiator of the TCP connection that sends the SYN packet(s). For other protocols, the client is generally the initiator or requestor in the network transaction. Some systems use the term "originator" to refer the client in TCP connections. The client fields describe details about the system acting as the client in the network event. Client fields are usually populated in conjunction with server fields. Client fields are generally not populated for packet-level events.
Client / server representations can add semantic context to an exchange, which is helpful to visualize the data in certain situations. If your context falls in that category, you should still ensure that source and destination are filled appropriately.
<definitions>
  <definition term="client.address">
    Some event client addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.
    type: keyword
  </definition>
  <definition term="client.as.number">
    Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.
    type: long
    example: 15169
  </definition>
  <definition term="client.as.organization.name">
    Organization name.
    type: keyword
    example: Google LLC
  </definition>
  <definition term="client.as.organization.name.text">
    type: match_only_text
  </definition>
  <definition term="client.bytes">
    Bytes sent from the client to the server.
    type: long
    example: 184
    format: bytes
  </definition>
  <definition term="client.domain">
    The domain name of the client system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.
    type: keyword
    example: foo.example.com
  </definition>
  <definition term="client.geo.city_name">
    City name.
    type: keyword
    example: Montreal
  </definition>
  <definition term="client.geo.continent_code">
    Two-letter code representing continent's name.
    type: keyword
    example: NA
  </definition>
  <definition term="client.geo.continent_name">
    Name of the continent.
    type: keyword
    example: North America
  </definition>
  <definition term="client.geo.country_iso_code">
    Country ISO code.
    type: keyword
    example: CA
  </definition>
  <definition term="client.geo.country_name">
    Country name.
    type: keyword
    example: Canada
  </definition>
  <definition term="client.geo.location">
    Longitude and latitude.
    type: geo_point
    example: { "lon": -73.614830, "lat": 45.505918 }
  </definition>
  <definition term="client.geo.name">
    User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.
    type: keyword
    example: boston-dc
  </definition>
  <definition term="client.geo.postal_code">
    Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.
    type: keyword
    example: 94040
  </definition>
  <definition term="client.geo.region_iso_code">
    Region ISO code.
    type: keyword
    example: CA-QC
  </definition>
  <definition term="client.geo.region_name">
    Region name.
    type: keyword
    example: Quebec
  </definition>
  <definition term="client.geo.timezone">
    The time zone of the location, such as IANA time zone name.
    type: keyword
    example: America/Argentina/Buenos_Aires
  </definition>
  <definition term="client.ip">
    IP address of the client (IPv4 or IPv6).
    type: ip
  </definition>
  <definition term="client.mac">
    MAC address of the client. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.
    type: keyword
    example: 00-00-5E-00-53-23
  </definition>
  <definition term="client.nat.ip">
    Translated IP of source based NAT sessions (e.g. internal client to internet). Typically connections traversing load balancers, firewalls, or routers.
    type: ip
  </definition>
  <definition term="client.nat.port">
    Translated port of source based NAT sessions (e.g. internal client to internet). Typically connections traversing load balancers, firewalls, or routers.
    type: long
    format: string
  </definition>
  <definition term="client.packets">
    Packets sent from the client to the server.
    type: long
    example: 12
  </definition>
  <definition term="client.port">
    Port of the client.
    type: long
    format: string
  </definition>
  <definition term="client.registered_domain">
    The highest registered client domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".
    type: keyword
    example: example.com
  </definition>
  <definition term="client.subdomain">
    The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain. For example the subdomain portion of "www.east.example.com" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.
    type: keyword
    example: east
  </definition>
  <definition term="client.top_level_domain">
    The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".
    type: keyword
    example: co.uk
  </definition>
  <definition term="client.user.domain">
    Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="client.user.email">
    User email address.
    type: keyword
  </definition>
  <definition term="client.user.full_name">
    User's full name, if available.
    type: keyword
    example: Albert Einstein
  </definition>
  <definition term="client.user.full_name.text">
    type: match_only_text
  </definition>
  <definition term="client.user.group.domain">
    Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="client.user.group.id">
    Unique identifier for the group on the system/platform.
    type: keyword
  </definition>
  <definition term="client.user.group.name">
    Name of the group.
    type: keyword
  </definition>
  <definition term="client.user.hash">
    Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used.
    type: keyword
  </definition>
  <definition term="client.user.id">
    Unique identifier of the user.
    type: keyword
    example: S-1-5-21-202424912787-2692429404-2351956786-1000
  </definition>
  <definition term="client.user.name">
    Short name or login of the user.
    type: keyword
    example: a.einstein
  </definition>
  <definition term="client.user.name.text">
    type: match_only_text
  </definition>
  <definition term="client.user.roles">
    Array of user roles at the time of the event.
    type: keyword
    example: ["kibana_admin", "reporting_user"]
  </definition>
</definitions>


## cloud

Fields related to the cloud or infrastructure the events are coming from.
<definitions>
  <definition term="cloud.account.id">
    The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.
    type: keyword
    example: 666777888999
  </definition>
  <definition term="cloud.account.name">
    The cloud account name or alias used to identify different entities in a multi-tenant environment. Examples: AWS account name, Google Cloud ORG display name.
    type: keyword
    example: elastic-dev
  </definition>
  <definition term="cloud.availability_zone">
    Availability zone in which this host, resource, or service is located.
    type: keyword
    example: us-east-1c
  </definition>
  <definition term="cloud.instance.id">
    Instance ID of the host machine.
    type: keyword
    example: i-1234567890abcdef0
  </definition>
  <definition term="cloud.instance.name">
    Instance name of the host machine.
    type: keyword
  </definition>
  <definition term="cloud.machine.type">
    Machine type of the host machine.
    type: keyword
    example: t2.medium
  </definition>
  <definition term="cloud.origin.account.id">
    The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.
    type: keyword
    example: 666777888999
  </definition>
  <definition term="cloud.origin.account.name">
    The cloud account name or alias used to identify different entities in a multi-tenant environment. Examples: AWS account name, Google Cloud ORG display name.
    type: keyword
    example: elastic-dev
  </definition>
  <definition term="cloud.origin.availability_zone">
    Availability zone in which this host, resource, or service is located.
    type: keyword
    example: us-east-1c
  </definition>
  <definition term="cloud.origin.instance.id">
    Instance ID of the host machine.
    type: keyword
    example: i-1234567890abcdef0
  </definition>
  <definition term="cloud.origin.instance.name">
    Instance name of the host machine.
    type: keyword
  </definition>
  <definition term="cloud.origin.machine.type">
    Machine type of the host machine.
    type: keyword
    example: t2.medium
  </definition>
  <definition term="cloud.origin.project.id">
    The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.
    type: keyword
    example: my-project
  </definition>
  <definition term="cloud.origin.project.name">
    The cloud project name. Examples: Google Cloud Project name, Azure Project name.
    type: keyword
    example: my project
  </definition>
  <definition term="cloud.origin.provider">
    Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.
    type: keyword
    example: aws
  </definition>
  <definition term="cloud.origin.region">
    Region in which this host, resource, or service is located.
    type: keyword
    example: us-east-1
  </definition>
  <definition term="cloud.origin.service.name">
    The cloud service name is intended to distinguish services running on different platforms within a provider, eg AWS EC2 vs Lambda, GCP GCE vs App Engine, Azure VM vs App Server. Examples: app engine, app service, cloud run, fargate, lambda.
    type: keyword
    example: lambda
  </definition>
  <definition term="cloud.project.id">
    The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.
    type: keyword
    example: my-project
  </definition>
  <definition term="cloud.project.name">
    The cloud project name. Examples: Google Cloud Project name, Azure Project name.
    type: keyword
    example: my project
  </definition>
  <definition term="cloud.provider">
    Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.
    type: keyword
    example: aws
  </definition>
  <definition term="cloud.region">
    Region in which this host, resource, or service is located.
    type: keyword
    example: us-east-1
  </definition>
  <definition term="cloud.service.name">
    The cloud service name is intended to distinguish services running on different platforms within a provider, eg AWS EC2 vs Lambda, GCP GCE vs App Engine, Azure VM vs App Server. Examples: app engine, app service, cloud run, fargate, lambda.
    type: keyword
    example: lambda
  </definition>
  <definition term="cloud.target.account.id">
    The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.
    type: keyword
    example: 666777888999
  </definition>
  <definition term="cloud.target.account.name">
    The cloud account name or alias used to identify different entities in a multi-tenant environment. Examples: AWS account name, Google Cloud ORG display name.
    type: keyword
    example: elastic-dev
  </definition>
  <definition term="cloud.target.availability_zone">
    Availability zone in which this host, resource, or service is located.
    type: keyword
    example: us-east-1c
  </definition>
  <definition term="cloud.target.instance.id">
    Instance ID of the host machine.
    type: keyword
    example: i-1234567890abcdef0
  </definition>
  <definition term="cloud.target.instance.name">
    Instance name of the host machine.
    type: keyword
  </definition>
  <definition term="cloud.target.machine.type">
    Machine type of the host machine.
    type: keyword
    example: t2.medium
  </definition>
  <definition term="cloud.target.project.id">
    The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.
    type: keyword
    example: my-project
  </definition>
  <definition term="cloud.target.project.name">
    The cloud project name. Examples: Google Cloud Project name, Azure Project name.
    type: keyword
    example: my project
  </definition>
  <definition term="cloud.target.provider">
    Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.
    type: keyword
    example: aws
  </definition>
  <definition term="cloud.target.region">
    Region in which this host, resource, or service is located.
    type: keyword
    example: us-east-1
  </definition>
  <definition term="cloud.target.service.name">
    The cloud service name is intended to distinguish services running on different platforms within a provider, eg AWS EC2 vs Lambda, GCP GCE vs App Engine, Azure VM vs App Server. Examples: app engine, app service, cloud run, fargate, lambda.
    type: keyword
    example: lambda
  </definition>
</definitions>


## code_signature

These fields contain information about binary code signatures.
<definitions>
  <definition term="code_signature.digest_algorithm">
    The hashing algorithm used to sign the process. This value can distinguish signatures when a file is signed multiple times by the same signer but with a different digest algorithm.
    type: keyword
    example: sha256
  </definition>
  <definition term="code_signature.exists">
    Boolean to capture if a signature is present.
    type: boolean
    example: true
  </definition>
  <definition term="code_signature.signing_id">
    The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only.
    type: keyword
    example: com.apple.xpc.proxy
  </definition>
  <definition term="code_signature.status">
    Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.
    type: keyword
    example: ERROR_UNTRUSTED_ROOT
  </definition>
  <definition term="code_signature.subject_name">
    Subject name of the code signer
    type: keyword
    example: Microsoft Corporation
  </definition>
  <definition term="code_signature.team_id">
    The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only.
    type: keyword
    example: EQHXZ8M8AV
  </definition>
  <definition term="code_signature.timestamp">
    Date and time when the code signature was generated and signed.
    type: date
    example: 2021-01-01T12:10:30Z
  </definition>
  <definition term="code_signature.trusted">
    Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.
    type: boolean
    example: true
  </definition>
  <definition term="code_signature.valid">
    Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked.
    type: boolean
    example: true
  </definition>
</definitions>


## container

Container fields are used for meta information about the specific container that is the source of information. These fields help correlate data based containers from any runtime.
<definitions>
  <definition term="container.cpu.usage">
    Percent CPU used which is normalized by the number of CPU cores and it ranges from 0 to 1. Scaling factor: 1000.
    type: scaled_float
  </definition>
  <definition term="container.disk.read.bytes">
    The total number of bytes (gauge) read successfully (aggregated from all disks) since the last metric collection.
    type: long
  </definition>
  <definition term="container.disk.write.bytes">
    The total number of bytes (gauge) written successfully (aggregated from all disks) since the last metric collection.
    type: long
  </definition>
  <definition term="container.id">
    Unique container id.
    type: keyword
  </definition>
  <definition term="container.image.name">
    Name of the image the container was built on.
    type: keyword
  </definition>
  <definition term="container.image.tag">
    Container image tags.
    type: keyword
  </definition>
  <definition term="container.labels">
    Image labels.
    type: object
  </definition>
  <definition term="container.memory.usage">
    Memory usage percentage and it ranges from 0 to 1. Scaling factor: 1000.
    type: scaled_float
  </definition>
  <definition term="container.name">
    Container name.
    type: keyword
  </definition>
  <definition term="container.network.egress.bytes">
    The number of bytes (gauge) sent out on all network interfaces by the container since the last metric collection.
    type: long
  </definition>
  <definition term="container.network.ingress.bytes">
    The number of bytes received (gauge) on all network interfaces by the container since the last metric collection.
    type: long
  </definition>
  <definition term="container.runtime">
    Runtime managing this container.
    type: keyword
    example: docker
  </definition>
</definitions>


## data_stream

The data_stream fields take part in defining the new data stream naming scheme.
In the new data stream naming scheme the value of the data stream fields combine to the name of the actual data stream in the following manner: `{data_stream.type}-{data_stream.dataset}-{data_stream.namespace}`. This means the fields can only contain characters that are valid as part of names of data streams. More details about this can be found in this https://www.elastic.co/blog/an-introduction-to-the-elastic-data-stream-naming-scheme[blog post].
An Elasticsearch data stream consists of one or more backing indices, and a data stream name forms part of the backing indices names. Due to this convention, data streams must also follow index naming restrictions. For example, data stream names cannot include `\`, `/`, `*`, `?`, `"`, `<`, `>`, `|`, ` ` (space character), `,`, or `#`. Please see the Elasticsearch reference for additional https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-create-index.html#indices-create-api-path-params[restrictions].
<definitions>
  <definition term="data_stream.dataset">
    The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters
    type: constant_keyword
    example: nginx.access
  </definition>
  <definition term="data_stream.namespace">
    A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters
    type: constant_keyword
    example: production
  </definition>
  <definition term="data_stream.type">
    An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.
    type: constant_keyword
    example: logs
  </definition>
</definitions>


## destination

Destination fields capture details about the receiver of a network exchange/packet. These fields are populated from a network event, packet, or other event containing details of a network transaction.
Destination fields are usually populated in conjunction with source fields. The source and destination fields are considered the baseline and should always be filled if an event contains source and destination details from a network transaction. If the event also contains identification of the client and server roles, then the client and server fields should also be populated.
<definitions>
  <definition term="destination.address">
    Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.
    type: keyword
  </definition>
  <definition term="destination.as.number">
    Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.
    type: long
    example: 15169
  </definition>
  <definition term="destination.as.organization.name">
    Organization name.
    type: keyword
    example: Google LLC
  </definition>
  <definition term="destination.as.organization.name.text">
    type: match_only_text
  </definition>
  <definition term="destination.bytes">
    Bytes sent from the destination to the source.
    type: long
    example: 184
    format: bytes
  </definition>
  <definition term="destination.domain">
    The domain name of the destination system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.
    type: keyword
    example: foo.example.com
  </definition>
  <definition term="destination.geo.city_name">
    City name.
    type: keyword
    example: Montreal
  </definition>
  <definition term="destination.geo.continent_code">
    Two-letter code representing continent's name.
    type: keyword
    example: NA
  </definition>
  <definition term="destination.geo.continent_name">
    Name of the continent.
    type: keyword
    example: North America
  </definition>
  <definition term="destination.geo.country_iso_code">
    Country ISO code.
    type: keyword
    example: CA
  </definition>
  <definition term="destination.geo.country_name">
    Country name.
    type: keyword
    example: Canada
  </definition>
  <definition term="destination.geo.location">
    Longitude and latitude.
    type: geo_point
    example: { "lon": -73.614830, "lat": 45.505918 }
  </definition>
  <definition term="destination.geo.name">
    User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.
    type: keyword
    example: boston-dc
  </definition>
  <definition term="destination.geo.postal_code">
    Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.
    type: keyword
    example: 94040
  </definition>
  <definition term="destination.geo.region_iso_code">
    Region ISO code.
    type: keyword
    example: CA-QC
  </definition>
  <definition term="destination.geo.region_name">
    Region name.
    type: keyword
    example: Quebec
  </definition>
  <definition term="destination.geo.timezone">
    The time zone of the location, such as IANA time zone name.
    type: keyword
    example: America/Argentina/Buenos_Aires
  </definition>
  <definition term="destination.ip">
    IP address of the destination (IPv4 or IPv6).
    type: ip
  </definition>
  <definition term="destination.mac">
    MAC address of the destination. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.
    type: keyword
    example: 00-00-5E-00-53-23
  </definition>
  <definition term="destination.nat.ip">
    Translated ip of destination based NAT sessions (e.g. internet to private DMZ) Typically used with load balancers, firewalls, or routers.
    type: ip
  </definition>
  <definition term="destination.nat.port">
    Port the source session is translated to by NAT Device. Typically used with load balancers, firewalls, or routers.
    type: long
    format: string
  </definition>
  <definition term="destination.packets">
    Packets sent from the destination to the source.
    type: long
    example: 12
  </definition>
  <definition term="destination.port">
    Port of the destination.
    type: long
    format: string
  </definition>
  <definition term="destination.registered_domain">
    The highest registered destination domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".
    type: keyword
    example: example.com
  </definition>
  <definition term="destination.subdomain">
    The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain. For example the subdomain portion of "www.east.example.com" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.
    type: keyword
    example: east
  </definition>
  <definition term="destination.top_level_domain">
    The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".
    type: keyword
    example: co.uk
  </definition>
  <definition term="destination.user.domain">
    Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="destination.user.email">
    User email address.
    type: keyword
  </definition>
  <definition term="destination.user.full_name">
    User's full name, if available.
    type: keyword
    example: Albert Einstein
  </definition>
  <definition term="destination.user.full_name.text">
    type: match_only_text
  </definition>
  <definition term="destination.user.group.domain">
    Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="destination.user.group.id">
    Unique identifier for the group on the system/platform.
    type: keyword
  </definition>
  <definition term="destination.user.group.name">
    Name of the group.
    type: keyword
  </definition>
  <definition term="destination.user.hash">
    Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used.
    type: keyword
  </definition>
  <definition term="destination.user.id">
    Unique identifier of the user.
    type: keyword
    example: S-1-5-21-202424912787-2692429404-2351956786-1000
  </definition>
  <definition term="destination.user.name">
    Short name or login of the user.
    type: keyword
    example: a.einstein
  </definition>
  <definition term="destination.user.name.text">
    type: match_only_text
  </definition>
  <definition term="destination.user.roles">
    Array of user roles at the time of the event.
    type: keyword
    example: ["kibana_admin", "reporting_user"]
  </definition>
</definitions>


## dll

These fields contain information about code libraries dynamically loaded into processes.
Many operating systems refer to "shared code libraries" with different names, but this field set refers to all of the following:
- Dynamic-link library (`.dll`) commonly used on Windows
- Shared Object (`.so`) commonly used on Unix-like operating systems
- Dynamic library (`.dylib`) commonly used on macOS

<definitions>
  <definition term="dll.code_signature.digest_algorithm">
    The hashing algorithm used to sign the process. This value can distinguish signatures when a file is signed multiple times by the same signer but with a different digest algorithm.
    type: keyword
    example: sha256
  </definition>
  <definition term="dll.code_signature.exists">
    Boolean to capture if a signature is present.
    type: boolean
    example: true
  </definition>
  <definition term="dll.code_signature.signing_id">
    The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only.
    type: keyword
    example: com.apple.xpc.proxy
  </definition>
  <definition term="dll.code_signature.status">
    Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.
    type: keyword
    example: ERROR_UNTRUSTED_ROOT
  </definition>
  <definition term="dll.code_signature.subject_name">
    Subject name of the code signer
    type: keyword
    example: Microsoft Corporation
  </definition>
  <definition term="dll.code_signature.team_id">
    The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only.
    type: keyword
    example: EQHXZ8M8AV
  </definition>
  <definition term="dll.code_signature.timestamp">
    Date and time when the code signature was generated and signed.
    type: date
    example: 2021-01-01T12:10:30Z
  </definition>
  <definition term="dll.code_signature.trusted">
    Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.
    type: boolean
    example: true
  </definition>
  <definition term="dll.code_signature.valid">
    Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked.
    type: boolean
    example: true
  </definition>
  <definition term="dll.hash.md5">
    MD5 hash.
    type: keyword
  </definition>
  <definition term="dll.hash.sha1">
    SHA1 hash.
    type: keyword
  </definition>
  <definition term="dll.hash.sha256">
    SHA256 hash.
    type: keyword
  </definition>
  <definition term="dll.hash.sha512">
    SHA512 hash.
    type: keyword
  </definition>
  <definition term="dll.hash.ssdeep">
    SSDEEP hash.
    type: keyword
  </definition>
  <definition term="dll.name">
    Name of the library. This generally maps to the name of the file on disk.
    type: keyword
    example: kernel32.dll
  </definition>
  <definition term="dll.path">
    Full file path of the library.
    type: keyword
    example: C:\Windows\System32\kernel32.dll
  </definition>
  <definition term="dll.pe.architecture">
    CPU architecture target for the file.
    type: keyword
    example: x64
  </definition>
  <definition term="dll.pe.company">
    Internal company name of the file, provided at compile-time.
    type: keyword
    example: Microsoft Corporation
  </definition>
  <definition term="dll.pe.description">
    Internal description of the file, provided at compile-time.
    type: keyword
    example: Paint
  </definition>
  <definition term="dll.pe.file_version">
    Internal version of the file, provided at compile-time.
    type: keyword
    example: 6.3.9600.17415
  </definition>
  <definition term="dll.pe.imphash">
    A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at [https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html](https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html).
    type: keyword
    example: 0c6803c4e922103c4dca5963aad36ddf
  </definition>
  <definition term="dll.pe.original_file_name">
    Internal name of the file, provided at compile-time.
    type: keyword
    example: MSPAINT.EXE
  </definition>
  <definition term="dll.pe.product">
    Internal product name of the file, provided at compile-time.
    type: keyword
    example: Microsoft® Windows® Operating System
  </definition>
</definitions>


## dns

Fields describing DNS queries and answers.
DNS events should either represent a single DNS query prior to getting answers (`dns.type:query`) or they should represent a full exchange and contain the query details as well as all of the answers that were provided for this query (`dns.type:answer`).
<definitions>
  <definition term="dns.answers">
    An array containing an object for each answer section returned by the server. The main keys that should be present in these objects are defined by ECS. Records that have more information may contain more keys than what ECS defines. Not all DNS data sources give all details about DNS answers. At minimum, answer objects must contain the `data` key. If more information is available, map as much of it to ECS as possible, and add any additional fields to the answer objects as custom fields.
    type: object
  </definition>
  <definition term="dns.answers.class">
    The class of DNS data contained in this resource record.
    type: keyword
    example: IN
  </definition>
  <definition term="dns.answers.data">
    The data describing the resource. The meaning of this data depends on the type and class of the resource record.
    type: keyword
    example: 10.10.10.10
  </definition>
  <definition term="dns.answers.name">
    The domain name to which this resource record pertains. If a chain of CNAME is being resolved, each answer's `name` should be the one that corresponds with the answer's `data`. It should not simply be the original `question.name` repeated.
    type: keyword
    example: www.example.com
  </definition>
  <definition term="dns.answers.ttl">
    The time interval in seconds that this resource record may be cached before it should be discarded. Zero values mean that the data should not be cached.
    type: long
    example: 180
  </definition>
  <definition term="dns.answers.type">
    The type of data contained in this resource record.
    type: keyword
    example: CNAME
  </definition>
  <definition term="dns.header_flags">
    Array of 2 letter DNS header flags. Expected values are: AA, TC, RD, RA, AD, CD, DO.
    type: keyword
    example: ["RD", "RA"]
  </definition>
  <definition term="dns.id">
    The DNS packet identifier assigned by the program that generated the query. The identifier is copied to the response.
    type: keyword
    example: 62111
  </definition>
  <definition term="dns.op_code">
    The DNS operation code that specifies the kind of query in the message. This value is set by the originator of a query and copied into the response.
    type: keyword
    example: QUERY
  </definition>
  <definition term="dns.question.class">
    The class of records being queried.
    type: keyword
    example: IN
  </definition>
  <definition term="dns.question.name">
    The name being queried. If the name field contains non-printable characters (below 32 or above 126), those characters should be represented as escaped base 10 integers (\DDD). Back slashes and quotes should be escaped. Tabs, carriage returns, and line feeds should be converted to \t, \r, and \n respectively.
    type: keyword
    example: www.example.com
  </definition>
  <definition term="dns.question.registered_domain">
    The highest registered domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".
    type: keyword
    example: example.com
  </definition>
  <definition term="dns.question.subdomain">
    The subdomain is all of the labels under the registered_domain. If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.
    type: keyword
    example: www
  </definition>
  <definition term="dns.question.top_level_domain">
    The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".
    type: keyword
    example: co.uk
  </definition>
  <definition term="dns.question.type">
    The type of record being queried.
    type: keyword
    example: AAAA
  </definition>
  <definition term="dns.resolved_ip">
    Array containing all IPs seen in `answers.data`. The `answers` array can be difficult to use, because of the variety of data formats it can contain. Extracting all IP addresses seen in there to `dns.resolved_ip` makes it possible to index them as IP addresses, and makes them easier to visualize and query for.
    type: ip
    example: ["10.10.10.10", "10.10.10.11"]
  </definition>
  <definition term="dns.response_code">
    The DNS response code.
    type: keyword
    example: NOERROR
  </definition>
  <definition term="dns.type">
    The type of DNS event captured, query or answer. If your source of DNS events only gives you DNS queries, you should only create dns events of type `dns.type:query`. If your source of DNS events gives you answers as well, you should create one event per query (optionally as soon as the query is seen). And a second event containing all query details as well as an array of answers.
    type: keyword
    example: answer
  </definition>
</definitions>


## ecs

Meta-information specific to ECS.
<definitions>
  <definition term="ecs.version">
    ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.
    type: keyword
    example: 1.0.0
    required: True
  </definition>
</definitions>


## elf

These fields contain Linux Executable Linkable Format (ELF) metadata.
<definitions>
  <definition term="elf.architecture">
    Machine architecture of the ELF file.
    type: keyword
    example: x86-64
  </definition>
  <definition term="elf.byte_order">
    Byte sequence of ELF file.
    type: keyword
    example: Little Endian
  </definition>
  <definition term="elf.cpu_type">
    CPU type of the ELF file.
    type: keyword
    example: Intel
  </definition>
  <definition term="elf.creation_date">
    Extracted when possible from the file's metadata. Indicates when it was built or compiled. It can also be faked by malware creators.
    type: date
  </definition>
  <definition term="elf.exports">
    List of exported element names and types.
    type: flattened
  </definition>
  <definition term="elf.header.abi_version">
    Version of the ELF Application Binary Interface (ABI).
    type: keyword
  </definition>
  <definition term="elf.header.class">
    Header class of the ELF file.
    type: keyword
  </definition>
  <definition term="elf.header.data">
    Data table of the ELF header.
    type: keyword
  </definition>
  <definition term="elf.header.entrypoint">
    Header entrypoint of the ELF file.
    type: long
    format: string
  </definition>
  <definition term="elf.header.object_version">
    "0x1" for original ELF files.
    type: keyword
  </definition>
  <definition term="elf.header.os_abi">
    Application Binary Interface (ABI) of the Linux OS.
    type: keyword
  </definition>
  <definition term="elf.header.type">
    Header type of the ELF file.
    type: keyword
  </definition>
  <definition term="elf.header.version">
    Version of the ELF header.
    type: keyword
  </definition>
  <definition term="elf.imports">
    List of imported element names and types.
    type: flattened
  </definition>
  <definition term="elf.sections">
    An array containing an object for each section of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.sections.*`.
    type: nested
  </definition>
  <definition term="elf.sections.chi2">
    Chi-square probability distribution of the section.
    type: long
    format: number
  </definition>
  <definition term="elf.sections.entropy">
    Shannon entropy calculation from the section.
    type: long
    format: number
  </definition>
  <definition term="elf.sections.flags">
    ELF Section List flags.
    type: keyword
  </definition>
  <definition term="elf.sections.name">
    ELF Section List name.
    type: keyword
  </definition>
  <definition term="elf.sections.physical_offset">
    ELF Section List offset.
    type: keyword
  </definition>
  <definition term="elf.sections.physical_size">
    ELF Section List physical size.
    type: long
    format: bytes
  </definition>
  <definition term="elf.sections.type">
    ELF Section List type.
    type: keyword
  </definition>
  <definition term="elf.sections.virtual_address">
    ELF Section List virtual address.
    type: long
    format: string
  </definition>
  <definition term="elf.sections.virtual_size">
    ELF Section List virtual size.
    type: long
    format: string
  </definition>
  <definition term="elf.segments">
    An array containing an object for each segment of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.segments.*`.
    type: nested
  </definition>
  <definition term="elf.segments.sections">
    ELF object segment sections.
    type: keyword
  </definition>
  <definition term="elf.segments.type">
    ELF object segment type.
    type: keyword
  </definition>
  <definition term="elf.shared_libraries">
    List of shared libraries used by this ELF object.
    type: keyword
  </definition>
  <definition term="elf.telfhash">
    telfhash symbol hash for ELF file.
    type: keyword
  </definition>
</definitions>


## error

These fields can represent errors of any kind.
Use them for errors that happen while fetching events or in cases where the event itself contains an error.
<definitions>
  <definition term="error.code">
    Error code describing the error.
    type: keyword
  </definition>
  <definition term="error.id">
    Unique identifier for the error.
    type: keyword
  </definition>
  <definition term="error.message">
    Error message.
    type: match_only_text
  </definition>
  <definition term="error.stack_trace">
    The stack trace of this error in plain text.
    type: wildcard
  </definition>
  <definition term="error.stack_trace.text">
    type: match_only_text
  </definition>
  <definition term="error.type">
    The type of the error, for example the class name of the exception.
    type: keyword
    example: java.lang.NullPointerException
  </definition>
</definitions>


## event

The event fields are used for context information about the log or metric event itself.
A log is defined as an event containing details of something that happened. Log events must include the time at which the thing happened. Examples of log events include a process starting on a host, a network packet being sent from a source to a destination, or a network connection between a client and a server being initiated or closed. A metric is defined as an event containing one or more numerical measurements and the time at which the measurement was taken. Examples of metric events include memory pressure measured on a host and device temperature. See the `event.kind` definition in this section for additional details about metric and state events.
<definitions>
  <definition term="event.action">
    The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer.
    type: keyword
    example: user-password-change
  </definition>
  <definition term="event.agent_id_status">
    Agents are normally responsible for populating the `agent.id` field value. If the system receiving events is capable of validating the value based on authentication information for the client then this field can be used to reflect the outcome of that validation. For example if the agent's connection is authenticated with mTLS and the client cert contains the ID of the agent to which the cert was issued then the `agent.id` value in events can be checked against the certificate. If the values match then `event.agent_id_status: verified` is added to the event, otherwise one of the other allowed values should be used. If no validation is performed then the field should be omitted. The allowed values are: `verified` - The `agent.id` field value matches expected value obtained from auth metadata. `mismatch` - The `agent.id` field value does not match the expected value obtained from auth metadata. `missing` - There was no `agent.id` field in the event to validate. `auth_metadata_missing` - There was no auth metadata or it was missing information about the agent ID.
    type: keyword
    example: verified
  </definition>
  <definition term="event.category">
    This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.
    type: keyword
    example: authentication
  </definition>
  <definition term="event.code">
    Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID.
    type: keyword
    example: 4648
  </definition>
  <definition term="event.created">
    event.created contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from @timestamp in that @timestamp typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, @timestamp should be used.
    type: date
    example: 2016-05-23T08:05:34.857Z
  </definition>
  <definition term="event.dataset">
    Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name.
    type: keyword
    example: apache.access
  </definition>
  <definition term="event.duration">
    Duration of the event in nanoseconds. If event.start and event.end are known this value should be the difference between the end and start time.
    type: long
    format: duration
  </definition>
  <definition term="event.end">
    event.end contains the date when the event ended or when the activity was last observed.
    type: date
  </definition>
  <definition term="event.hash">
    Hash (perhaps logstash fingerprint) of raw field to be able to demonstrate log integrity.
    type: keyword
    example: 123456789012345678901234567890ABCD
  </definition>
  <definition term="event.id">
    Unique ID to describe the event.
    type: keyword
    example: 8a4f500d
  </definition>
  <definition term="event.ingested">
    Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.
    type: date
    example: 2016-05-23T08:05:35.101Z
  </definition>
  <definition term="event.kind">
    This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data coming in at a regular interval or not.
    type: keyword
    example: alert
  </definition>
  <definition term="event.module">
    Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.
    type: keyword
    example: apache
  </definition>
  <definition term="event.original">
    Raw text message of entire event. Used to demonstrate log integrity or where the full log message (before splitting it up in multiple parts) may be required, e.g. for reindex. This field is not indexed and doc_values are disabled. It cannot be searched, but it can be retrieved from `_source`. If users wish to override this and index this field, please see `Field data types` in the `Elasticsearch Reference`.
    type: keyword
    example: Sep 19 08:26:10 host CEF:0Security threatmanager1.0100 worm successfully stopped10src=10.0.0.1 dst=2.1.2.2spt=1232
  </definition>
</definitions>

Field is not indexed.
<definitions>
  <definition term="event.outcome">
    This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense.
    type: keyword
    example: success
  </definition>
  <definition term="event.provider">
    Source of the event. Event transports such as Syslog or the Windows Event Log typically mention the source of an event. It can be the name of the software that generated the event (e.g. Sysmon, httpd), or of a subsystem of the operating system (kernel, Microsoft-Windows-Security-Auditing).
    type: keyword
    example: kernel
  </definition>
  <definition term="event.reason">
    Reason why this event happened, according to the source. This describes the why of a particular action or outcome captured in the event. Where `event.action` captures the action from the event, `event.reason` describes why that action was taken. For example, a web proxy with an `event.action` which denied the request may also populate `event.reason` with the reason why (e.g. `blocked site`).
    type: keyword
    example: Terminated an unexpected process
  </definition>
  <definition term="event.reference">
    Reference URL linking to additional information about this event. This URL links to a static definition of this event. Alert events, indicated by `event.kind:alert`, are a common use case for this field.
    type: keyword
    example: https://system.example.com/event/#0001234
  </definition>
  <definition term="event.risk_score">
    Risk score or priority of the event (e.g. security solutions). Use your system's original value here.
    type: float
  </definition>
  <definition term="event.risk_score_norm">
    Normalized risk score or priority of the event, on a scale of 0 to 100. This is mainly useful if you use more than one system that assigns risk scores, and you want to see a normalized value across all systems.
    type: float
  </definition>
  <definition term="event.sequence">
    Sequence number of the event. The sequence number is a value published by some event sources, to make the exact ordering of events unambiguous, regardless of the timestamp precision.
    type: long
    format: string
  </definition>
  <definition term="event.severity">
    The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`.
    type: long
    example: 7
    format: string
  </definition>
  <definition term="event.start">
    event.start contains the date when the event started or when the activity was first observed.
    type: date
  </definition>
  <definition term="event.timezone">
    This field should be populated when the event's timestamp does not include timezone information already (e.g. default Syslog timestamps). It's optional otherwise. Acceptable timezone formats are: a canonical ID (e.g. "Europe/Amsterdam"), abbreviated (e.g. "EST") or an HH:mm differential (e.g. "-05:00").
    type: keyword
  </definition>
  <definition term="event.type">
    This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.
    type: keyword
  </definition>
  <definition term="event.url">
    URL linking to an external system to continue investigation of this event. This URL links to another system where in-depth investigation of the specific occurrence of this event can take place. Alert events, indicated by `event.kind:alert`, are a common use case for this field.
    type: keyword
    example: https://mysystem.example.com/alert/5271dedb-f5b0-4218-87f0-4ac4870a38fe
  </definition>
</definitions>


## faas

The user fields describe information about the function as a service that is relevant to the event.
<definitions>
  <definition term="faas.coldstart">
    Boolean value indicating a cold start of a function.
    type: boolean
  </definition>
  <definition term="faas.execution">
    The execution ID of the current function execution.
    type: keyword
    example: af9d5aa4-a685-4c5f-a22b-444f80b3cc28
  </definition>
  <definition term="faas.trigger">
    Details about the function trigger.
    type: nested
  </definition>
  <definition term="faas.trigger.request_id">
    The ID of the trigger request , message, event, etc.
    type: keyword
    example: 123456789
  </definition>
  <definition term="faas.trigger.type">
    The trigger for the function execution. Expected values are:   * http   * pubsub   * datasource   * timer   * other
    type: keyword
    example: http
  </definition>
</definitions>


## file

A file is defined as a set of information that has been created on, or has existed on a filesystem.
File objects can be associated with host events, network events, and/or file events (e.g., those produced by File Integrity Monitoring [FIM] products or services). File fields provide details about the affected file associated with the event or metric.
<definitions>
  <definition term="file.accessed">
    Last time the file was accessed. Note that not all filesystems keep track of access time.
    type: date
  </definition>
  <definition term="file.attributes">
    Array of file attributes. Attributes names will vary by platform. Here's a non-exhaustive list of values that are expected in this field: archive, compressed, directory, encrypted, execute, hidden, read, readonly, system, write.
    type: keyword
    example: ["readonly", "system"]
  </definition>
  <definition term="file.code_signature.digest_algorithm">
    The hashing algorithm used to sign the process. This value can distinguish signatures when a file is signed multiple times by the same signer but with a different digest algorithm.
    type: keyword
    example: sha256
  </definition>
  <definition term="file.code_signature.exists">
    Boolean to capture if a signature is present.
    type: boolean
    example: true
  </definition>
  <definition term="file.code_signature.signing_id">
    The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only.
    type: keyword
    example: com.apple.xpc.proxy
  </definition>
  <definition term="file.code_signature.status">
    Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.
    type: keyword
    example: ERROR_UNTRUSTED_ROOT
  </definition>
  <definition term="file.code_signature.subject_name">
    Subject name of the code signer
    type: keyword
    example: Microsoft Corporation
  </definition>
  <definition term="file.code_signature.team_id">
    The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only.
    type: keyword
    example: EQHXZ8M8AV
  </definition>
  <definition term="file.code_signature.timestamp">
    Date and time when the code signature was generated and signed.
    type: date
    example: 2021-01-01T12:10:30Z
  </definition>
  <definition term="file.code_signature.trusted">
    Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.
    type: boolean
    example: true
  </definition>
  <definition term="file.code_signature.valid">
    Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked.
    type: boolean
    example: true
  </definition>
  <definition term="file.created">
    File creation time. Note that not all filesystems store the creation time.
    type: date
  </definition>
  <definition term="file.ctime">
    Last time the file attributes or metadata changed. Note that changes to the file content will update `mtime`. This implies `ctime` will be adjusted at the same time, since `mtime` is an attribute of the file.
    type: date
  </definition>
  <definition term="file.device">
    Device that is the source of the file.
    type: keyword
    example: sda
  </definition>
  <definition term="file.directory">
    Directory where the file is located. It should include the drive letter, when appropriate.
    type: keyword
    example: /home/alice
  </definition>
  <definition term="file.drive_letter">
    Drive letter where the file is located. This field is only relevant on Windows. The value should be uppercase, and not include the colon.
    type: keyword
    example: C
  </definition>
  <definition term="file.elf.architecture">
    Machine architecture of the ELF file.
    type: keyword
    example: x86-64
  </definition>
  <definition term="file.elf.byte_order">
    Byte sequence of ELF file.
    type: keyword
    example: Little Endian
  </definition>
  <definition term="file.elf.cpu_type">
    CPU type of the ELF file.
    type: keyword
    example: Intel
  </definition>
  <definition term="file.elf.creation_date">
    Extracted when possible from the file's metadata. Indicates when it was built or compiled. It can also be faked by malware creators.
    type: date
  </definition>
  <definition term="file.elf.exports">
    List of exported element names and types.
    type: flattened
  </definition>
  <definition term="file.elf.header.abi_version">
    Version of the ELF Application Binary Interface (ABI).
    type: keyword
  </definition>
  <definition term="file.elf.header.class">
    Header class of the ELF file.
    type: keyword
  </definition>
  <definition term="file.elf.header.data">
    Data table of the ELF header.
    type: keyword
  </definition>
  <definition term="file.elf.header.entrypoint">
    Header entrypoint of the ELF file.
    type: long
    format: string
  </definition>
  <definition term="file.elf.header.object_version">
    "0x1" for original ELF files.
    type: keyword
  </definition>
  <definition term="file.elf.header.os_abi">
    Application Binary Interface (ABI) of the Linux OS.
    type: keyword
  </definition>
  <definition term="file.elf.header.type">
    Header type of the ELF file.
    type: keyword
  </definition>
  <definition term="file.elf.header.version">
    Version of the ELF header.
    type: keyword
  </definition>
  <definition term="file.elf.imports">
    List of imported element names and types.
    type: flattened
  </definition>
  <definition term="file.elf.sections">
    An array containing an object for each section of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.sections.*`.
    type: nested
  </definition>
  <definition term="file.elf.sections.chi2">
    Chi-square probability distribution of the section.
    type: long
    format: number
  </definition>
  <definition term="file.elf.sections.entropy">
    Shannon entropy calculation from the section.
    type: long
    format: number
  </definition>
  <definition term="file.elf.sections.flags">
    ELF Section List flags.
    type: keyword
  </definition>
  <definition term="file.elf.sections.name">
    ELF Section List name.
    type: keyword
  </definition>
  <definition term="file.elf.sections.physical_offset">
    ELF Section List offset.
    type: keyword
  </definition>
  <definition term="file.elf.sections.physical_size">
    ELF Section List physical size.
    type: long
    format: bytes
  </definition>
  <definition term="file.elf.sections.type">
    ELF Section List type.
    type: keyword
  </definition>
  <definition term="file.elf.sections.virtual_address">
    ELF Section List virtual address.
    type: long
    format: string
  </definition>
  <definition term="file.elf.sections.virtual_size">
    ELF Section List virtual size.
    type: long
    format: string
  </definition>
  <definition term="file.elf.segments">
    An array containing an object for each segment of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.segments.*`.
    type: nested
  </definition>
  <definition term="file.elf.segments.sections">
    ELF object segment sections.
    type: keyword
  </definition>
  <definition term="file.elf.segments.type">
    ELF object segment type.
    type: keyword
  </definition>
  <definition term="file.elf.shared_libraries">
    List of shared libraries used by this ELF object.
    type: keyword
  </definition>
  <definition term="file.elf.telfhash">
    telfhash symbol hash for ELF file.
    type: keyword
  </definition>
  <definition term="file.extension">
    File extension, excluding the leading dot. Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").
    type: keyword
    example: png
  </definition>
  <definition term="file.fork_name">
    A fork is additional data associated with a filesystem object. On Linux, a resource fork is used to store additional data with a filesystem object. A file always has at least one fork for the data portion, and additional forks may exist. On NTFS, this is analogous to an Alternate Data Stream (ADS), and the default data stream for a file is just called $DATA. Zone.Identifier is commonly used by Windows to track contents downloaded from the Internet. An ADS is typically of the form: `C:\path\to\filename.extension:some_fork_name`, and `some_fork_name` is the value that should populate `fork_name`. `filename.extension` should populate `file.name`, and `extension` should populate `file.extension`. The full path, `file.path`, will include the fork name.
    type: keyword
    example: Zone.Identifer
  </definition>
  <definition term="file.gid">
    Primary group ID (GID) of the file.
    type: keyword
    example: 1001
  </definition>
  <definition term="file.group">
    Primary group name of the file.
    type: keyword
    example: alice
  </definition>
  <definition term="file.hash.md5">
    MD5 hash.
    type: keyword
  </definition>
  <definition term="file.hash.sha1">
    SHA1 hash.
    type: keyword
  </definition>
  <definition term="file.hash.sha256">
    SHA256 hash.
    type: keyword
  </definition>
  <definition term="file.hash.sha512">
    SHA512 hash.
    type: keyword
  </definition>
  <definition term="file.hash.ssdeep">
    SSDEEP hash.
    type: keyword
  </definition>
  <definition term="file.inode">
    Inode representing the file in the filesystem.
    type: keyword
    example: 256383
  </definition>
  <definition term="file.mime_type">
    MIME type should identify the format of the file or stream of bytes using https://www.iana.org/assignments/media-types/media-types.xhtml[IANA official types], where possible. When more than one type is applicable, the most specific type should be used.
    type: keyword
  </definition>
  <definition term="file.mode">
    Mode of the file in octal representation.
    type: keyword
    example: 0640
  </definition>
  <definition term="file.mtime">
    Last time the file content was modified.
    type: date
  </definition>
  <definition term="file.name">
    Name of the file including the extension, without the directory.
    type: keyword
    example: example.png
  </definition>
  <definition term="file.owner">
    File owner's username.
    type: keyword
    example: alice
  </definition>
  <definition term="file.path">
    Full path to the file, including the file name. It should include the drive letter, when appropriate.
    type: keyword
    example: /home/alice/example.png
  </definition>
  <definition term="file.path.text">
    type: match_only_text
  </definition>
  <definition term="file.pe.architecture">
    CPU architecture target for the file.
    type: keyword
    example: x64
  </definition>
  <definition term="file.pe.company">
    Internal company name of the file, provided at compile-time.
    type: keyword
    example: Microsoft Corporation
  </definition>
  <definition term="file.pe.description">
    Internal description of the file, provided at compile-time.
    type: keyword
    example: Paint
  </definition>
  <definition term="file.pe.file_version">
    Internal version of the file, provided at compile-time.
    type: keyword
    example: 6.3.9600.17415
  </definition>
  <definition term="file.pe.imphash">
    A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at [https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html](https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html).
    type: keyword
    example: 0c6803c4e922103c4dca5963aad36ddf
  </definition>
  <definition term="file.pe.original_file_name">
    Internal name of the file, provided at compile-time.
    type: keyword
    example: MSPAINT.EXE
  </definition>
  <definition term="file.pe.product">
    Internal product name of the file, provided at compile-time.
    type: keyword
    example: Microsoft® Windows® Operating System
  </definition>
  <definition term="file.size">
    File size in bytes. Only relevant when `file.type` is "file".
    type: long
    example: 16384
  </definition>
  <definition term="file.target_path">
    Target path for symlinks.
    type: keyword
  </definition>
  <definition term="file.target_path.text">
    type: match_only_text
  </definition>
  <definition term="file.type">
    File type (file, dir, or symlink).
    type: keyword
    example: file
  </definition>
  <definition term="file.uid">
    The user ID (UID) or security identifier (SID) of the file owner.
    type: keyword
    example: 1001
  </definition>
  <definition term="file.x509.alternative_names">
    List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.
    type: keyword
    example: *.elastic.co
  </definition>
  <definition term="file.x509.issuer.common_name">
    List of common name (CN) of issuing certificate authority.
    type: keyword
    example: Example SHA2 High Assurance Server CA
  </definition>
  <definition term="file.x509.issuer.country">
    List of country (C) codes
    type: keyword
    example: US
  </definition>
  <definition term="file.x509.issuer.distinguished_name">
    Distinguished name (DN) of issuing certificate authority.
    type: keyword
    example: C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA
  </definition>
  <definition term="file.x509.issuer.locality">
    List of locality names (L)
    type: keyword
    example: Mountain View
  </definition>
  <definition term="file.x509.issuer.organization">
    List of organizations (O) of issuing certificate authority.
    type: keyword
    example: Example Inc
  </definition>
  <definition term="file.x509.issuer.organizational_unit">
    List of organizational units (OU) of issuing certificate authority.
    type: keyword
    example: www.example.com
  </definition>
  <definition term="file.x509.issuer.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="file.x509.not_after">
    Time at which the certificate is no longer considered valid.
    type: date
    example: 2020-07-16 03:15:39+00:00
  </definition>
  <definition term="file.x509.not_before">
    Time at which the certificate is first considered valid.
    type: date
    example: 2019-08-16 01:40:25+00:00
  </definition>
  <definition term="file.x509.public_key_algorithm">
    Algorithm used to generate the public key.
    type: keyword
    example: RSA
  </definition>
  <definition term="file.x509.public_key_curve">
    The curve used by the elliptic curve public key algorithm. This is algorithm specific.
    type: keyword
    example: nistp521
  </definition>
  <definition term="file.x509.public_key_exponent">
    Exponent used to derive the public key. This is algorithm specific.
    type: long
    example: 65537
  </definition>
</definitions>

Field is not indexed.
<definitions>
  <definition term="file.x509.public_key_size">
    The size of the public key space in bits.
    type: long
    example: 2048
  </definition>
  <definition term="file.x509.serial_number">
    Unique serial number issued by the certificate authority. For consistency, if this value is alphanumeric, it should be formatted without colons and uppercase characters.
    type: keyword
    example: 55FBB9C7DEBF09809D12CCAA
  </definition>
  <definition term="file.x509.signature_algorithm">
    Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See [https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353](https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353).
    type: keyword
    example: SHA256-RSA
  </definition>
  <definition term="file.x509.subject.common_name">
    List of common names (CN) of subject.
    type: keyword
    example: shared.global.example.net
  </definition>
  <definition term="file.x509.subject.country">
    List of country (C) code
    type: keyword
    example: US
  </definition>
  <definition term="file.x509.subject.distinguished_name">
    Distinguished name (DN) of the certificate subject entity.
    type: keyword
    example: C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net
  </definition>
  <definition term="file.x509.subject.locality">
    List of locality names (L)
    type: keyword
    example: San Francisco
  </definition>
  <definition term="file.x509.subject.organization">
    List of organizations (O) of subject.
    type: keyword
    example: Example, Inc.
  </definition>
  <definition term="file.x509.subject.organizational_unit">
    List of organizational units (OU) of subject.
    type: keyword
  </definition>
  <definition term="file.x509.subject.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="file.x509.version_number">
    Version of x509 format.
    type: keyword
    example: 3
  </definition>
</definitions>


## geo

Geo fields can carry data about a specific location related to an event.
This geolocation information can be derived from techniques such as Geo IP, or be user-supplied.
<definitions>
  <definition term="geo.city_name">
    City name.
    type: keyword
    example: Montreal
  </definition>
  <definition term="geo.continent_code">
    Two-letter code representing continent's name.
    type: keyword
    example: NA
  </definition>
  <definition term="geo.continent_name">
    Name of the continent.
    type: keyword
    example: North America
  </definition>
  <definition term="geo.country_iso_code">
    Country ISO code.
    type: keyword
    example: CA
  </definition>
  <definition term="geo.country_name">
    Country name.
    type: keyword
    example: Canada
  </definition>
  <definition term="geo.location">
    Longitude and latitude.
    type: geo_point
    example: { "lon": -73.614830, "lat": 45.505918 }
  </definition>
  <definition term="geo.name">
    User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.
    type: keyword
    example: boston-dc
  </definition>
  <definition term="geo.postal_code">
    Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.
    type: keyword
    example: 94040
  </definition>
  <definition term="geo.region_iso_code">
    Region ISO code.
    type: keyword
    example: CA-QC
  </definition>
  <definition term="geo.region_name">
    Region name.
    type: keyword
    example: Quebec
  </definition>
  <definition term="geo.timezone">
    The time zone of the location, such as IANA time zone name.
    type: keyword
    example: America/Argentina/Buenos_Aires
  </definition>
</definitions>


## group

The group fields are meant to represent groups that are relevant to the event.
<definitions>
  <definition term="group.domain">
    Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="group.id">
    Unique identifier for the group on the system/platform.
    type: keyword
  </definition>
  <definition term="group.name">
    Name of the group.
    type: keyword
  </definition>
</definitions>


## hash

The hash fields represent different bitwise hash algorithms and their values.
Field names for common hashes (e.g. MD5, SHA1) are predefined. Add fields for other hashes by lowercasing the hash algorithm name and using underscore separators as appropriate (snake case, e.g. sha3_512).
Note that this fieldset is used for common hashes that may be computed over a range of generic bytes. Entity-specific hashes such as ja3 or imphash are placed in the fieldsets to which they relate (tls and pe, respectively).
<definitions>
  <definition term="hash.md5">
    MD5 hash.
    type: keyword
  </definition>
  <definition term="hash.sha1">
    SHA1 hash.
    type: keyword
  </definition>
  <definition term="hash.sha256">
    SHA256 hash.
    type: keyword
  </definition>
  <definition term="hash.sha512">
    SHA512 hash.
    type: keyword
  </definition>
  <definition term="hash.ssdeep">
    SSDEEP hash.
    type: keyword
  </definition>
</definitions>


## host

A host is defined as a general computing instance.
ECS host.* fields should be populated with details about the host on which the event happened, or from which the measurement was taken. Host types include hardware, virtual machines, Docker containers, and Kubernetes nodes.
<definitions>
  <definition term="host.architecture">
    Operating system architecture.
    type: keyword
    example: x86_64
  </definition>
  <definition term="host.cpu.usage">
    Percent CPU used which is normalized by the number of CPU cores and it ranges from 0 to 1. Scaling factor: 1000. For example: For a two core host, this value should be the average of the two cores, between 0 and 1.
    type: scaled_float
  </definition>
  <definition term="host.disk.read.bytes">
    The total number of bytes (gauge) read successfully (aggregated from all disks) since the last metric collection.
    type: long
  </definition>
  <definition term="host.disk.write.bytes">
    The total number of bytes (gauge) written successfully (aggregated from all disks) since the last metric collection.
    type: long
  </definition>
  <definition term="host.domain">
    Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.
    type: keyword
    example: CONTOSO
  </definition>
  <definition term="host.geo.city_name">
    City name.
    type: keyword
    example: Montreal
  </definition>
  <definition term="host.geo.continent_code">
    Two-letter code representing continent's name.
    type: keyword
    example: NA
  </definition>
  <definition term="host.geo.continent_name">
    Name of the continent.
    type: keyword
    example: North America
  </definition>
  <definition term="host.geo.country_iso_code">
    Country ISO code.
    type: keyword
    example: CA
  </definition>
  <definition term="host.geo.country_name">
    Country name.
    type: keyword
    example: Canada
  </definition>
  <definition term="host.geo.location">
    Longitude and latitude.
    type: geo_point
    example: { "lon": -73.614830, "lat": 45.505918 }
  </definition>
  <definition term="host.geo.name">
    User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.
    type: keyword
    example: boston-dc
  </definition>
  <definition term="host.geo.postal_code">
    Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.
    type: keyword
    example: 94040
  </definition>
  <definition term="host.geo.region_iso_code">
    Region ISO code.
    type: keyword
    example: CA-QC
  </definition>
  <definition term="host.geo.region_name">
    Region name.
    type: keyword
    example: Quebec
  </definition>
  <definition term="host.geo.timezone">
    The time zone of the location, such as IANA time zone name.
    type: keyword
    example: America/Argentina/Buenos_Aires
  </definition>
  <definition term="host.hostname">
    Hostname of the host. It normally contains what the `hostname` command returns on the host machine.
    type: keyword
  </definition>
  <definition term="host.id">
    Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.
    type: keyword
  </definition>
  <definition term="host.ip">
    Host ip addresses.
    type: ip
  </definition>
  <definition term="host.mac">
    Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.
    type: keyword
    example: ["00-00-5E-00-53-23", "00-00-5E-00-53-24"]
  </definition>
  <definition term="host.name">
    Name of the host. It can contain what `hostname` returns on Unix systems, the fully qualified domain name, or a name specified by the user. The sender decides which value to use.
    type: keyword
  </definition>
  <definition term="host.network.egress.bytes">
    The number of bytes (gauge) sent out on all network interfaces by the host since the last metric collection.
    type: long
  </definition>
  <definition term="host.network.egress.packets">
    The number of packets (gauge) sent out on all network interfaces by the host since the last metric collection.
    type: long
  </definition>
  <definition term="host.network.ingress.bytes">
    The number of bytes received (gauge) on all network interfaces by the host since the last metric collection.
    type: long
  </definition>
  <definition term="host.network.ingress.packets">
    The number of packets (gauge) received on all network interfaces by the host since the last metric collection.
    type: long
  </definition>
  <definition term="host.os.family">
    OS family (such as redhat, debian, freebsd, windows).
    type: keyword
    example: debian
  </definition>
  <definition term="host.os.full">
    Operating system name, including the version or code name.
    type: keyword
    example: Mac OS Mojave
  </definition>
  <definition term="host.os.full.text">
    type: match_only_text
  </definition>
  <definition term="host.os.kernel">
    Operating system kernel version as a raw string.
    type: keyword
    example: 4.4.0-112-generic
  </definition>
  <definition term="host.os.name">
    Operating system name, without the version.
    type: keyword
    example: Mac OS X
  </definition>
  <definition term="host.os.name.text">
    type: match_only_text
  </definition>
  <definition term="host.os.platform">
    Operating system platform (such centos, ubuntu, windows).
    type: keyword
    example: darwin
  </definition>
  <definition term="host.os.type">
    Use the `os.type` field to categorize the operating system into one of the broad commercial families. One of these following values should be used (lowercase): linux, macos, unix, windows. If the OS you're dealing with is not in the list, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition.
    type: keyword
    example: macos
  </definition>
  <definition term="host.os.version">
    Operating system version as a raw string.
    type: keyword
    example: 10.14.1
  </definition>
  <definition term="host.type">
    Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.
    type: keyword
  </definition>
  <definition term="host.uptime">
    Seconds the host has been up.
    type: long
    example: 1325
  </definition>
</definitions>


## http

Fields related to HTTP activity. Use the `url` field set to store the url of the request.
<definitions>
  <definition term="http.request.body.bytes">
    Size in bytes of the request body.
    type: long
    example: 887
    format: bytes
  </definition>
  <definition term="http.request.body.content">
    The full HTTP request body.
    type: wildcard
    example: Hello world
  </definition>
  <definition term="http.request.body.content.text">
    type: match_only_text
  </definition>
  <definition term="http.request.bytes">
    Total size in bytes of the request (body and headers).
    type: long
    example: 1437
    format: bytes
  </definition>
  <definition term="http.request.id">
    A unique identifier for each HTTP request to correlate logs between clients and servers in transactions. The id may be contained in a non-standard HTTP header, such as `X-Request-ID` or `X-Correlation-ID`.
    type: keyword
    example: 123e4567-e89b-12d3-a456-426614174000
  </definition>
  <definition term="http.request.method">
    HTTP request method. The value should retain its casing from the original event. For example, `GET`, `get`, and `GeT` are all considered valid values for this field.
    type: keyword
    example: POST
  </definition>
  <definition term="http.request.mime_type">
    Mime type of the body of the request. This value must only be populated based on the content of the request body, not on the `Content-Type` header. Comparing the mime type of a request with the request's Content-Type header can be helpful in detecting threats or misconfigured clients.
    type: keyword
    example: image/gif
  </definition>
  <definition term="http.request.referrer">
    Referrer for this HTTP request.
    type: keyword
    example: https://blog.example.com/
  </definition>
  <definition term="http.response.body.bytes">
    Size in bytes of the response body.
    type: long
    example: 887
    format: bytes
  </definition>
  <definition term="http.response.body.content">
    The full HTTP response body.
    type: wildcard
    example: Hello world
  </definition>
  <definition term="http.response.body.content.text">
    type: match_only_text
  </definition>
  <definition term="http.response.bytes">
    Total size in bytes of the response (body and headers).
    type: long
    example: 1437
    format: bytes
  </definition>
  <definition term="http.response.mime_type">
    Mime type of the body of the response. This value must only be populated based on the content of the response body, not on the `Content-Type` header. Comparing the mime type of a response with the response's Content-Type header can be helpful in detecting misconfigured servers.
    type: keyword
    example: image/gif
  </definition>
  <definition term="http.response.status_code">
    HTTP response status code.
    type: long
    example: 404
    format: string
  </definition>
  <definition term="http.version">
    HTTP version.
    type: keyword
    example: 1.1
  </definition>
</definitions>


## interface

The interface fields are used to record ingress and egress interface information when reported by an observer (e.g. firewall, router, load balancer) in the context of the observer handling a network connection.  In the case of a single observer interface (e.g. network sensor on a span port) only the observer.ingress information should be populated.
<definitions>
  <definition term="interface.alias">
    Interface alias as reported by the system, typically used in firewall implementations for e.g. inside, outside, or dmz logical interface naming.
    type: keyword
    example: outside
  </definition>
  <definition term="interface.id">
    Interface ID as reported by an observer (typically SNMP interface ID).
    type: keyword
    example: 10
  </definition>
  <definition term="interface.name">
    Interface name as reported by the system.
    type: keyword
    example: eth0
  </definition>
</definitions>


## log

Details about the event's logging mechanism or logging transport.
The log.* fields are typically populated with details about the logging mechanism used to create and/or transport the event. For example, syslog details belong under `log.syslog.*`.
The details specific to your event source are typically not logged under `log.*`, but rather in `event.*` or in other ECS fields.
<definitions>
  <definition term="log.file.path">
    Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.
    type: keyword
    example: /var/log/fun-times.log
  </definition>
  <definition term="log.level">
    Original log level of the log event. If the source of the event provides a log level or textual severity, this is the one that goes in `log.level`. If your source doesn't specify one, you may put your event transport's severity here (e.g. Syslog severity). Some examples are `warn`, `err`, `i`, `informational`.
    type: keyword
    example: error
  </definition>
  <definition term="log.logger">
    The name of the logger inside an application. This is usually the name of the class which initialized the logger, or can be a custom name.
    type: keyword
    example: org.elasticsearch.bootstrap.Bootstrap
  </definition>
  <definition term="log.origin.file.line">
    The line number of the file containing the source code which originated the log event.
    type: long
    example: 42
  </definition>
  <definition term="log.origin.file.name">
    The name of the file containing the source code which originated the log event. Note that this field is not meant to capture the log file. The correct field to capture the log file is `log.file.path`.
    type: keyword
    example: Bootstrap.java
  </definition>
  <definition term="log.origin.function">
    The name of the function or method which originated the log event.
    type: keyword
    example: init
  </definition>
  <definition term="log.syslog">
    The Syslog metadata of the event, if the event was transmitted via Syslog. Please see RFCs 5424 or 3164.
    type: object
  </definition>
  <definition term="log.syslog.facility.code">
    The Syslog numeric facility of the log event, if available. According to RFCs 5424 and 3164, this value should be an integer between 0 and 23.
    type: long
    example: 23
    format: string
  </definition>
  <definition term="log.syslog.facility.name">
    The Syslog text-based facility of the log event, if available.
    type: keyword
    example: local7
  </definition>
  <definition term="log.syslog.priority">
    Syslog numeric priority of the event, if available. According to RFCs 5424 and 3164, the priority is 8 * facility + severity. This number is therefore expected to contain a value between 0 and 191.
    type: long
    example: 135
    format: string
  </definition>
  <definition term="log.syslog.severity.code">
    The Syslog numeric severity of the log event, if available. If the event source publishing via Syslog provides a different numeric severity value (e.g. firewall, IDS), your source's numeric severity should go to `event.severity`. If the event source does not specify a distinct severity, you can optionally copy the Syslog severity to `event.severity`.
    type: long
    example: 3
  </definition>
  <definition term="log.syslog.severity.name">
    The Syslog numeric severity of the log event, if available. If the event source publishing via Syslog provides a different severity value (e.g. firewall, IDS), your source's text severity should go to `log.level`. If the event source does not specify a distinct severity, you can optionally copy the Syslog severity to `log.level`.
    type: keyword
    example: Error
  </definition>
</definitions>


## network

The network is defined as the communication path over which a host or network event happens.
The network.* fields should be populated with details about the network activity associated with an event.
<definitions>
  <definition term="network.application">
    When a specific application or service is identified from network connection details (source/dest IPs, ports, certificates, or wire format), this field captures the application's or service's name. For example, the original event identifies the network connection being from a specific web service in a `https` network connection, like `facebook` or `twitter`. The field value must be normalized to lowercase for querying.
    type: keyword
    example: aim
  </definition>
  <definition term="network.bytes">
    Total bytes transferred in both directions. If `source.bytes` and `destination.bytes` are known, `network.bytes` is their sum.
    type: long
    example: 368
    format: bytes
  </definition>
  <definition term="network.community_id">
    A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at [https://github.com/corelight/community-id-spec](https://github.com/corelight/community-id-spec).
    type: keyword
    example: 1:hO+sN4H+MG5MY/8hIrXPqc4ZQz0=
  </definition>
  <definition term="network.direction">
    Direction of the network traffic. Recommended values are:   * ingress   * egress   * inbound   * outbound   * internal   * external   * unknown When mapping events from a host-based monitoring context, populate this field from the host's point of view, using the values "ingress" or "egress". When mapping events from a network or perimeter-based monitoring context, populate this field from the point of view of the network perimeter, using the values "inbound", "outbound", "internal" or "external". Note that "internal" is not crossing perimeter boundaries, and is meant to describe communication between two hosts within the perimeter. Note also that "external" is meant to describe traffic between two hosts that are external to the perimeter. This could for example be useful for ISPs or VPN service providers.
    type: keyword
    example: inbound
  </definition>
  <definition term="network.forwarded_ip">
    Host IP address when the source IP address is the proxy.
    type: ip
    example: 192.1.1.2
  </definition>
  <definition term="network.iana_number">
    IANA Protocol Number ([https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)). Standardized list of protocols. This aligns well with NetFlow and sFlow related logs which use the IANA Protocol Number.
    type: keyword
    example: 6
  </definition>
  <definition term="network.inner">
    Network.inner fields are added in addition to network.vlan fields to describe the innermost VLAN when q-in-q VLAN tagging is present. Allowed fields include vlan.id and vlan.name. Inner vlan fields are typically used when sending traffic with multiple 802.1q encapsulations to a network sensor (e.g. Zeek, Wireshark.)
    type: object
  </definition>
  <definition term="network.inner.vlan.id">
    VLAN ID as reported by the observer.
    type: keyword
    example: 10
  </definition>
  <definition term="network.inner.vlan.name">
    Optional VLAN name as reported by the observer.
    type: keyword
    example: outside
  </definition>
  <definition term="network.name">
    Name given by operators to sections of their network.
    type: keyword
    example: Guest Wifi
  </definition>
  <definition term="network.packets">
    Total packets transferred in both directions. If `source.packets` and `destination.packets` are known, `network.packets` is their sum.
    type: long
    example: 24
  </definition>
  <definition term="network.protocol">
    In the OSI Model this would be the Application Layer protocol. For example, `http`, `dns`, or `ssh`. The field value must be normalized to lowercase for querying.
    type: keyword
    example: http
  </definition>
  <definition term="network.transport">
    Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.) The field value must be normalized to lowercase for querying.
    type: keyword
    example: tcp
  </definition>
  <definition term="network.type">
    In the OSI Model this would be the Network Layer. ipv4, ipv6, ipsec, pim, etc The field value must be normalized to lowercase for querying.
    type: keyword
    example: ipv4
  </definition>
  <definition term="network.vlan.id">
    VLAN ID as reported by the observer.
    type: keyword
    example: 10
  </definition>
  <definition term="network.vlan.name">
    Optional VLAN name as reported by the observer.
    type: keyword
    example: outside
  </definition>
</definitions>


## observer

An observer is defined as a special network, security, or application device used to detect, observe, or create network, security, or application-related events and metrics.
This could be a custom hardware appliance or a server that has been configured to run special network, security, or application software. Examples include firewalls, web proxies, intrusion detection/prevention systems, network monitoring sensors, web application firewalls, data loss prevention systems, and APM servers. The observer.* fields shall be populated with details of the system, if any, that detects, observes and/or creates a network, security, or application event or metric. Message queues and ETL components used in processing events or metrics are not considered observers in ECS.
<definitions>
  <definition term="observer.egress">
    Observer.egress holds information like interface number and name, vlan, and zone information to classify egress traffic.  Single armed monitoring such as a network sensor on a span port should only use observer.ingress to categorize traffic.
    type: object
  </definition>
  <definition term="observer.egress.interface.alias">
    Interface alias as reported by the system, typically used in firewall implementations for e.g. inside, outside, or dmz logical interface naming.
    type: keyword
    example: outside
  </definition>
  <definition term="observer.egress.interface.id">
    Interface ID as reported by an observer (typically SNMP interface ID).
    type: keyword
    example: 10
  </definition>
  <definition term="observer.egress.interface.name">
    Interface name as reported by the system.
    type: keyword
    example: eth0
  </definition>
  <definition term="observer.egress.vlan.id">
    VLAN ID as reported by the observer.
    type: keyword
    example: 10
  </definition>
  <definition term="observer.egress.vlan.name">
    Optional VLAN name as reported by the observer.
    type: keyword
    example: outside
  </definition>
  <definition term="observer.egress.zone">
    Network zone of outbound traffic as reported by the observer to categorize the destination area of egress traffic, e.g. Internal, External, DMZ, HR, Legal, etc.
    type: keyword
    example: Public_Internet
  </definition>
  <definition term="observer.geo.city_name">
    City name.
    type: keyword
    example: Montreal
  </definition>
  <definition term="observer.geo.continent_code">
    Two-letter code representing continent's name.
    type: keyword
    example: NA
  </definition>
  <definition term="observer.geo.continent_name">
    Name of the continent.
    type: keyword
    example: North America
  </definition>
  <definition term="observer.geo.country_iso_code">
    Country ISO code.
    type: keyword
    example: CA
  </definition>
  <definition term="observer.geo.country_name">
    Country name.
    type: keyword
    example: Canada
  </definition>
  <definition term="observer.geo.location">
    Longitude and latitude.
    type: geo_point
    example: { "lon": -73.614830, "lat": 45.505918 }
  </definition>
  <definition term="observer.geo.name">
    User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.
    type: keyword
    example: boston-dc
  </definition>
  <definition term="observer.geo.postal_code">
    Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.
    type: keyword
    example: 94040
  </definition>
  <definition term="observer.geo.region_iso_code">
    Region ISO code.
    type: keyword
    example: CA-QC
  </definition>
  <definition term="observer.geo.region_name">
    Region name.
    type: keyword
    example: Quebec
  </definition>
  <definition term="observer.geo.timezone">
    The time zone of the location, such as IANA time zone name.
    type: keyword
    example: America/Argentina/Buenos_Aires
  </definition>
  <definition term="observer.hostname">
    Hostname of the observer.
    type: keyword
  </definition>
  <definition term="observer.ingress">
    Observer.ingress holds information like interface number and name, vlan, and zone information to classify ingress traffic.  Single armed monitoring such as a network sensor on a span port should only use observer.ingress to categorize traffic.
    type: object
  </definition>
  <definition term="observer.ingress.interface.alias">
    Interface alias as reported by the system, typically used in firewall implementations for e.g. inside, outside, or dmz logical interface naming.
    type: keyword
    example: outside
  </definition>
  <definition term="observer.ingress.interface.id">
    Interface ID as reported by an observer (typically SNMP interface ID).
    type: keyword
    example: 10
  </definition>
  <definition term="observer.ingress.interface.name">
    Interface name as reported by the system.
    type: keyword
    example: eth0
  </definition>
  <definition term="observer.ingress.vlan.id">
    VLAN ID as reported by the observer.
    type: keyword
    example: 10
  </definition>
  <definition term="observer.ingress.vlan.name">
    Optional VLAN name as reported by the observer.
    type: keyword
    example: outside
  </definition>
  <definition term="observer.ingress.zone">
    Network zone of incoming traffic as reported by the observer to categorize the source area of ingress traffic. e.g. internal, External, DMZ, HR, Legal, etc.
    type: keyword
    example: DMZ
  </definition>
  <definition term="observer.ip">
    IP addresses of the observer.
    type: ip
  </definition>
  <definition term="observer.mac">
    MAC addresses of the observer. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.
    type: keyword
    example: ["00-00-5E-00-53-23", "00-00-5E-00-53-24"]
  </definition>
  <definition term="observer.name">
    Custom name of the observer. This is a name that can be given to an observer. This can be helpful for example if multiple firewalls of the same model are used in an organization. If no custom name is needed, the field can be left empty.
    type: keyword
    example: 1_proxySG
  </definition>
  <definition term="observer.os.family">
    OS family (such as redhat, debian, freebsd, windows).
    type: keyword
    example: debian
  </definition>
  <definition term="observer.os.full">
    Operating system name, including the version or code name.
    type: keyword
    example: Mac OS Mojave
  </definition>
  <definition term="observer.os.full.text">
    type: match_only_text
  </definition>
  <definition term="observer.os.kernel">
    Operating system kernel version as a raw string.
    type: keyword
    example: 4.4.0-112-generic
  </definition>
  <definition term="observer.os.name">
    Operating system name, without the version.
    type: keyword
    example: Mac OS X
  </definition>
  <definition term="observer.os.name.text">
    type: match_only_text
  </definition>
  <definition term="observer.os.platform">
    Operating system platform (such centos, ubuntu, windows).
    type: keyword
    example: darwin
  </definition>
  <definition term="observer.os.type">
    Use the `os.type` field to categorize the operating system into one of the broad commercial families. One of these following values should be used (lowercase): linux, macos, unix, windows. If the OS you're dealing with is not in the list, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition.
    type: keyword
    example: macos
  </definition>
  <definition term="observer.os.version">
    Operating system version as a raw string.
    type: keyword
    example: 10.14.1
  </definition>
  <definition term="observer.product">
    The product name of the observer.
    type: keyword
    example: s200
  </definition>
  <definition term="observer.serial_number">
    Observer serial number.
    type: keyword
  </definition>
  <definition term="observer.type">
    The type of the observer the data is coming from. There is no predefined list of observer types. Some examples are `forwarder`, `firewall`, `ids`, `ips`, `proxy`, `poller`, `sensor`, `APM server`.
    type: keyword
    example: firewall
  </definition>
  <definition term="observer.vendor">
    Vendor name of the observer.
    type: keyword
    example: Symantec
  </definition>
  <definition term="observer.version">
    Observer version.
    type: keyword
  </definition>
</definitions>


## orchestrator

Fields that describe the resources which container orchestrators manage or act upon.
<definitions>
  <definition term="orchestrator.api_version">
    API version being used to carry out the action
    type: keyword
    example: v1beta1
  </definition>
  <definition term="orchestrator.cluster.name">
    Name of the cluster.
    type: keyword
  </definition>
  <definition term="orchestrator.cluster.url">
    URL of the API used to manage the cluster.
    type: keyword
  </definition>
  <definition term="orchestrator.cluster.version">
    The version of the cluster.
    type: keyword
  </definition>
  <definition term="orchestrator.namespace">
    Namespace in which the action is taking place.
    type: keyword
    example: kube-system
  </definition>
  <definition term="orchestrator.organization">
    Organization affected by the event (for multi-tenant orchestrator setups).
    type: keyword
    example: elastic
  </definition>
  <definition term="orchestrator.resource.name">
    Name of the resource being acted upon.
    type: keyword
    example: test-pod-cdcws
  </definition>
  <definition term="orchestrator.resource.type">
    Type of resource being acted upon.
    type: keyword
    example: service
  </definition>
  <definition term="orchestrator.type">
    Orchestrator cluster type (e.g. kubernetes, nomad or cloudfoundry).
    type: keyword
    example: kubernetes
  </definition>
</definitions>


## organization

The organization fields enrich data with information about the company or entity the data is associated with.
These fields help you arrange or filter data stored in an index by one or multiple organizations.
<definitions>
  <definition term="organization.id">
    Unique identifier for the organization.
    type: keyword
  </definition>
  <definition term="organization.name">
    Organization name.
    type: keyword
  </definition>
  <definition term="organization.name.text">
    type: match_only_text
  </definition>
</definitions>


## os

The OS fields contain information about the operating system.
<definitions>
  <definition term="os.family">
    OS family (such as redhat, debian, freebsd, windows).
    type: keyword
    example: debian
  </definition>
  <definition term="os.full">
    Operating system name, including the version or code name.
    type: keyword
    example: Mac OS Mojave
  </definition>
  <definition term="os.full.text">
    type: match_only_text
  </definition>
  <definition term="os.kernel">
    Operating system kernel version as a raw string.
    type: keyword
    example: 4.4.0-112-generic
  </definition>
  <definition term="os.name">
    Operating system name, without the version.
    type: keyword
    example: Mac OS X
  </definition>
  <definition term="os.name.text">
    type: match_only_text
  </definition>
  <definition term="os.platform">
    Operating system platform (such centos, ubuntu, windows).
    type: keyword
    example: darwin
  </definition>
  <definition term="os.type">
    Use the `os.type` field to categorize the operating system into one of the broad commercial families. One of these following values should be used (lowercase): linux, macos, unix, windows. If the OS you're dealing with is not in the list, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition.
    type: keyword
    example: macos
  </definition>
  <definition term="os.version">
    Operating system version as a raw string.
    type: keyword
    example: 10.14.1
  </definition>
</definitions>


## package

These fields contain information about an installed software package. It contains general information about a package, such as name, version or size. It also contains installation details, such as time or location.
<definitions>
  <definition term="package.architecture">
    Package architecture.
    type: keyword
    example: x86_64
  </definition>
  <definition term="package.build_version">
    Additional information about the build version of the installed package. For example use the commit SHA of a non-released package.
    type: keyword
    example: 36f4f7e89dd61b0988b12ee000b98966867710cd
  </definition>
  <definition term="package.checksum">
    Checksum of the installed package for verification.
    type: keyword
    example: 68b329da9893e34099c7d8ad5cb9c940
  </definition>
  <definition term="package.description">
    Description of the package.
    type: keyword
    example: Open source programming language to build simple/reliable/efficient software.
  </definition>
  <definition term="package.install_scope">
    Indicating how the package was installed, e.g. user-local, global.
    type: keyword
    example: global
  </definition>
  <definition term="package.installed">
    Time when package was installed.
    type: date
  </definition>
  <definition term="package.license">
    License under which the package was released. Use a short name, e.g. the license identifier from SPDX License List where possible ([https://spdx.org/licenses/](https://spdx.org/licenses/)).
    type: keyword
    example: Apache License 2.0
  </definition>
  <definition term="package.name">
    Package name
    type: keyword
    example: go
  </definition>
  <definition term="package.path">
    Path where the package is installed.
    type: keyword
    example: /usr/local/Cellar/go/1.12.9/
  </definition>
  <definition term="package.reference">
    Home page or reference URL of the software in this package, if available.
    type: keyword
    example: [https://golang.org](https://golang.org)
  </definition>
  <definition term="package.size">
    Package size in bytes.
    type: long
    example: 62231
    format: string
  </definition>
  <definition term="package.type">
    Type of package. This should contain the package file type, rather than the package manager name. Examples: rpm, dpkg, brew, npm, gem, nupkg, jar.
    type: keyword
    example: rpm
  </definition>
  <definition term="package.version">
    Package version
    type: keyword
    example: 1.12.9
  </definition>
</definitions>


## pe

These fields contain Windows Portable Executable (PE) metadata.
<definitions>
  <definition term="pe.architecture">
    CPU architecture target for the file.
    type: keyword
    example: x64
  </definition>
  <definition term="pe.company">
    Internal company name of the file, provided at compile-time.
    type: keyword
    example: Microsoft Corporation
  </definition>
  <definition term="pe.description">
    Internal description of the file, provided at compile-time.
    type: keyword
    example: Paint
  </definition>
  <definition term="pe.file_version">
    Internal version of the file, provided at compile-time.
    type: keyword
    example: 6.3.9600.17415
  </definition>
  <definition term="pe.imphash">
    A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at [https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html](https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html).
    type: keyword
    example: 0c6803c4e922103c4dca5963aad36ddf
  </definition>
  <definition term="pe.original_file_name">
    Internal name of the file, provided at compile-time.
    type: keyword
    example: MSPAINT.EXE
  </definition>
  <definition term="pe.product">
    Internal product name of the file, provided at compile-time.
    type: keyword
    example: Microsoft® Windows® Operating System
  </definition>
</definitions>


## process

These fields contain information about a process.
These fields can help you correlate metrics information with a process id/name from a log message.  The `process.pid` often stays in the metric itself and is copied to the global field for correlation.
<definitions>
  <definition term="process.args">
    Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information.
    type: keyword
    example: ["/usr/bin/ssh", "-l", "user", "10.0.0.16"]
  </definition>
  <definition term="process.args_count">
    Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity.
    type: long
    example: 4
  </definition>
  <definition term="process.code_signature.digest_algorithm">
    The hashing algorithm used to sign the process. This value can distinguish signatures when a file is signed multiple times by the same signer but with a different digest algorithm.
    type: keyword
    example: sha256
  </definition>
  <definition term="process.code_signature.exists">
    Boolean to capture if a signature is present.
    type: boolean
    example: true
  </definition>
  <definition term="process.code_signature.signing_id">
    The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only.
    type: keyword
    example: com.apple.xpc.proxy
  </definition>
  <definition term="process.code_signature.status">
    Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.
    type: keyword
    example: ERROR_UNTRUSTED_ROOT
  </definition>
  <definition term="process.code_signature.subject_name">
    Subject name of the code signer
    type: keyword
    example: Microsoft Corporation
  </definition>
  <definition term="process.code_signature.team_id">
    The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only.
    type: keyword
    example: EQHXZ8M8AV
  </definition>
  <definition term="process.code_signature.timestamp">
    Date and time when the code signature was generated and signed.
    type: date
    example: 2021-01-01T12:10:30Z
  </definition>
  <definition term="process.code_signature.trusted">
    Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.
    type: boolean
    example: true
  </definition>
  <definition term="process.code_signature.valid">
    Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked.
    type: boolean
    example: true
  </definition>
  <definition term="process.command_line">
    Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information.
    type: wildcard
    example: /usr/bin/ssh -l user 10.0.0.16
  </definition>
  <definition term="process.command_line.text">
    type: match_only_text
  </definition>
  <definition term="process.elf.architecture">
    Machine architecture of the ELF file.
    type: keyword
    example: x86-64
  </definition>
  <definition term="process.elf.byte_order">
    Byte sequence of ELF file.
    type: keyword
    example: Little Endian
  </definition>
  <definition term="process.elf.cpu_type">
    CPU type of the ELF file.
    type: keyword
    example: Intel
  </definition>
  <definition term="process.elf.creation_date">
    Extracted when possible from the file's metadata. Indicates when it was built or compiled. It can also be faked by malware creators.
    type: date
  </definition>
  <definition term="process.elf.exports">
    List of exported element names and types.
    type: flattened
  </definition>
  <definition term="process.elf.header.abi_version">
    Version of the ELF Application Binary Interface (ABI).
    type: keyword
  </definition>
  <definition term="process.elf.header.class">
    Header class of the ELF file.
    type: keyword
  </definition>
  <definition term="process.elf.header.data">
    Data table of the ELF header.
    type: keyword
  </definition>
  <definition term="process.elf.header.entrypoint">
    Header entrypoint of the ELF file.
    type: long
    format: string
  </definition>
  <definition term="process.elf.header.object_version">
    "0x1" for original ELF files.
    type: keyword
  </definition>
  <definition term="process.elf.header.os_abi">
    Application Binary Interface (ABI) of the Linux OS.
    type: keyword
  </definition>
  <definition term="process.elf.header.type">
    Header type of the ELF file.
    type: keyword
  </definition>
  <definition term="process.elf.header.version">
    Version of the ELF header.
    type: keyword
  </definition>
  <definition term="process.elf.imports">
    List of imported element names and types.
    type: flattened
  </definition>
  <definition term="process.elf.sections">
    An array containing an object for each section of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.sections.*`.
    type: nested
  </definition>
  <definition term="process.elf.sections.chi2">
    Chi-square probability distribution of the section.
    type: long
    format: number
  </definition>
  <definition term="process.elf.sections.entropy">
    Shannon entropy calculation from the section.
    type: long
    format: number
  </definition>
  <definition term="process.elf.sections.flags">
    ELF Section List flags.
    type: keyword
  </definition>
  <definition term="process.elf.sections.name">
    ELF Section List name.
    type: keyword
  </definition>
  <definition term="process.elf.sections.physical_offset">
    ELF Section List offset.
    type: keyword
  </definition>
  <definition term="process.elf.sections.physical_size">
    ELF Section List physical size.
    type: long
    format: bytes
  </definition>
  <definition term="process.elf.sections.type">
    ELF Section List type.
    type: keyword
  </definition>
  <definition term="process.elf.sections.virtual_address">
    ELF Section List virtual address.
    type: long
    format: string
  </definition>
  <definition term="process.elf.sections.virtual_size">
    ELF Section List virtual size.
    type: long
    format: string
  </definition>
  <definition term="process.elf.segments">
    An array containing an object for each segment of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.segments.*`.
    type: nested
  </definition>
  <definition term="process.elf.segments.sections">
    ELF object segment sections.
    type: keyword
  </definition>
  <definition term="process.elf.segments.type">
    ELF object segment type.
    type: keyword
  </definition>
  <definition term="process.elf.shared_libraries">
    List of shared libraries used by this ELF object.
    type: keyword
  </definition>
  <definition term="process.elf.telfhash">
    telfhash symbol hash for ELF file.
    type: keyword
  </definition>
  <definition term="process.end">
    The time the process ended.
    type: date
    example: 2016-05-23T08:05:34.853Z
  </definition>
  <definition term="process.entity_id">
    Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts.
    type: keyword
    example: c2c455d9f99375d
  </definition>
  <definition term="process.executable">
    Absolute path to the process executable.
    type: keyword
    example: /usr/bin/ssh
  </definition>
  <definition term="process.executable.text">
    type: match_only_text
  </definition>
  <definition term="process.exit_code">
    The exit code of the process, if this is a termination event. The field should be absent if there is no exit code for the event (e.g. process start).
    type: long
    example: 137
  </definition>
  <definition term="process.hash.md5">
    MD5 hash.
    type: keyword
  </definition>
  <definition term="process.hash.sha1">
    SHA1 hash.
    type: keyword
  </definition>
  <definition term="process.hash.sha256">
    SHA256 hash.
    type: keyword
  </definition>
  <definition term="process.hash.sha512">
    SHA512 hash.
    type: keyword
  </definition>
  <definition term="process.hash.ssdeep">
    SSDEEP hash.
    type: keyword
  </definition>
  <definition term="process.name">
    Process name. Sometimes called program name or similar.
    type: keyword
    example: ssh
  </definition>
  <definition term="process.name.text">
    type: match_only_text
  </definition>
  <definition term="process.parent.args">
    Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information.
    type: keyword
    example: ["/usr/bin/ssh", "-l", "user", "10.0.0.16"]
  </definition>
  <definition term="process.parent.args_count">
    Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity.
    type: long
    example: 4
  </definition>
  <definition term="process.parent.code_signature.digest_algorithm">
    The hashing algorithm used to sign the process. This value can distinguish signatures when a file is signed multiple times by the same signer but with a different digest algorithm.
    type: keyword
    example: sha256
  </definition>
  <definition term="process.parent.code_signature.exists">
    Boolean to capture if a signature is present.
    type: boolean
    example: true
  </definition>
  <definition term="process.parent.code_signature.signing_id">
    The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only.
    type: keyword
    example: com.apple.xpc.proxy
  </definition>
  <definition term="process.parent.code_signature.status">
    Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.
    type: keyword
    example: ERROR_UNTRUSTED_ROOT
  </definition>
  <definition term="process.parent.code_signature.subject_name">
    Subject name of the code signer
    type: keyword
    example: Microsoft Corporation
  </definition>
  <definition term="process.parent.code_signature.team_id">
    The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only.
    type: keyword
    example: EQHXZ8M8AV
  </definition>
  <definition term="process.parent.code_signature.timestamp">
    Date and time when the code signature was generated and signed.
    type: date
    example: 2021-01-01T12:10:30Z
  </definition>
  <definition term="process.parent.code_signature.trusted">
    Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.
    type: boolean
    example: true
  </definition>
  <definition term="process.parent.code_signature.valid">
    Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked.
    type: boolean
    example: true
  </definition>
  <definition term="process.parent.command_line">
    Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information.
    type: wildcard
    example: /usr/bin/ssh -l user 10.0.0.16
  </definition>
  <definition term="process.parent.command_line.text">
    type: match_only_text
  </definition>
  <definition term="process.parent.elf.architecture">
    Machine architecture of the ELF file.
    type: keyword
    example: x86-64
  </definition>
  <definition term="process.parent.elf.byte_order">
    Byte sequence of ELF file.
    type: keyword
    example: Little Endian
  </definition>
  <definition term="process.parent.elf.cpu_type">
    CPU type of the ELF file.
    type: keyword
    example: Intel
  </definition>
  <definition term="process.parent.elf.creation_date">
    Extracted when possible from the file's metadata. Indicates when it was built or compiled. It can also be faked by malware creators.
    type: date
  </definition>
  <definition term="process.parent.elf.exports">
    List of exported element names and types.
    type: flattened
  </definition>
  <definition term="process.parent.elf.header.abi_version">
    Version of the ELF Application Binary Interface (ABI).
    type: keyword
  </definition>
  <definition term="process.parent.elf.header.class">
    Header class of the ELF file.
    type: keyword
  </definition>
  <definition term="process.parent.elf.header.data">
    Data table of the ELF header.
    type: keyword
  </definition>
  <definition term="process.parent.elf.header.entrypoint">
    Header entrypoint of the ELF file.
    type: long
    format: string
  </definition>
  <definition term="process.parent.elf.header.object_version">
    "0x1" for original ELF files.
    type: keyword
  </definition>
  <definition term="process.parent.elf.header.os_abi">
    Application Binary Interface (ABI) of the Linux OS.
    type: keyword
  </definition>
  <definition term="process.parent.elf.header.type">
    Header type of the ELF file.
    type: keyword
  </definition>
  <definition term="process.parent.elf.header.version">
    Version of the ELF header.
    type: keyword
  </definition>
  <definition term="process.parent.elf.imports">
    List of imported element names and types.
    type: flattened
  </definition>
  <definition term="process.parent.elf.sections">
    An array containing an object for each section of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.sections.*`.
    type: nested
  </definition>
  <definition term="process.parent.elf.sections.chi2">
    Chi-square probability distribution of the section.
    type: long
    format: number
  </definition>
  <definition term="process.parent.elf.sections.entropy">
    Shannon entropy calculation from the section.
    type: long
    format: number
  </definition>
  <definition term="process.parent.elf.sections.flags">
    ELF Section List flags.
    type: keyword
  </definition>
  <definition term="process.parent.elf.sections.name">
    ELF Section List name.
    type: keyword
  </definition>
  <definition term="process.parent.elf.sections.physical_offset">
    ELF Section List offset.
    type: keyword
  </definition>
  <definition term="process.parent.elf.sections.physical_size">
    ELF Section List physical size.
    type: long
    format: bytes
  </definition>
  <definition term="process.parent.elf.sections.type">
    ELF Section List type.
    type: keyword
  </definition>
  <definition term="process.parent.elf.sections.virtual_address">
    ELF Section List virtual address.
    type: long
    format: string
  </definition>
  <definition term="process.parent.elf.sections.virtual_size">
    ELF Section List virtual size.
    type: long
    format: string
  </definition>
  <definition term="process.parent.elf.segments">
    An array containing an object for each segment of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.segments.*`.
    type: nested
  </definition>
  <definition term="process.parent.elf.segments.sections">
    ELF object segment sections.
    type: keyword
  </definition>
  <definition term="process.parent.elf.segments.type">
    ELF object segment type.
    type: keyword
  </definition>
  <definition term="process.parent.elf.shared_libraries">
    List of shared libraries used by this ELF object.
    type: keyword
  </definition>
  <definition term="process.parent.elf.telfhash">
    telfhash symbol hash for ELF file.
    type: keyword
  </definition>
  <definition term="process.parent.end">
    The time the process ended.
    type: date
    example: 2016-05-23T08:05:34.853Z
  </definition>
  <definition term="process.parent.entity_id">
    Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts.
    type: keyword
    example: c2c455d9f99375d
  </definition>
  <definition term="process.parent.executable">
    Absolute path to the process executable.
    type: keyword
    example: /usr/bin/ssh
  </definition>
  <definition term="process.parent.executable.text">
    type: match_only_text
  </definition>
  <definition term="process.parent.exit_code">
    The exit code of the process, if this is a termination event. The field should be absent if there is no exit code for the event (e.g. process start).
    type: long
    example: 137
  </definition>
  <definition term="process.parent.hash.md5">
    MD5 hash.
    type: keyword
  </definition>
  <definition term="process.parent.hash.sha1">
    SHA1 hash.
    type: keyword
  </definition>
  <definition term="process.parent.hash.sha256">
    SHA256 hash.
    type: keyword
  </definition>
  <definition term="process.parent.hash.sha512">
    SHA512 hash.
    type: keyword
  </definition>
  <definition term="process.parent.hash.ssdeep">
    SSDEEP hash.
    type: keyword
  </definition>
  <definition term="process.parent.name">
    Process name. Sometimes called program name or similar.
    type: keyword
    example: ssh
  </definition>
  <definition term="process.parent.name.text">
    type: match_only_text
  </definition>
  <definition term="process.parent.pe.architecture">
    CPU architecture target for the file.
    type: keyword
    example: x64
  </definition>
  <definition term="process.parent.pe.company">
    Internal company name of the file, provided at compile-time.
    type: keyword
    example: Microsoft Corporation
  </definition>
  <definition term="process.parent.pe.description">
    Internal description of the file, provided at compile-time.
    type: keyword
    example: Paint
  </definition>
  <definition term="process.parent.pe.file_version">
    Internal version of the file, provided at compile-time.
    type: keyword
    example: 6.3.9600.17415
  </definition>
  <definition term="process.parent.pe.imphash">
    A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at [https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html](https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html).
    type: keyword
    example: 0c6803c4e922103c4dca5963aad36ddf
  </definition>
  <definition term="process.parent.pe.original_file_name">
    Internal name of the file, provided at compile-time.
    type: keyword
    example: MSPAINT.EXE
  </definition>
  <definition term="process.parent.pe.product">
    Internal product name of the file, provided at compile-time.
    type: keyword
    example: Microsoft® Windows® Operating System
  </definition>
  <definition term="process.parent.pgid">
    Identifier of the group of processes the process belongs to.
    type: long
    format: string
  </definition>
  <definition term="process.parent.pid">
    Process id.
    type: long
    example: 4242
    format: string
  </definition>
  <definition term="process.parent.start">
    The time the process started.
    type: date
    example: 2016-05-23T08:05:34.853Z
  </definition>
  <definition term="process.parent.thread.id">
    Thread ID.
    type: long
    example: 4242
    format: string
  </definition>
  <definition term="process.parent.thread.name">
    Thread name.
    type: keyword
    example: thread-0
  </definition>
  <definition term="process.parent.title">
    Process title. The proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened.
    type: keyword
  </definition>
  <definition term="process.parent.title.text">
    type: match_only_text
  </definition>
  <definition term="process.parent.uptime">
    Seconds the process has been up.
    type: long
    example: 1325
  </definition>
  <definition term="process.parent.working_directory">
    The working directory of the process.
    type: keyword
    example: /home/alice
  </definition>
  <definition term="process.parent.working_directory.text">
    type: match_only_text
  </definition>
  <definition term="process.pe.architecture">
    CPU architecture target for the file.
    type: keyword
    example: x64
  </definition>
  <definition term="process.pe.company">
    Internal company name of the file, provided at compile-time.
    type: keyword
    example: Microsoft Corporation
  </definition>
  <definition term="process.pe.description">
    Internal description of the file, provided at compile-time.
    type: keyword
    example: Paint
  </definition>
  <definition term="process.pe.file_version">
    Internal version of the file, provided at compile-time.
    type: keyword
    example: 6.3.9600.17415
  </definition>
  <definition term="process.pe.imphash">
    A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at [https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html](https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html).
    type: keyword
    example: 0c6803c4e922103c4dca5963aad36ddf
  </definition>
  <definition term="process.pe.original_file_name">
    Internal name of the file, provided at compile-time.
    type: keyword
    example: MSPAINT.EXE
  </definition>
  <definition term="process.pe.product">
    Internal product name of the file, provided at compile-time.
    type: keyword
    example: Microsoft® Windows® Operating System
  </definition>
  <definition term="process.pgid">
    Identifier of the group of processes the process belongs to.
    type: long
    format: string
  </definition>
  <definition term="process.pid">
    Process id.
    type: long
    example: 4242
    format: string
  </definition>
  <definition term="process.start">
    The time the process started.
    type: date
    example: 2016-05-23T08:05:34.853Z
  </definition>
  <definition term="process.thread.id">
    Thread ID.
    type: long
    example: 4242
    format: string
  </definition>
  <definition term="process.thread.name">
    Thread name.
    type: keyword
    example: thread-0
  </definition>
  <definition term="process.title">
    Process title. The proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened.
    type: keyword
  </definition>
  <definition term="process.title.text">
    type: match_only_text
  </definition>
  <definition term="process.uptime">
    Seconds the process has been up.
    type: long
    example: 1325
  </definition>
  <definition term="process.working_directory">
    The working directory of the process.
    type: keyword
    example: /home/alice
  </definition>
  <definition term="process.working_directory.text">
    type: match_only_text
  </definition>
</definitions>


## registry

Fields related to Windows Registry operations.
<definitions>
  <definition term="registry.data.bytes">
    Original bytes written with base64 encoding. For Windows registry operations, such as SetValueEx and RegQueryValueEx, this corresponds to the data pointed by `lp_data`. This is optional but provides better recoverability and should be populated for REG_BINARY encoded values.
    type: keyword
    example: ZQBuAC0AVQBTAAAAZQBuAAAAAAA=
  </definition>
  <definition term="registry.data.strings">
    Content when writing string types. Populated as an array when writing string data to the registry. For single string registry types (REG_SZ, REG_EXPAND_SZ), this should be an array with one string. For sequences of string with REG_MULTI_SZ, this array will be variable length. For numeric data, such as REG_DWORD and REG_QWORD, this should be populated with the decimal representation (e.g `"1"`).
    type: wildcard
    example: ["C:\rta\red_ttp\bin\myapp.exe"]
  </definition>
  <definition term="registry.data.type">
    Standard registry type for encoding contents
    type: keyword
    example: REG_SZ
  </definition>
  <definition term="registry.hive">
    Abbreviated name for the hive.
    type: keyword
    example: HKLM
  </definition>
  <definition term="registry.key">
    Hive-relative path of keys.
    type: keyword
    example: SOFTWARE\Microsoft\Windows NT\CurrentVersion\Image File Execution Options\winword.exe
  </definition>
  <definition term="registry.path">
    Full path, including hive, key and value
    type: keyword
    example: HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Image File Execution Options\winword.exe\Debugger
  </definition>
  <definition term="registry.value">
    Name of the value written.
    type: keyword
    example: Debugger
  </definition>
</definitions>


## related

This field set is meant to facilitate pivoting around a piece of data.
Some pieces of information can be seen in many places in an ECS event. To facilitate searching for them, store an array of all seen values to their corresponding field in `related.`.
A concrete example is IP addresses, which can be under host, observer, source, destination, client, server, and network.forwarded_ip. If you append all IPs to `related.ip`, you can then search for a given IP trivially, no matter where it appeared, by querying `related.ip:192.0.2.15`.
<definitions>
  <definition term="related.hash">
    All the hashes seen on your event. Populating this field, then using it to search for hashes can help in situations where you're unsure what the hash algorithm is (and therefore which key name to search).
    type: keyword
  </definition>
  <definition term="related.hosts">
    All hostnames or other host identifiers seen on your event. Example identifiers include FQDNs, domain names, workstation names, or aliases.
    type: keyword
  </definition>
  <definition term="related.ip">
    All of the IPs seen on your event.
    type: ip
  </definition>
  <definition term="related.user">
    All the user names or other user identifiers seen on the event.
    type: keyword
  </definition>
</definitions>


## rule

Rule fields are used to capture the specifics of any observer or agent rules that generate alerts or other notable events.
Examples of data sources that would populate the rule fields include: network admission control platforms, network or host IDS/IPS, network firewalls, web application firewalls, url filters, endpoint detection and response (EDR) systems, etc.
<definitions>
  <definition term="rule.author">
    Name, organization, or pseudonym of the author or authors who created the rule used to generate this event.
    type: keyword
    example: ["Star-Lord"]
  </definition>
  <definition term="rule.category">
    A categorization value keyword used by the entity using the rule for detection of this event.
    type: keyword
    example: Attempted Information Leak
  </definition>
  <definition term="rule.description">
    The description of the rule generating the event.
    type: keyword
    example: Block requests to public DNS over HTTPS / TLS protocols
  </definition>
  <definition term="rule.id">
    A rule ID that is unique within the scope of an agent, observer, or other entity using the rule for detection of this event.
    type: keyword
    example: 101
  </definition>
  <definition term="rule.license">
    Name of the license under which the rule used to generate this event is made available.
    type: keyword
    example: Apache 2.0
  </definition>
  <definition term="rule.name">
    The name of the rule or signature generating the event.
    type: keyword
    example: BLOCK_DNS_over_TLS
  </definition>
  <definition term="rule.reference">
    Reference URL to additional information about the rule used to generate this event. The URL can point to the vendor's documentation about the rule. If that's not available, it can also be a link to a more general page describing this type of alert.
    type: keyword
    example: [https://en.wikipedia.org/wiki/DNS_over_TLS](https://en.wikipedia.org/wiki/DNS_over_TLS)
  </definition>
  <definition term="rule.ruleset">
    Name of the ruleset, policy, group, or parent category in which the rule used to generate this event is a member.
    type: keyword
    example: Standard_Protocol_Filters
  </definition>
  <definition term="rule.uuid">
    A rule ID that is unique within the scope of a set or group of agents, observers, or other entities using the rule for detection of this event.
    type: keyword
    example: 1100110011
  </definition>
  <definition term="rule.version">
    The version / revision of the rule being used for analysis.
    type: keyword
    example: 1.1
  </definition>
</definitions>


## server

A Server is defined as the responder in a network connection for events regarding sessions, connections, or bidirectional flow records.
For TCP events, the server is the receiver of the initial SYN packet(s) of the TCP connection. For other protocols, the server is generally the responder in the network transaction. Some systems actually use the term "responder" to refer the server in TCP connections. The server fields describe details about the system acting as the server in the network event. Server fields are usually populated in conjunction with client fields. Server fields are generally not populated for packet-level events.
Client / server representations can add semantic context to an exchange, which is helpful to visualize the data in certain situations. If your context falls in that category, you should still ensure that source and destination are filled appropriately.
<definitions>
  <definition term="server.address">
    Some event server addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.
    type: keyword
  </definition>
  <definition term="server.as.number">
    Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.
    type: long
    example: 15169
  </definition>
  <definition term="server.as.organization.name">
    Organization name.
    type: keyword
    example: Google LLC
  </definition>
  <definition term="server.as.organization.name.text">
    type: match_only_text
  </definition>
  <definition term="server.bytes">
    Bytes sent from the server to the client.
    type: long
    example: 184
    format: bytes
  </definition>
  <definition term="server.domain">
    The domain name of the server system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.
    type: keyword
    example: foo.example.com
  </definition>
  <definition term="server.geo.city_name">
    City name.
    type: keyword
    example: Montreal
  </definition>
  <definition term="server.geo.continent_code">
    Two-letter code representing continent's name.
    type: keyword
    example: NA
  </definition>
  <definition term="server.geo.continent_name">
    Name of the continent.
    type: keyword
    example: North America
  </definition>
  <definition term="server.geo.country_iso_code">
    Country ISO code.
    type: keyword
    example: CA
  </definition>
  <definition term="server.geo.country_name">
    Country name.
    type: keyword
    example: Canada
  </definition>
  <definition term="server.geo.location">
    Longitude and latitude.
    type: geo_point
    example: { "lon": -73.614830, "lat": 45.505918 }
  </definition>
  <definition term="server.geo.name">
    User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.
    type: keyword
    example: boston-dc
  </definition>
  <definition term="server.geo.postal_code">
    Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.
    type: keyword
    example: 94040
  </definition>
  <definition term="server.geo.region_iso_code">
    Region ISO code.
    type: keyword
    example: CA-QC
  </definition>
  <definition term="server.geo.region_name">
    Region name.
    type: keyword
    example: Quebec
  </definition>
  <definition term="server.geo.timezone">
    The time zone of the location, such as IANA time zone name.
    type: keyword
    example: America/Argentina/Buenos_Aires
  </definition>
  <definition term="server.ip">
    IP address of the server (IPv4 or IPv6).
    type: ip
  </definition>
  <definition term="server.mac">
    MAC address of the server. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.
    type: keyword
    example: 00-00-5E-00-53-23
  </definition>
  <definition term="server.nat.ip">
    Translated ip of destination based NAT sessions (e.g. internet to private DMZ) Typically used with load balancers, firewalls, or routers.
    type: ip
  </definition>
  <definition term="server.nat.port">
    Translated port of destination based NAT sessions (e.g. internet to private DMZ) Typically used with load balancers, firewalls, or routers.
    type: long
    format: string
  </definition>
  <definition term="server.packets">
    Packets sent from the server to the client.
    type: long
    example: 12
  </definition>
  <definition term="server.port">
    Port of the server.
    type: long
    format: string
  </definition>
  <definition term="server.registered_domain">
    The highest registered server domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".
    type: keyword
    example: example.com
  </definition>
  <definition term="server.subdomain">
    The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain. For example the subdomain portion of "www.east.example.com" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.
    type: keyword
    example: east
  </definition>
  <definition term="server.top_level_domain">
    The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".
    type: keyword
    example: co.uk
  </definition>
  <definition term="server.user.domain">
    Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="server.user.email">
    User email address.
    type: keyword
  </definition>
  <definition term="server.user.full_name">
    User's full name, if available.
    type: keyword
    example: Albert Einstein
  </definition>
  <definition term="server.user.full_name.text">
    type: match_only_text
  </definition>
  <definition term="server.user.group.domain">
    Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="server.user.group.id">
    Unique identifier for the group on the system/platform.
    type: keyword
  </definition>
  <definition term="server.user.group.name">
    Name of the group.
    type: keyword
  </definition>
  <definition term="server.user.hash">
    Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used.
    type: keyword
  </definition>
  <definition term="server.user.id">
    Unique identifier of the user.
    type: keyword
    example: S-1-5-21-202424912787-2692429404-2351956786-1000
  </definition>
  <definition term="server.user.name">
    Short name or login of the user.
    type: keyword
    example: a.einstein
  </definition>
  <definition term="server.user.name.text">
    type: match_only_text
  </definition>
  <definition term="server.user.roles">
    Array of user roles at the time of the event.
    type: keyword
    example: ["kibana_admin", "reporting_user"]
  </definition>
</definitions>


## service

The service fields describe the service for or from which the data was collected.
These fields help you find and correlate logs for a specific service and version.
<definitions>
  <definition term="service.address">
    Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).
    type: keyword
    example: 172.26.0.2:5432
  </definition>
  <definition term="service.environment">
    Identifies the environment where the service is running. If the same service runs in different environments (production, staging, QA, development, etc.), the environment can identify other instances of the same service. Can also group services and applications from the same environment.
    type: keyword
    example: production
  </definition>
  <definition term="service.ephemeral_id">
    Ephemeral identifier of this service (if one exists). This id normally changes across restarts, but `service.id` does not.
    type: keyword
    example: 8a4f500f
  </definition>
  <definition term="service.id">
    Unique identifier of the running service. If the service is comprised of many nodes, the `service.id` should be the same for all nodes. This id should uniquely identify the service. This makes it possible to correlate logs and metrics for one specific service, no matter which particular node emitted the event. Note that if you need to see the events from one specific host of the service, you should filter on that `host.name` or `host.id` instead.
    type: keyword
    example: d37e5ebfe0ae6c4972dbe9f0174a1637bb8247f6
  </definition>
  <definition term="service.name">
    Name of the service data is collected from. The name of the service is normally user given. This allows for distributed services that run on multiple hosts to correlate the related instances based on the name. In the case of Elasticsearch the `service.name` could contain the cluster name. For Beats the `service.name` is by default a copy of the `service.type` field if no name is specified.
    type: keyword
    example: elasticsearch-metrics
  </definition>
  <definition term="service.node.name">
    Name of a service node. This allows for two nodes of the same service running on the same host to be differentiated. Therefore, `service.node.name` should typically be unique across nodes of a given service. In the case of Elasticsearch, the `service.node.name` could contain the unique node name within the Elasticsearch cluster. In cases where the service doesn't have the concept of a node name, the host name or container name can be used to distinguish running instances that make up this service. If those do not provide uniqueness (e.g. multiple instances of the service running on the same host) - the node name can be manually set.
    type: keyword
    example: instance-0000000016
  </definition>
  <definition term="service.origin.address">
    Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).
    type: keyword
    example: 172.26.0.2:5432
  </definition>
  <definition term="service.origin.environment">
    Identifies the environment where the service is running. If the same service runs in different environments (production, staging, QA, development, etc.), the environment can identify other instances of the same service. Can also group services and applications from the same environment.
    type: keyword
    example: production
  </definition>
  <definition term="service.origin.ephemeral_id">
    Ephemeral identifier of this service (if one exists). This id normally changes across restarts, but `service.id` does not.
    type: keyword
    example: 8a4f500f
  </definition>
  <definition term="service.origin.id">
    Unique identifier of the running service. If the service is comprised of many nodes, the `service.id` should be the same for all nodes. This id should uniquely identify the service. This makes it possible to correlate logs and metrics for one specific service, no matter which particular node emitted the event. Note that if you need to see the events from one specific host of the service, you should filter on that `host.name` or `host.id` instead.
    type: keyword
    example: d37e5ebfe0ae6c4972dbe9f0174a1637bb8247f6
  </definition>
  <definition term="service.origin.name">
    Name of the service data is collected from. The name of the service is normally user given. This allows for distributed services that run on multiple hosts to correlate the related instances based on the name. In the case of Elasticsearch the `service.name` could contain the cluster name. For Beats the `service.name` is by default a copy of the `service.type` field if no name is specified.
    type: keyword
    example: elasticsearch-metrics
  </definition>
  <definition term="service.origin.node.name">
    Name of a service node. This allows for two nodes of the same service running on the same host to be differentiated. Therefore, `service.node.name` should typically be unique across nodes of a given service. In the case of Elasticsearch, the `service.node.name` could contain the unique node name within the Elasticsearch cluster. In cases where the service doesn't have the concept of a node name, the host name or container name can be used to distinguish running instances that make up this service. If those do not provide uniqueness (e.g. multiple instances of the service running on the same host) - the node name can be manually set.
    type: keyword
    example: instance-0000000016
  </definition>
  <definition term="service.origin.state">
    Current state of the service.
    type: keyword
  </definition>
  <definition term="service.origin.type">
    The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.
    type: keyword
    example: elasticsearch
  </definition>
  <definition term="service.origin.version">
    Version of the service the data was collected from. This allows to look at a data set only for a specific version of a service.
    type: keyword
    example: 3.2.4
  </definition>
  <definition term="service.state">
    Current state of the service.
    type: keyword
  </definition>
  <definition term="service.target.address">
    Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).
    type: keyword
    example: 172.26.0.2:5432
  </definition>
  <definition term="service.target.environment">
    Identifies the environment where the service is running. If the same service runs in different environments (production, staging, QA, development, etc.), the environment can identify other instances of the same service. Can also group services and applications from the same environment.
    type: keyword
    example: production
  </definition>
  <definition term="service.target.ephemeral_id">
    Ephemeral identifier of this service (if one exists). This id normally changes across restarts, but `service.id` does not.
    type: keyword
    example: 8a4f500f
  </definition>
  <definition term="service.target.id">
    Unique identifier of the running service. If the service is comprised of many nodes, the `service.id` should be the same for all nodes. This id should uniquely identify the service. This makes it possible to correlate logs and metrics for one specific service, no matter which particular node emitted the event. Note that if you need to see the events from one specific host of the service, you should filter on that `host.name` or `host.id` instead.
    type: keyword
    example: d37e5ebfe0ae6c4972dbe9f0174a1637bb8247f6
  </definition>
  <definition term="service.target.name">
    Name of the service data is collected from. The name of the service is normally user given. This allows for distributed services that run on multiple hosts to correlate the related instances based on the name. In the case of Elasticsearch the `service.name` could contain the cluster name. For Beats the `service.name` is by default a copy of the `service.type` field if no name is specified.
    type: keyword
    example: elasticsearch-metrics
  </definition>
  <definition term="service.target.node.name">
    Name of a service node. This allows for two nodes of the same service running on the same host to be differentiated. Therefore, `service.node.name` should typically be unique across nodes of a given service. In the case of Elasticsearch, the `service.node.name` could contain the unique node name within the Elasticsearch cluster. In cases where the service doesn't have the concept of a node name, the host name or container name can be used to distinguish running instances that make up this service. If those do not provide uniqueness (e.g. multiple instances of the service running on the same host) - the node name can be manually set.
    type: keyword
    example: instance-0000000016
  </definition>
  <definition term="service.target.state">
    Current state of the service.
    type: keyword
  </definition>
  <definition term="service.target.type">
    The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.
    type: keyword
    example: elasticsearch
  </definition>
  <definition term="service.target.version">
    Version of the service the data was collected from. This allows to look at a data set only for a specific version of a service.
    type: keyword
    example: 3.2.4
  </definition>
  <definition term="service.type">
    The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.
    type: keyword
    example: elasticsearch
  </definition>
  <definition term="service.version">
    Version of the service the data was collected from. This allows to look at a data set only for a specific version of a service.
    type: keyword
    example: 3.2.4
  </definition>
</definitions>


## source

Source fields capture details about the sender of a network exchange/packet. These fields are populated from a network event, packet, or other event containing details of a network transaction.
Source fields are usually populated in conjunction with destination fields. The source and destination fields are considered the baseline and should always be filled if an event contains source and destination details from a network transaction. If the event also contains identification of the client and server roles, then the client and server fields should also be populated.
<definitions>
  <definition term="source.address">
    Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.
    type: keyword
  </definition>
  <definition term="source.as.number">
    Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.
    type: long
    example: 15169
  </definition>
  <definition term="source.as.organization.name">
    Organization name.
    type: keyword
    example: Google LLC
  </definition>
  <definition term="source.as.organization.name.text">
    type: match_only_text
  </definition>
  <definition term="source.bytes">
    Bytes sent from the source to the destination.
    type: long
    example: 184
    format: bytes
  </definition>
  <definition term="source.domain">
    The domain name of the source system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.
    type: keyword
    example: foo.example.com
  </definition>
  <definition term="source.geo.city_name">
    City name.
    type: keyword
    example: Montreal
  </definition>
  <definition term="source.geo.continent_code">
    Two-letter code representing continent's name.
    type: keyword
    example: NA
  </definition>
  <definition term="source.geo.continent_name">
    Name of the continent.
    type: keyword
    example: North America
  </definition>
  <definition term="source.geo.country_iso_code">
    Country ISO code.
    type: keyword
    example: CA
  </definition>
  <definition term="source.geo.country_name">
    Country name.
    type: keyword
    example: Canada
  </definition>
  <definition term="source.geo.location">
    Longitude and latitude.
    type: geo_point
    example: { "lon": -73.614830, "lat": 45.505918 }
  </definition>
  <definition term="source.geo.name">
    User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.
    type: keyword
    example: boston-dc
  </definition>
  <definition term="source.geo.postal_code">
    Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.
    type: keyword
    example: 94040
  </definition>
  <definition term="source.geo.region_iso_code">
    Region ISO code.
    type: keyword
    example: CA-QC
  </definition>
  <definition term="source.geo.region_name">
    Region name.
    type: keyword
    example: Quebec
  </definition>
  <definition term="source.geo.timezone">
    The time zone of the location, such as IANA time zone name.
    type: keyword
    example: America/Argentina/Buenos_Aires
  </definition>
  <definition term="source.ip">
    IP address of the source (IPv4 or IPv6).
    type: ip
  </definition>
  <definition term="source.mac">
    MAC address of the source. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.
    type: keyword
    example: 00-00-5E-00-53-23
  </definition>
  <definition term="source.nat.ip">
    Translated ip of source based NAT sessions (e.g. internal client to internet) Typically connections traversing load balancers, firewalls, or routers.
    type: ip
  </definition>
  <definition term="source.nat.port">
    Translated port of source based NAT sessions. (e.g. internal client to internet) Typically used with load balancers, firewalls, or routers.
    type: long
    format: string
  </definition>
  <definition term="source.packets">
    Packets sent from the source to the destination.
    type: long
    example: 12
  </definition>
  <definition term="source.port">
    Port of the source.
    type: long
    format: string
  </definition>
  <definition term="source.registered_domain">
    The highest registered source domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".
    type: keyword
    example: example.com
  </definition>
  <definition term="source.subdomain">
    The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain. For example the subdomain portion of "www.east.example.com" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.
    type: keyword
    example: east
  </definition>
  <definition term="source.top_level_domain">
    The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".
    type: keyword
    example: co.uk
  </definition>
  <definition term="source.user.domain">
    Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="source.user.email">
    User email address.
    type: keyword
  </definition>
  <definition term="source.user.full_name">
    User's full name, if available.
    type: keyword
    example: Albert Einstein
  </definition>
  <definition term="source.user.full_name.text">
    type: match_only_text
  </definition>
  <definition term="source.user.group.domain">
    Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="source.user.group.id">
    Unique identifier for the group on the system/platform.
    type: keyword
  </definition>
  <definition term="source.user.group.name">
    Name of the group.
    type: keyword
  </definition>
  <definition term="source.user.hash">
    Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used.
    type: keyword
  </definition>
  <definition term="source.user.id">
    Unique identifier of the user.
    type: keyword
    example: S-1-5-21-202424912787-2692429404-2351956786-1000
  </definition>
  <definition term="source.user.name">
    Short name or login of the user.
    type: keyword
    example: a.einstein
  </definition>
  <definition term="source.user.name.text">
    type: match_only_text
  </definition>
  <definition term="source.user.roles">
    Array of user roles at the time of the event.
    type: keyword
    example: ["kibana_admin", "reporting_user"]
  </definition>
</definitions>


## threat

Fields to classify events and alerts according to a threat taxonomy such as the MITRE ATT&CK® framework.
These fields are for users to classify alerts from all of their sources (e.g. IDS, NGFW, etc.) within a common taxonomy. The threat.tactic.* fields are meant to capture the high level category of the threat (e.g. "impact"). The threat.technique.* fields are meant to capture which kind of approach is used by this detected threat, to accomplish the goal (e.g. "endpoint denial of service").
<definitions>
  <definition term="threat.enrichments">
    A list of associated indicators objects enriching the event, and the context of that association/enrichment.
    type: nested
  </definition>
  <definition term="threat.enrichments.indicator">
    Object containing associated indicators enriching the event.
    type: object
  </definition>
  <definition term="threat.enrichments.indicator.as.number">
    Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.
    type: long
    example: 15169
  </definition>
  <definition term="threat.enrichments.indicator.as.organization.name">
    Organization name.
    type: keyword
    example: Google LLC
  </definition>
  <definition term="threat.enrichments.indicator.as.organization.name.text">
    type: match_only_text
  </definition>
  <definition term="threat.enrichments.indicator.confidence">
    Identifies the vendor-neutral confidence rating using the None/Low/Medium/High scale defined in Appendix A of the STIX 2.1 framework. Vendor-specific confidence scales may be added as custom fields. Expected values are:   * Not Specified   * None   * Low   * Medium   * High
    type: keyword
    example: Medium
  </definition>
  <definition term="threat.enrichments.indicator.description">
    Describes the type of action conducted by the threat.
    type: keyword
    example: IP x.x.x.x was observed delivering the Angler EK.
  </definition>
  <definition term="threat.enrichments.indicator.email.address">
    Identifies a threat indicator as an email address (irrespective of direction).
    type: keyword
    example: phish@example.com
  </definition>
  <definition term="threat.enrichments.indicator.file.accessed">
    Last time the file was accessed. Note that not all filesystems keep track of access time.
    type: date
  </definition>
  <definition term="threat.enrichments.indicator.file.attributes">
    Array of file attributes. Attributes names will vary by platform. Here's a non-exhaustive list of values that are expected in this field: archive, compressed, directory, encrypted, execute, hidden, read, readonly, system, write.
    type: keyword
    example: ["readonly", "system"]
  </definition>
  <definition term="threat.enrichments.indicator.file.code_signature.digest_algorithm">
    The hashing algorithm used to sign the process. This value can distinguish signatures when a file is signed multiple times by the same signer but with a different digest algorithm.
    type: keyword
    example: sha256
  </definition>
  <definition term="threat.enrichments.indicator.file.code_signature.exists">
    Boolean to capture if a signature is present.
    type: boolean
    example: true
  </definition>
  <definition term="threat.enrichments.indicator.file.code_signature.signing_id">
    The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only.
    type: keyword
    example: com.apple.xpc.proxy
  </definition>
  <definition term="threat.enrichments.indicator.file.code_signature.status">
    Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.
    type: keyword
    example: ERROR_UNTRUSTED_ROOT
  </definition>
  <definition term="threat.enrichments.indicator.file.code_signature.subject_name">
    Subject name of the code signer
    type: keyword
    example: Microsoft Corporation
  </definition>
  <definition term="threat.enrichments.indicator.file.code_signature.team_id">
    The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only.
    type: keyword
    example: EQHXZ8M8AV
  </definition>
  <definition term="threat.enrichments.indicator.file.code_signature.timestamp">
    Date and time when the code signature was generated and signed.
    type: date
    example: 2021-01-01T12:10:30Z
  </definition>
  <definition term="threat.enrichments.indicator.file.code_signature.trusted">
    Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.
    type: boolean
    example: true
  </definition>
  <definition term="threat.enrichments.indicator.file.code_signature.valid">
    Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked.
    type: boolean
    example: true
  </definition>
  <definition term="threat.enrichments.indicator.file.created">
    File creation time. Note that not all filesystems store the creation time.
    type: date
  </definition>
  <definition term="threat.enrichments.indicator.file.ctime">
    Last time the file attributes or metadata changed. Note that changes to the file content will update `mtime`. This implies `ctime` will be adjusted at the same time, since `mtime` is an attribute of the file.
    type: date
  </definition>
  <definition term="threat.enrichments.indicator.file.device">
    Device that is the source of the file.
    type: keyword
    example: sda
  </definition>
  <definition term="threat.enrichments.indicator.file.directory">
    Directory where the file is located. It should include the drive letter, when appropriate.
    type: keyword
    example: /home/alice
  </definition>
  <definition term="threat.enrichments.indicator.file.drive_letter">
    Drive letter where the file is located. This field is only relevant on Windows. The value should be uppercase, and not include the colon.
    type: keyword
    example: C
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.architecture">
    Machine architecture of the ELF file.
    type: keyword
    example: x86-64
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.byte_order">
    Byte sequence of ELF file.
    type: keyword
    example: Little Endian
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.cpu_type">
    CPU type of the ELF file.
    type: keyword
    example: Intel
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.creation_date">
    Extracted when possible from the file's metadata. Indicates when it was built or compiled. It can also be faked by malware creators.
    type: date
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.exports">
    List of exported element names and types.
    type: flattened
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.header.abi_version">
    Version of the ELF Application Binary Interface (ABI).
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.header.class">
    Header class of the ELF file.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.header.data">
    Data table of the ELF header.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.header.entrypoint">
    Header entrypoint of the ELF file.
    type: long
    format: string
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.header.object_version">
    "0x1" for original ELF files.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.header.os_abi">
    Application Binary Interface (ABI) of the Linux OS.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.header.type">
    Header type of the ELF file.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.header.version">
    Version of the ELF header.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.imports">
    List of imported element names and types.
    type: flattened
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.sections">
    An array containing an object for each section of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.sections.*`.
    type: nested
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.sections.chi2">
    Chi-square probability distribution of the section.
    type: long
    format: number
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.sections.entropy">
    Shannon entropy calculation from the section.
    type: long
    format: number
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.sections.flags">
    ELF Section List flags.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.sections.name">
    ELF Section List name.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.sections.physical_offset">
    ELF Section List offset.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.sections.physical_size">
    ELF Section List physical size.
    type: long
    format: bytes
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.sections.type">
    ELF Section List type.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.sections.virtual_address">
    ELF Section List virtual address.
    type: long
    format: string
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.sections.virtual_size">
    ELF Section List virtual size.
    type: long
    format: string
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.segments">
    An array containing an object for each segment of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.segments.*`.
    type: nested
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.segments.sections">
    ELF object segment sections.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.segments.type">
    ELF object segment type.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.shared_libraries">
    List of shared libraries used by this ELF object.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.elf.telfhash">
    telfhash symbol hash for ELF file.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.extension">
    File extension, excluding the leading dot. Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").
    type: keyword
    example: png
  </definition>
  <definition term="threat.enrichments.indicator.file.fork_name">
    A fork is additional data associated with a filesystem object. On Linux, a resource fork is used to store additional data with a filesystem object. A file always has at least one fork for the data portion, and additional forks may exist. On NTFS, this is analogous to an Alternate Data Stream (ADS), and the default data stream for a file is just called $DATA. Zone.Identifier is commonly used by Windows to track contents downloaded from the Internet. An ADS is typically of the form: `C:\path\to\filename.extension:some_fork_name`, and `some_fork_name` is the value that should populate `fork_name`. `filename.extension` should populate `file.name`, and `extension` should populate `file.extension`. The full path, `file.path`, will include the fork name.
    type: keyword
    example: Zone.Identifer
  </definition>
  <definition term="threat.enrichments.indicator.file.gid">
    Primary group ID (GID) of the file.
    type: keyword
    example: 1001
  </definition>
  <definition term="threat.enrichments.indicator.file.group">
    Primary group name of the file.
    type: keyword
    example: alice
  </definition>
  <definition term="threat.enrichments.indicator.file.hash.md5">
    MD5 hash.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.hash.sha1">
    SHA1 hash.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.hash.sha256">
    SHA256 hash.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.hash.sha512">
    SHA512 hash.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.hash.ssdeep">
    SSDEEP hash.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.inode">
    Inode representing the file in the filesystem.
    type: keyword
    example: 256383
  </definition>
  <definition term="threat.enrichments.indicator.file.mime_type">
    MIME type should identify the format of the file or stream of bytes using https://www.iana.org/assignments/media-types/media-types.xhtml[IANA official types], where possible. When more than one type is applicable, the most specific type should be used.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.mode">
    Mode of the file in octal representation.
    type: keyword
    example: 0640
  </definition>
  <definition term="threat.enrichments.indicator.file.mtime">
    Last time the file content was modified.
    type: date
  </definition>
  <definition term="threat.enrichments.indicator.file.name">
    Name of the file including the extension, without the directory.
    type: keyword
    example: example.png
  </definition>
  <definition term="threat.enrichments.indicator.file.owner">
    File owner's username.
    type: keyword
    example: alice
  </definition>
  <definition term="threat.enrichments.indicator.file.path">
    Full path to the file, including the file name. It should include the drive letter, when appropriate.
    type: keyword
    example: /home/alice/example.png
  </definition>
  <definition term="threat.enrichments.indicator.file.path.text">
    type: match_only_text
  </definition>
  <definition term="threat.enrichments.indicator.file.pe.architecture">
    CPU architecture target for the file.
    type: keyword
    example: x64
  </definition>
  <definition term="threat.enrichments.indicator.file.pe.company">
    Internal company name of the file, provided at compile-time.
    type: keyword
    example: Microsoft Corporation
  </definition>
  <definition term="threat.enrichments.indicator.file.pe.description">
    Internal description of the file, provided at compile-time.
    type: keyword
    example: Paint
  </definition>
  <definition term="threat.enrichments.indicator.file.pe.file_version">
    Internal version of the file, provided at compile-time.
    type: keyword
    example: 6.3.9600.17415
  </definition>
  <definition term="threat.enrichments.indicator.file.pe.imphash">
    A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at [https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html](https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html).
    type: keyword
    example: 0c6803c4e922103c4dca5963aad36ddf
  </definition>
  <definition term="threat.enrichments.indicator.file.pe.original_file_name">
    Internal name of the file, provided at compile-time.
    type: keyword
    example: MSPAINT.EXE
  </definition>
  <definition term="threat.enrichments.indicator.file.pe.product">
    Internal product name of the file, provided at compile-time.
    type: keyword
    example: Microsoft® Windows® Operating System
  </definition>
  <definition term="threat.enrichments.indicator.file.size">
    File size in bytes. Only relevant when `file.type` is "file".
    type: long
    example: 16384
  </definition>
  <definition term="threat.enrichments.indicator.file.target_path">
    Target path for symlinks.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.target_path.text">
    type: match_only_text
  </definition>
  <definition term="threat.enrichments.indicator.file.type">
    File type (file, dir, or symlink).
    type: keyword
    example: file
  </definition>
  <definition term="threat.enrichments.indicator.file.uid">
    The user ID (UID) or security identifier (SID) of the file owner.
    type: keyword
    example: 1001
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.alternative_names">
    List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.
    type: keyword
    example: *.elastic.co
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.issuer.common_name">
    List of common name (CN) of issuing certificate authority.
    type: keyword
    example: Example SHA2 High Assurance Server CA
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.issuer.country">
    List of country (C) codes
    type: keyword
    example: US
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.issuer.distinguished_name">
    Distinguished name (DN) of issuing certificate authority.
    type: keyword
    example: C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.issuer.locality">
    List of locality names (L)
    type: keyword
    example: Mountain View
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.issuer.organization">
    List of organizations (O) of issuing certificate authority.
    type: keyword
    example: Example Inc
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.issuer.organizational_unit">
    List of organizational units (OU) of issuing certificate authority.
    type: keyword
    example: www.example.com
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.issuer.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.not_after">
    Time at which the certificate is no longer considered valid.
    type: date
    example: 2020-07-16 03:15:39+00:00
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.not_before">
    Time at which the certificate is first considered valid.
    type: date
    example: 2019-08-16 01:40:25+00:00
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.public_key_algorithm">
    Algorithm used to generate the public key.
    type: keyword
    example: RSA
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.public_key_curve">
    The curve used by the elliptic curve public key algorithm. This is algorithm specific.
    type: keyword
    example: nistp521
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.public_key_exponent">
    Exponent used to derive the public key. This is algorithm specific.
    type: long
    example: 65537
  </definition>
</definitions>

Field is not indexed.
<definitions>
  <definition term="threat.enrichments.indicator.file.x509.public_key_size">
    The size of the public key space in bits.
    type: long
    example: 2048
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.serial_number">
    Unique serial number issued by the certificate authority. For consistency, if this value is alphanumeric, it should be formatted without colons and uppercase characters.
    type: keyword
    example: 55FBB9C7DEBF09809D12CCAA
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.signature_algorithm">
    Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See [https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353](https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353).
    type: keyword
    example: SHA256-RSA
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.subject.common_name">
    List of common names (CN) of subject.
    type: keyword
    example: shared.global.example.net
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.subject.country">
    List of country (C) code
    type: keyword
    example: US
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.subject.distinguished_name">
    Distinguished name (DN) of the certificate subject entity.
    type: keyword
    example: C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.subject.locality">
    List of locality names (L)
    type: keyword
    example: San Francisco
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.subject.organization">
    List of organizations (O) of subject.
    type: keyword
    example: Example, Inc.
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.subject.organizational_unit">
    List of organizational units (OU) of subject.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.subject.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="threat.enrichments.indicator.file.x509.version_number">
    Version of x509 format.
    type: keyword
    example: 3
  </definition>
  <definition term="threat.enrichments.indicator.first_seen">
    The date and time when intelligence source first reported sighting this indicator.
    type: date
    example: 2020-11-05T17:25:47.000Z
  </definition>
  <definition term="threat.enrichments.indicator.geo.city_name">
    City name.
    type: keyword
    example: Montreal
  </definition>
  <definition term="threat.enrichments.indicator.geo.continent_code">
    Two-letter code representing continent's name.
    type: keyword
    example: NA
  </definition>
  <definition term="threat.enrichments.indicator.geo.continent_name">
    Name of the continent.
    type: keyword
    example: North America
  </definition>
  <definition term="threat.enrichments.indicator.geo.country_iso_code">
    Country ISO code.
    type: keyword
    example: CA
  </definition>
  <definition term="threat.enrichments.indicator.geo.country_name">
    Country name.
    type: keyword
    example: Canada
  </definition>
  <definition term="threat.enrichments.indicator.geo.location">
    Longitude and latitude.
    type: geo_point
    example: { "lon": -73.614830, "lat": 45.505918 }
  </definition>
  <definition term="threat.enrichments.indicator.geo.name">
    User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.
    type: keyword
    example: boston-dc
  </definition>
  <definition term="threat.enrichments.indicator.geo.postal_code">
    Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.
    type: keyword
    example: 94040
  </definition>
  <definition term="threat.enrichments.indicator.geo.region_iso_code">
    Region ISO code.
    type: keyword
    example: CA-QC
  </definition>
  <definition term="threat.enrichments.indicator.geo.region_name">
    Region name.
    type: keyword
    example: Quebec
  </definition>
  <definition term="threat.enrichments.indicator.geo.timezone">
    The time zone of the location, such as IANA time zone name.
    type: keyword
    example: America/Argentina/Buenos_Aires
  </definition>
  <definition term="threat.enrichments.indicator.ip">
    Identifies a threat indicator as an IP address (irrespective of direction).
    type: ip
    example: 1.2.3.4
  </definition>
  <definition term="threat.enrichments.indicator.last_seen">
    The date and time when intelligence source last reported sighting this indicator.
    type: date
    example: 2020-11-05T17:25:47.000Z
  </definition>
  <definition term="threat.enrichments.indicator.marking.tlp">
    Traffic Light Protocol sharing markings. Recommended values are:   * WHITE   * GREEN   * AMBER   * RED
    type: keyword
    example: White
  </definition>
  <definition term="threat.enrichments.indicator.modified_at">
    The date and time when intelligence source last modified information for this indicator.
    type: date
    example: 2020-11-05T17:25:47.000Z
  </definition>
  <definition term="threat.enrichments.indicator.port">
    Identifies a threat indicator as a port number (irrespective of direction).
    type: long
    example: 443
  </definition>
  <definition term="threat.enrichments.indicator.provider">
    The name of the indicator's provider.
    type: keyword
    example: lrz_urlhaus
  </definition>
  <definition term="threat.enrichments.indicator.reference">
    Reference URL linking to additional information about this indicator.
    type: keyword
    example: https://system.example.com/indicator/0001234
  </definition>
  <definition term="threat.enrichments.indicator.registry.data.bytes">
    Original bytes written with base64 encoding. For Windows registry operations, such as SetValueEx and RegQueryValueEx, this corresponds to the data pointed by `lp_data`. This is optional but provides better recoverability and should be populated for REG_BINARY encoded values.
    type: keyword
    example: ZQBuAC0AVQBTAAAAZQBuAAAAAAA=
  </definition>
  <definition term="threat.enrichments.indicator.registry.data.strings">
    Content when writing string types. Populated as an array when writing string data to the registry. For single string registry types (REG_SZ, REG_EXPAND_SZ), this should be an array with one string. For sequences of string with REG_MULTI_SZ, this array will be variable length. For numeric data, such as REG_DWORD and REG_QWORD, this should be populated with the decimal representation (e.g `"1"`).
    type: wildcard
    example: ["C:\rta\red_ttp\bin\myapp.exe"]
  </definition>
  <definition term="threat.enrichments.indicator.registry.data.type">
    Standard registry type for encoding contents
    type: keyword
    example: REG_SZ
  </definition>
  <definition term="threat.enrichments.indicator.registry.hive">
    Abbreviated name for the hive.
    type: keyword
    example: HKLM
  </definition>
  <definition term="threat.enrichments.indicator.registry.key">
    Hive-relative path of keys.
    type: keyword
    example: SOFTWARE\Microsoft\Windows NT\CurrentVersion\Image File Execution Options\winword.exe
  </definition>
  <definition term="threat.enrichments.indicator.registry.path">
    Full path, including hive, key and value
    type: keyword
    example: HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Image File Execution Options\winword.exe\Debugger
  </definition>
  <definition term="threat.enrichments.indicator.registry.value">
    Name of the value written.
    type: keyword
    example: Debugger
  </definition>
  <definition term="threat.enrichments.indicator.scanner_stats">
    Count of AV/EDR vendors that successfully detected malicious file or URL.
    type: long
    example: 4
  </definition>
  <definition term="threat.enrichments.indicator.sightings">
    Number of times this indicator was observed conducting threat activity.
    type: long
    example: 20
  </definition>
  <definition term="threat.enrichments.indicator.type">
    Type of indicator as represented by Cyber Observable in STIX 2.0. Recommended values:   * autonomous-system   * artifact   * directory   * domain-name   * email-addr   * file   * ipv4-addr   * ipv6-addr   * mac-addr   * mutex   * port   * process   * software   * url   * user-account   * windows-registry-key   * x509-certificate
    type: keyword
    example: ipv4-addr
  </definition>
  <definition term="threat.enrichments.indicator.url.domain">
    Domain of the url, such as "www.elastic.co". In some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field. If the URL contains a literal IPv6 address enclosed by `[` and `]` (IETF RFC 2732), the `[` and `]` characters should also be captured in the `domain` field.
    type: keyword
    example: www.elastic.co
  </definition>
  <definition term="threat.enrichments.indicator.url.extension">
    The field contains the file extension from the original request url, excluding the leading dot. The file extension is only set if it exists, as not every url has a file extension. The leading period must not be included. For example, the value must be "png", not ".png". Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").
    type: keyword
    example: png
  </definition>
  <definition term="threat.enrichments.indicator.url.fragment">
    Portion of the url after the `#`, such as "top". The `#` is not part of the fragment.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.url.full">
    If full URLs are important to your use case, they should be stored in `url.full`, whether this field is reconstructed or present in the event source.
    type: wildcard
    example: https://www.elastic.co:443/search?q=elasticsearch#top
  </definition>
  <definition term="threat.enrichments.indicator.url.full.text">
    type: match_only_text
  </definition>
  <definition term="threat.enrichments.indicator.url.original">
    Unmodified original url as seen in the event source. Note that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path. This field is meant to represent the URL as it was observed, complete or not.
    type: wildcard
    example: https://www.elastic.co:443/search?q=elasticsearch#top or /search?q=elasticsearch
  </definition>
  <definition term="threat.enrichments.indicator.url.original.text">
    type: match_only_text
  </definition>
  <definition term="threat.enrichments.indicator.url.password">
    Password of the request.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.url.path">
    Path of the request, such as "/search".
    type: wildcard
  </definition>
  <definition term="threat.enrichments.indicator.url.port">
    Port of the request, such as 443.
    type: long
    example: 443
    format: string
  </definition>
  <definition term="threat.enrichments.indicator.url.query">
    The query field describes the query string of the request, such as "q=elasticsearch". The `?` is excluded from the query string. If a URL contains no `?`, there is no query field. If there is a `?` but no query, the query field exists with an empty string. The `exists` query can be used to differentiate between the two cases.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.url.registered_domain">
    The highest registered url domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".
    type: keyword
    example: example.com
  </definition>
  <definition term="threat.enrichments.indicator.url.scheme">
    Scheme of the request, such as "https". Note: The `:` is not part of the scheme.
    type: keyword
    example: https
  </definition>
  <definition term="threat.enrichments.indicator.url.subdomain">
    The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain. For example the subdomain portion of "www.east.example.com" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.
    type: keyword
    example: east
  </definition>
  <definition term="threat.enrichments.indicator.url.top_level_domain">
    The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".
    type: keyword
    example: co.uk
  </definition>
  <definition term="threat.enrichments.indicator.url.username">
    Username of the request.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.x509.alternative_names">
    List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.
    type: keyword
    example: *.elastic.co
  </definition>
  <definition term="threat.enrichments.indicator.x509.issuer.common_name">
    List of common name (CN) of issuing certificate authority.
    type: keyword
    example: Example SHA2 High Assurance Server CA
  </definition>
  <definition term="threat.enrichments.indicator.x509.issuer.country">
    List of country (C) codes
    type: keyword
    example: US
  </definition>
  <definition term="threat.enrichments.indicator.x509.issuer.distinguished_name">
    Distinguished name (DN) of issuing certificate authority.
    type: keyword
    example: C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA
  </definition>
  <definition term="threat.enrichments.indicator.x509.issuer.locality">
    List of locality names (L)
    type: keyword
    example: Mountain View
  </definition>
  <definition term="threat.enrichments.indicator.x509.issuer.organization">
    List of organizations (O) of issuing certificate authority.
    type: keyword
    example: Example Inc
  </definition>
  <definition term="threat.enrichments.indicator.x509.issuer.organizational_unit">
    List of organizational units (OU) of issuing certificate authority.
    type: keyword
    example: www.example.com
  </definition>
  <definition term="threat.enrichments.indicator.x509.issuer.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="threat.enrichments.indicator.x509.not_after">
    Time at which the certificate is no longer considered valid.
    type: date
    example: 2020-07-16 03:15:39+00:00
  </definition>
  <definition term="threat.enrichments.indicator.x509.not_before">
    Time at which the certificate is first considered valid.
    type: date
    example: 2019-08-16 01:40:25+00:00
  </definition>
  <definition term="threat.enrichments.indicator.x509.public_key_algorithm">
    Algorithm used to generate the public key.
    type: keyword
    example: RSA
  </definition>
  <definition term="threat.enrichments.indicator.x509.public_key_curve">
    The curve used by the elliptic curve public key algorithm. This is algorithm specific.
    type: keyword
    example: nistp521
  </definition>
  <definition term="threat.enrichments.indicator.x509.public_key_exponent">
    Exponent used to derive the public key. This is algorithm specific.
    type: long
    example: 65537
  </definition>
</definitions>

Field is not indexed.
<definitions>
  <definition term="threat.enrichments.indicator.x509.public_key_size">
    The size of the public key space in bits.
    type: long
    example: 2048
  </definition>
  <definition term="threat.enrichments.indicator.x509.serial_number">
    Unique serial number issued by the certificate authority. For consistency, if this value is alphanumeric, it should be formatted without colons and uppercase characters.
    type: keyword
    example: 55FBB9C7DEBF09809D12CCAA
  </definition>
  <definition term="threat.enrichments.indicator.x509.signature_algorithm">
    Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See [https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353](https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353).
    type: keyword
    example: SHA256-RSA
  </definition>
  <definition term="threat.enrichments.indicator.x509.subject.common_name">
    List of common names (CN) of subject.
    type: keyword
    example: shared.global.example.net
  </definition>
  <definition term="threat.enrichments.indicator.x509.subject.country">
    List of country (C) code
    type: keyword
    example: US
  </definition>
  <definition term="threat.enrichments.indicator.x509.subject.distinguished_name">
    Distinguished name (DN) of the certificate subject entity.
    type: keyword
    example: C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net
  </definition>
  <definition term="threat.enrichments.indicator.x509.subject.locality">
    List of locality names (L)
    type: keyword
    example: San Francisco
  </definition>
  <definition term="threat.enrichments.indicator.x509.subject.organization">
    List of organizations (O) of subject.
    type: keyword
    example: Example, Inc.
  </definition>
  <definition term="threat.enrichments.indicator.x509.subject.organizational_unit">
    List of organizational units (OU) of subject.
    type: keyword
  </definition>
  <definition term="threat.enrichments.indicator.x509.subject.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="threat.enrichments.indicator.x509.version_number">
    Version of x509 format.
    type: keyword
    example: 3
  </definition>
  <definition term="threat.enrichments.matched.atomic">
    Identifies the atomic indicator value that matched a local environment endpoint or network event.
    type: keyword
    example: example.com
  </definition>
  <definition term="threat.enrichments.matched.field">
    Identifies the field of the atomic indicator that matched a local environment endpoint or network event.
    type: keyword
    example: file.hash.sha256
  </definition>
  <definition term="threat.enrichments.matched.id">
    Identifies the _id of the indicator document enriching the event.
    type: keyword
    example: ff93aee5-86a1-4a61-b0e6-0cdc313d01b5
  </definition>
  <definition term="threat.enrichments.matched.index">
    Identifies the _index of the indicator document enriching the event.
    type: keyword
    example: filebeat-8.0.0-2021.05.23-000011
  </definition>
  <definition term="threat.enrichments.matched.type">
    Identifies the type of match that caused the event to be enriched with the given indicator
    type: keyword
    example: indicator_match_rule
  </definition>
  <definition term="threat.framework">
    Name of the threat framework used to further categorize and classify the tactic and technique of the reported threat. Framework classification can be provided by detecting systems, evaluated at ingest time, or retrospectively tagged to events.
    type: keyword
    example: MITRE ATT&CK
  </definition>
  <definition term="threat.group.alias">
    The alias(es) of the group for a set of related intrusion activity that are tracked by a common name in the security community. While not required, you can use a MITRE ATT&CK® group alias(es).
    type: keyword
    example: [ "Magecart Group 6" ]
  </definition>
  <definition term="threat.group.id">
    The id of the group for a set of related intrusion activity that are tracked by a common name in the security community. While not required, you can use a MITRE ATT&CK® group id.
    type: keyword
    example: G0037
  </definition>
  <definition term="threat.group.name">
    The name of the group for a set of related intrusion activity that are tracked by a common name in the security community. While not required, you can use a MITRE ATT&CK® group name.
    type: keyword
    example: FIN6
  </definition>
  <definition term="threat.group.reference">
    The reference URL of the group for a set of related intrusion activity that are tracked by a common name in the security community. While not required, you can use a MITRE ATT&CK® group reference URL.
    type: keyword
    example: [https://attack.mitre.org/groups/G0037/](https://attack.mitre.org/groups/G0037/)
  </definition>
  <definition term="threat.indicator.as.number">
    Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.
    type: long
    example: 15169
  </definition>
  <definition term="threat.indicator.as.organization.name">
    Organization name.
    type: keyword
    example: Google LLC
  </definition>
  <definition term="threat.indicator.as.organization.name.text">
    type: match_only_text
  </definition>
  <definition term="threat.indicator.confidence">
    Identifies the vendor-neutral confidence rating using the None/Low/Medium/High scale defined in Appendix A of the STIX 2.1 framework. Vendor-specific confidence scales may be added as custom fields. Expected values are:   * Not Specified   * None   * Low   * Medium   * High
    type: keyword
    example: Medium
  </definition>
  <definition term="threat.indicator.description">
    Describes the type of action conducted by the threat.
    type: keyword
    example: IP x.x.x.x was observed delivering the Angler EK.
  </definition>
  <definition term="threat.indicator.email.address">
    Identifies a threat indicator as an email address (irrespective of direction).
    type: keyword
    example: phish@example.com
  </definition>
  <definition term="threat.indicator.file.accessed">
    Last time the file was accessed. Note that not all filesystems keep track of access time.
    type: date
  </definition>
  <definition term="threat.indicator.file.attributes">
    Array of file attributes. Attributes names will vary by platform. Here's a non-exhaustive list of values that are expected in this field: archive, compressed, directory, encrypted, execute, hidden, read, readonly, system, write.
    type: keyword
    example: ["readonly", "system"]
  </definition>
  <definition term="threat.indicator.file.code_signature.digest_algorithm">
    The hashing algorithm used to sign the process. This value can distinguish signatures when a file is signed multiple times by the same signer but with a different digest algorithm.
    type: keyword
    example: sha256
  </definition>
  <definition term="threat.indicator.file.code_signature.exists">
    Boolean to capture if a signature is present.
    type: boolean
    example: true
  </definition>
  <definition term="threat.indicator.file.code_signature.signing_id">
    The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only.
    type: keyword
    example: com.apple.xpc.proxy
  </definition>
  <definition term="threat.indicator.file.code_signature.status">
    Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.
    type: keyword
    example: ERROR_UNTRUSTED_ROOT
  </definition>
  <definition term="threat.indicator.file.code_signature.subject_name">
    Subject name of the code signer
    type: keyword
    example: Microsoft Corporation
  </definition>
  <definition term="threat.indicator.file.code_signature.team_id">
    The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only.
    type: keyword
    example: EQHXZ8M8AV
  </definition>
  <definition term="threat.indicator.file.code_signature.timestamp">
    Date and time when the code signature was generated and signed.
    type: date
    example: 2021-01-01T12:10:30Z
  </definition>
  <definition term="threat.indicator.file.code_signature.trusted">
    Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.
    type: boolean
    example: true
  </definition>
  <definition term="threat.indicator.file.code_signature.valid">
    Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked.
    type: boolean
    example: true
  </definition>
  <definition term="threat.indicator.file.created">
    File creation time. Note that not all filesystems store the creation time.
    type: date
  </definition>
  <definition term="threat.indicator.file.ctime">
    Last time the file attributes or metadata changed. Note that changes to the file content will update `mtime`. This implies `ctime` will be adjusted at the same time, since `mtime` is an attribute of the file.
    type: date
  </definition>
  <definition term="threat.indicator.file.device">
    Device that is the source of the file.
    type: keyword
    example: sda
  </definition>
  <definition term="threat.indicator.file.directory">
    Directory where the file is located. It should include the drive letter, when appropriate.
    type: keyword
    example: /home/alice
  </definition>
  <definition term="threat.indicator.file.drive_letter">
    Drive letter where the file is located. This field is only relevant on Windows. The value should be uppercase, and not include the colon.
    type: keyword
    example: C
  </definition>
  <definition term="threat.indicator.file.elf.architecture">
    Machine architecture of the ELF file.
    type: keyword
    example: x86-64
  </definition>
  <definition term="threat.indicator.file.elf.byte_order">
    Byte sequence of ELF file.
    type: keyword
    example: Little Endian
  </definition>
  <definition term="threat.indicator.file.elf.cpu_type">
    CPU type of the ELF file.
    type: keyword
    example: Intel
  </definition>
  <definition term="threat.indicator.file.elf.creation_date">
    Extracted when possible from the file's metadata. Indicates when it was built or compiled. It can also be faked by malware creators.
    type: date
  </definition>
  <definition term="threat.indicator.file.elf.exports">
    List of exported element names and types.
    type: flattened
  </definition>
  <definition term="threat.indicator.file.elf.header.abi_version">
    Version of the ELF Application Binary Interface (ABI).
    type: keyword
  </definition>
  <definition term="threat.indicator.file.elf.header.class">
    Header class of the ELF file.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.elf.header.data">
    Data table of the ELF header.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.elf.header.entrypoint">
    Header entrypoint of the ELF file.
    type: long
    format: string
  </definition>
  <definition term="threat.indicator.file.elf.header.object_version">
    "0x1" for original ELF files.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.elf.header.os_abi">
    Application Binary Interface (ABI) of the Linux OS.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.elf.header.type">
    Header type of the ELF file.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.elf.header.version">
    Version of the ELF header.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.elf.imports">
    List of imported element names and types.
    type: flattened
  </definition>
  <definition term="threat.indicator.file.elf.sections">
    An array containing an object for each section of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.sections.*`.
    type: nested
  </definition>
  <definition term="threat.indicator.file.elf.sections.chi2">
    Chi-square probability distribution of the section.
    type: long
    format: number
  </definition>
  <definition term="threat.indicator.file.elf.sections.entropy">
    Shannon entropy calculation from the section.
    type: long
    format: number
  </definition>
  <definition term="threat.indicator.file.elf.sections.flags">
    ELF Section List flags.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.elf.sections.name">
    ELF Section List name.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.elf.sections.physical_offset">
    ELF Section List offset.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.elf.sections.physical_size">
    ELF Section List physical size.
    type: long
    format: bytes
  </definition>
  <definition term="threat.indicator.file.elf.sections.type">
    ELF Section List type.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.elf.sections.virtual_address">
    ELF Section List virtual address.
    type: long
    format: string
  </definition>
  <definition term="threat.indicator.file.elf.sections.virtual_size">
    ELF Section List virtual size.
    type: long
    format: string
  </definition>
  <definition term="threat.indicator.file.elf.segments">
    An array containing an object for each segment of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.segments.*`.
    type: nested
  </definition>
  <definition term="threat.indicator.file.elf.segments.sections">
    ELF object segment sections.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.elf.segments.type">
    ELF object segment type.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.elf.shared_libraries">
    List of shared libraries used by this ELF object.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.elf.telfhash">
    telfhash symbol hash for ELF file.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.extension">
    File extension, excluding the leading dot. Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").
    type: keyword
    example: png
  </definition>
  <definition term="threat.indicator.file.fork_name">
    A fork is additional data associated with a filesystem object. On Linux, a resource fork is used to store additional data with a filesystem object. A file always has at least one fork for the data portion, and additional forks may exist. On NTFS, this is analogous to an Alternate Data Stream (ADS), and the default data stream for a file is just called $DATA. Zone.Identifier is commonly used by Windows to track contents downloaded from the Internet. An ADS is typically of the form: `C:\path\to\filename.extension:some_fork_name`, and `some_fork_name` is the value that should populate `fork_name`. `filename.extension` should populate `file.name`, and `extension` should populate `file.extension`. The full path, `file.path`, will include the fork name.
    type: keyword
    example: Zone.Identifer
  </definition>
  <definition term="threat.indicator.file.gid">
    Primary group ID (GID) of the file.
    type: keyword
    example: 1001
  </definition>
  <definition term="threat.indicator.file.group">
    Primary group name of the file.
    type: keyword
    example: alice
  </definition>
  <definition term="threat.indicator.file.hash.md5">
    MD5 hash.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.hash.sha1">
    SHA1 hash.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.hash.sha256">
    SHA256 hash.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.hash.sha512">
    SHA512 hash.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.hash.ssdeep">
    SSDEEP hash.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.inode">
    Inode representing the file in the filesystem.
    type: keyword
    example: 256383
  </definition>
  <definition term="threat.indicator.file.mime_type">
    MIME type should identify the format of the file or stream of bytes using https://www.iana.org/assignments/media-types/media-types.xhtml[IANA official types], where possible. When more than one type is applicable, the most specific type should be used.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.mode">
    Mode of the file in octal representation.
    type: keyword
    example: 0640
  </definition>
  <definition term="threat.indicator.file.mtime">
    Last time the file content was modified.
    type: date
  </definition>
  <definition term="threat.indicator.file.name">
    Name of the file including the extension, without the directory.
    type: keyword
    example: example.png
  </definition>
  <definition term="threat.indicator.file.owner">
    File owner's username.
    type: keyword
    example: alice
  </definition>
  <definition term="threat.indicator.file.path">
    Full path to the file, including the file name. It should include the drive letter, when appropriate.
    type: keyword
    example: /home/alice/example.png
  </definition>
  <definition term="threat.indicator.file.path.text">
    type: match_only_text
  </definition>
  <definition term="threat.indicator.file.pe.architecture">
    CPU architecture target for the file.
    type: keyword
    example: x64
  </definition>
  <definition term="threat.indicator.file.pe.company">
    Internal company name of the file, provided at compile-time.
    type: keyword
    example: Microsoft Corporation
  </definition>
  <definition term="threat.indicator.file.pe.description">
    Internal description of the file, provided at compile-time.
    type: keyword
    example: Paint
  </definition>
  <definition term="threat.indicator.file.pe.file_version">
    Internal version of the file, provided at compile-time.
    type: keyword
    example: 6.3.9600.17415
  </definition>
  <definition term="threat.indicator.file.pe.imphash">
    A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at [https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html](https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html).
    type: keyword
    example: 0c6803c4e922103c4dca5963aad36ddf
  </definition>
  <definition term="threat.indicator.file.pe.original_file_name">
    Internal name of the file, provided at compile-time.
    type: keyword
    example: MSPAINT.EXE
  </definition>
  <definition term="threat.indicator.file.pe.product">
    Internal product name of the file, provided at compile-time.
    type: keyword
    example: Microsoft® Windows® Operating System
  </definition>
  <definition term="threat.indicator.file.size">
    File size in bytes. Only relevant when `file.type` is "file".
    type: long
    example: 16384
  </definition>
  <definition term="threat.indicator.file.target_path">
    Target path for symlinks.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.target_path.text">
    type: match_only_text
  </definition>
  <definition term="threat.indicator.file.type">
    File type (file, dir, or symlink).
    type: keyword
    example: file
  </definition>
  <definition term="threat.indicator.file.uid">
    The user ID (UID) or security identifier (SID) of the file owner.
    type: keyword
    example: 1001
  </definition>
  <definition term="threat.indicator.file.x509.alternative_names">
    List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.
    type: keyword
    example: *.elastic.co
  </definition>
  <definition term="threat.indicator.file.x509.issuer.common_name">
    List of common name (CN) of issuing certificate authority.
    type: keyword
    example: Example SHA2 High Assurance Server CA
  </definition>
  <definition term="threat.indicator.file.x509.issuer.country">
    List of country (C) codes
    type: keyword
    example: US
  </definition>
  <definition term="threat.indicator.file.x509.issuer.distinguished_name">
    Distinguished name (DN) of issuing certificate authority.
    type: keyword
    example: C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA
  </definition>
  <definition term="threat.indicator.file.x509.issuer.locality">
    List of locality names (L)
    type: keyword
    example: Mountain View
  </definition>
  <definition term="threat.indicator.file.x509.issuer.organization">
    List of organizations (O) of issuing certificate authority.
    type: keyword
    example: Example Inc
  </definition>
  <definition term="threat.indicator.file.x509.issuer.organizational_unit">
    List of organizational units (OU) of issuing certificate authority.
    type: keyword
    example: www.example.com
  </definition>
  <definition term="threat.indicator.file.x509.issuer.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="threat.indicator.file.x509.not_after">
    Time at which the certificate is no longer considered valid.
    type: date
    example: 2020-07-16 03:15:39+00:00
  </definition>
  <definition term="threat.indicator.file.x509.not_before">
    Time at which the certificate is first considered valid.
    type: date
    example: 2019-08-16 01:40:25+00:00
  </definition>
  <definition term="threat.indicator.file.x509.public_key_algorithm">
    Algorithm used to generate the public key.
    type: keyword
    example: RSA
  </definition>
  <definition term="threat.indicator.file.x509.public_key_curve">
    The curve used by the elliptic curve public key algorithm. This is algorithm specific.
    type: keyword
    example: nistp521
  </definition>
  <definition term="threat.indicator.file.x509.public_key_exponent">
    Exponent used to derive the public key. This is algorithm specific.
    type: long
    example: 65537
  </definition>
</definitions>

Field is not indexed.
<definitions>
  <definition term="threat.indicator.file.x509.public_key_size">
    The size of the public key space in bits.
    type: long
    example: 2048
  </definition>
  <definition term="threat.indicator.file.x509.serial_number">
    Unique serial number issued by the certificate authority. For consistency, if this value is alphanumeric, it should be formatted without colons and uppercase characters.
    type: keyword
    example: 55FBB9C7DEBF09809D12CCAA
  </definition>
  <definition term="threat.indicator.file.x509.signature_algorithm">
    Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See [https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353](https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353).
    type: keyword
    example: SHA256-RSA
  </definition>
  <definition term="threat.indicator.file.x509.subject.common_name">
    List of common names (CN) of subject.
    type: keyword
    example: shared.global.example.net
  </definition>
  <definition term="threat.indicator.file.x509.subject.country">
    List of country (C) code
    type: keyword
    example: US
  </definition>
  <definition term="threat.indicator.file.x509.subject.distinguished_name">
    Distinguished name (DN) of the certificate subject entity.
    type: keyword
    example: C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net
  </definition>
  <definition term="threat.indicator.file.x509.subject.locality">
    List of locality names (L)
    type: keyword
    example: San Francisco
  </definition>
  <definition term="threat.indicator.file.x509.subject.organization">
    List of organizations (O) of subject.
    type: keyword
    example: Example, Inc.
  </definition>
  <definition term="threat.indicator.file.x509.subject.organizational_unit">
    List of organizational units (OU) of subject.
    type: keyword
  </definition>
  <definition term="threat.indicator.file.x509.subject.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="threat.indicator.file.x509.version_number">
    Version of x509 format.
    type: keyword
    example: 3
  </definition>
  <definition term="threat.indicator.first_seen">
    The date and time when intelligence source first reported sighting this indicator.
    type: date
    example: 2020-11-05T17:25:47.000Z
  </definition>
  <definition term="threat.indicator.geo.city_name">
    City name.
    type: keyword
    example: Montreal
  </definition>
  <definition term="threat.indicator.geo.continent_code">
    Two-letter code representing continent's name.
    type: keyword
    example: NA
  </definition>
  <definition term="threat.indicator.geo.continent_name">
    Name of the continent.
    type: keyword
    example: North America
  </definition>
  <definition term="threat.indicator.geo.country_iso_code">
    Country ISO code.
    type: keyword
    example: CA
  </definition>
  <definition term="threat.indicator.geo.country_name">
    Country name.
    type: keyword
    example: Canada
  </definition>
  <definition term="threat.indicator.geo.location">
    Longitude and latitude.
    type: geo_point
    example: { "lon": -73.614830, "lat": 45.505918 }
  </definition>
  <definition term="threat.indicator.geo.name">
    User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.
    type: keyword
    example: boston-dc
  </definition>
  <definition term="threat.indicator.geo.postal_code">
    Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.
    type: keyword
    example: 94040
  </definition>
  <definition term="threat.indicator.geo.region_iso_code">
    Region ISO code.
    type: keyword
    example: CA-QC
  </definition>
  <definition term="threat.indicator.geo.region_name">
    Region name.
    type: keyword
    example: Quebec
  </definition>
  <definition term="threat.indicator.geo.timezone">
    The time zone of the location, such as IANA time zone name.
    type: keyword
    example: America/Argentina/Buenos_Aires
  </definition>
  <definition term="threat.indicator.ip">
    Identifies a threat indicator as an IP address (irrespective of direction).
    type: ip
    example: 1.2.3.4
  </definition>
  <definition term="threat.indicator.last_seen">
    The date and time when intelligence source last reported sighting this indicator.
    type: date
    example: 2020-11-05T17:25:47.000Z
  </definition>
  <definition term="threat.indicator.marking.tlp">
    Traffic Light Protocol sharing markings. Recommended values are:   * WHITE   * GREEN   * AMBER   * RED
    type: keyword
    example: WHITE
  </definition>
  <definition term="threat.indicator.modified_at">
    The date and time when intelligence source last modified information for this indicator.
    type: date
    example: 2020-11-05T17:25:47.000Z
  </definition>
  <definition term="threat.indicator.port">
    Identifies a threat indicator as a port number (irrespective of direction).
    type: long
    example: 443
  </definition>
  <definition term="threat.indicator.provider">
    The name of the indicator's provider.
    type: keyword
    example: lrz_urlhaus
  </definition>
  <definition term="threat.indicator.reference">
    Reference URL linking to additional information about this indicator.
    type: keyword
    example: https://system.example.com/indicator/0001234
  </definition>
  <definition term="threat.indicator.registry.data.bytes">
    Original bytes written with base64 encoding. For Windows registry operations, such as SetValueEx and RegQueryValueEx, this corresponds to the data pointed by `lp_data`. This is optional but provides better recoverability and should be populated for REG_BINARY encoded values.
    type: keyword
    example: ZQBuAC0AVQBTAAAAZQBuAAAAAAA=
  </definition>
  <definition term="threat.indicator.registry.data.strings">
    Content when writing string types. Populated as an array when writing string data to the registry. For single string registry types (REG_SZ, REG_EXPAND_SZ), this should be an array with one string. For sequences of string with REG_MULTI_SZ, this array will be variable length. For numeric data, such as REG_DWORD and REG_QWORD, this should be populated with the decimal representation (e.g `"1"`).
    type: wildcard
    example: ["C:\rta\red_ttp\bin\myapp.exe"]
  </definition>
  <definition term="threat.indicator.registry.data.type">
    Standard registry type for encoding contents
    type: keyword
    example: REG_SZ
  </definition>
  <definition term="threat.indicator.registry.hive">
    Abbreviated name for the hive.
    type: keyword
    example: HKLM
  </definition>
  <definition term="threat.indicator.registry.key">
    Hive-relative path of keys.
    type: keyword
    example: SOFTWARE\Microsoft\Windows NT\CurrentVersion\Image File Execution Options\winword.exe
  </definition>
  <definition term="threat.indicator.registry.path">
    Full path, including hive, key and value
    type: keyword
    example: HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Image File Execution Options\winword.exe\Debugger
  </definition>
  <definition term="threat.indicator.registry.value">
    Name of the value written.
    type: keyword
    example: Debugger
  </definition>
  <definition term="threat.indicator.scanner_stats">
    Count of AV/EDR vendors that successfully detected malicious file or URL.
    type: long
    example: 4
  </definition>
  <definition term="threat.indicator.sightings">
    Number of times this indicator was observed conducting threat activity.
    type: long
    example: 20
  </definition>
  <definition term="threat.indicator.type">
    Type of indicator as represented by Cyber Observable in STIX 2.0. Recommended values:   * autonomous-system   * artifact   * directory   * domain-name   * email-addr   * file   * ipv4-addr   * ipv6-addr   * mac-addr   * mutex   * port   * process   * software   * url   * user-account   * windows-registry-key   * x509-certificate
    type: keyword
    example: ipv4-addr
  </definition>
  <definition term="threat.indicator.url.domain">
    Domain of the url, such as "www.elastic.co". In some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field. If the URL contains a literal IPv6 address enclosed by `[` and `]` (IETF RFC 2732), the `[` and `]` characters should also be captured in the `domain` field.
    type: keyword
    example: www.elastic.co
  </definition>
  <definition term="threat.indicator.url.extension">
    The field contains the file extension from the original request url, excluding the leading dot. The file extension is only set if it exists, as not every url has a file extension. The leading period must not be included. For example, the value must be "png", not ".png". Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").
    type: keyword
    example: png
  </definition>
  <definition term="threat.indicator.url.fragment">
    Portion of the url after the `#`, such as "top". The `#` is not part of the fragment.
    type: keyword
  </definition>
  <definition term="threat.indicator.url.full">
    If full URLs are important to your use case, they should be stored in `url.full`, whether this field is reconstructed or present in the event source.
    type: wildcard
    example: https://www.elastic.co:443/search?q=elasticsearch#top
  </definition>
  <definition term="threat.indicator.url.full.text">
    type: match_only_text
  </definition>
  <definition term="threat.indicator.url.original">
    Unmodified original url as seen in the event source. Note that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path. This field is meant to represent the URL as it was observed, complete or not.
    type: wildcard
    example: https://www.elastic.co:443/search?q=elasticsearch#top or /search?q=elasticsearch
  </definition>
  <definition term="threat.indicator.url.original.text">
    type: match_only_text
  </definition>
  <definition term="threat.indicator.url.password">
    Password of the request.
    type: keyword
  </definition>
  <definition term="threat.indicator.url.path">
    Path of the request, such as "/search".
    type: wildcard
  </definition>
  <definition term="threat.indicator.url.port">
    Port of the request, such as 443.
    type: long
    example: 443
    format: string
  </definition>
  <definition term="threat.indicator.url.query">
    The query field describes the query string of the request, such as "q=elasticsearch". The `?` is excluded from the query string. If a URL contains no `?`, there is no query field. If there is a `?` but no query, the query field exists with an empty string. The `exists` query can be used to differentiate between the two cases.
    type: keyword
  </definition>
  <definition term="threat.indicator.url.registered_domain">
    The highest registered url domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".
    type: keyword
    example: example.com
  </definition>
  <definition term="threat.indicator.url.scheme">
    Scheme of the request, such as "https". Note: The `:` is not part of the scheme.
    type: keyword
    example: https
  </definition>
  <definition term="threat.indicator.url.subdomain">
    The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain. For example the subdomain portion of "www.east.example.com" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.
    type: keyword
    example: east
  </definition>
  <definition term="threat.indicator.url.top_level_domain">
    The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".
    type: keyword
    example: co.uk
  </definition>
  <definition term="threat.indicator.url.username">
    Username of the request.
    type: keyword
  </definition>
  <definition term="threat.indicator.x509.alternative_names">
    List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.
    type: keyword
    example: *.elastic.co
  </definition>
  <definition term="threat.indicator.x509.issuer.common_name">
    List of common name (CN) of issuing certificate authority.
    type: keyword
    example: Example SHA2 High Assurance Server CA
  </definition>
  <definition term="threat.indicator.x509.issuer.country">
    List of country (C) codes
    type: keyword
    example: US
  </definition>
  <definition term="threat.indicator.x509.issuer.distinguished_name">
    Distinguished name (DN) of issuing certificate authority.
    type: keyword
    example: C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA
  </definition>
  <definition term="threat.indicator.x509.issuer.locality">
    List of locality names (L)
    type: keyword
    example: Mountain View
  </definition>
  <definition term="threat.indicator.x509.issuer.organization">
    List of organizations (O) of issuing certificate authority.
    type: keyword
    example: Example Inc
  </definition>
  <definition term="threat.indicator.x509.issuer.organizational_unit">
    List of organizational units (OU) of issuing certificate authority.
    type: keyword
    example: www.example.com
  </definition>
  <definition term="threat.indicator.x509.issuer.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="threat.indicator.x509.not_after">
    Time at which the certificate is no longer considered valid.
    type: date
    example: 2020-07-16 03:15:39+00:00
  </definition>
  <definition term="threat.indicator.x509.not_before">
    Time at which the certificate is first considered valid.
    type: date
    example: 2019-08-16 01:40:25+00:00
  </definition>
  <definition term="threat.indicator.x509.public_key_algorithm">
    Algorithm used to generate the public key.
    type: keyword
    example: RSA
  </definition>
  <definition term="threat.indicator.x509.public_key_curve">
    The curve used by the elliptic curve public key algorithm. This is algorithm specific.
    type: keyword
    example: nistp521
  </definition>
  <definition term="threat.indicator.x509.public_key_exponent">
    Exponent used to derive the public key. This is algorithm specific.
    type: long
    example: 65537
  </definition>
</definitions>

Field is not indexed.
<definitions>
  <definition term="threat.indicator.x509.public_key_size">
    The size of the public key space in bits.
    type: long
    example: 2048
  </definition>
  <definition term="threat.indicator.x509.serial_number">
    Unique serial number issued by the certificate authority. For consistency, if this value is alphanumeric, it should be formatted without colons and uppercase characters.
    type: keyword
    example: 55FBB9C7DEBF09809D12CCAA
  </definition>
  <definition term="threat.indicator.x509.signature_algorithm">
    Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See [https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353](https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353).
    type: keyword
    example: SHA256-RSA
  </definition>
  <definition term="threat.indicator.x509.subject.common_name">
    List of common names (CN) of subject.
    type: keyword
    example: shared.global.example.net
  </definition>
  <definition term="threat.indicator.x509.subject.country">
    List of country (C) code
    type: keyword
    example: US
  </definition>
  <definition term="threat.indicator.x509.subject.distinguished_name">
    Distinguished name (DN) of the certificate subject entity.
    type: keyword
    example: C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net
  </definition>
  <definition term="threat.indicator.x509.subject.locality">
    List of locality names (L)
    type: keyword
    example: San Francisco
  </definition>
  <definition term="threat.indicator.x509.subject.organization">
    List of organizations (O) of subject.
    type: keyword
    example: Example, Inc.
  </definition>
  <definition term="threat.indicator.x509.subject.organizational_unit">
    List of organizational units (OU) of subject.
    type: keyword
  </definition>
  <definition term="threat.indicator.x509.subject.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="threat.indicator.x509.version_number">
    Version of x509 format.
    type: keyword
    example: 3
  </definition>
  <definition term="threat.software.alias">
    The alias(es) of the software for a set of related intrusion activity that are tracked by a common name in the security community. While not required, you can use a MITRE ATT&CK® associated software description.
    type: keyword
    example: [ "X-Agent" ]
  </definition>
  <definition term="threat.software.id">
    The id of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®. While not required, you can use a MITRE ATT&CK® software id.
    type: keyword
    example: S0552
  </definition>
  <definition term="threat.software.name">
    The name of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®. While not required, you can use a MITRE ATT&CK® software name.
    type: keyword
    example: AdFind
  </definition>
  <definition term="threat.software.platforms">
    The platforms of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®. Recommended Values:   * AWS   * Azure   * Azure AD   * GCP   * Linux   * macOS   * Network   * Office 365   * SaaS   * Windows While not required, you can use a MITRE ATT&CK® software platforms.
    type: keyword
    example: [ "Windows" ]
  </definition>
  <definition term="threat.software.reference">
    The reference URL of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®. While not required, you can use a MITRE ATT&CK® software reference URL.
    type: keyword
    example: [https://attack.mitre.org/software/S0552/](https://attack.mitre.org/software/S0552/)
  </definition>
  <definition term="threat.software.type">
    The type of software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®. Recommended values   * Malware   * Tool  While not required, you can use a MITRE ATT&CK® software type.
    type: keyword
    example: Tool
  </definition>
  <definition term="threat.tactic.id">
    The id of tactic used by this threat. You can use a MITRE ATT&CK® tactic, for example. (ex. [https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/) )
    type: keyword
    example: TA0002
  </definition>
  <definition term="threat.tactic.name">
    Name of the type of tactic used by this threat. You can use a MITRE ATT&CK® tactic, for example. (ex. [https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/))
    type: keyword
    example: Execution
  </definition>
  <definition term="threat.tactic.reference">
    The reference url of tactic used by this threat. You can use a MITRE ATT&CK® tactic, for example. (ex. [https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/) )
    type: keyword
    example: [https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)
  </definition>
  <definition term="threat.technique.id">
    The id of technique used by this threat. You can use a MITRE ATT&CK® technique, for example. (ex. [https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/))
    type: keyword
    example: T1059
  </definition>
  <definition term="threat.technique.name">
    The name of technique used by this threat. You can use a MITRE ATT&CK® technique, for example. (ex. [https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/))
    type: keyword
    example: Command and Scripting Interpreter
  </definition>
  <definition term="threat.technique.name.text">
    type: match_only_text
  </definition>
  <definition term="threat.technique.reference">
    The reference url of technique used by this threat. You can use a MITRE ATT&CK® technique, for example. (ex. [https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/))
    type: keyword
    example: [https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)
  </definition>
  <definition term="threat.technique.subtechnique.id">
    The full id of subtechnique used by this threat. You can use a MITRE ATT&CK® subtechnique, for example. (ex. [https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/))
    type: keyword
    example: T1059.001
  </definition>
  <definition term="threat.technique.subtechnique.name">
    The name of subtechnique used by this threat. You can use a MITRE ATT&CK® subtechnique, for example. (ex. [https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/))
    type: keyword
    example: PowerShell
  </definition>
  <definition term="threat.technique.subtechnique.name.text">
    type: match_only_text
  </definition>
  <definition term="threat.technique.subtechnique.reference">
    The reference url of subtechnique used by this threat. You can use a MITRE ATT&CK® subtechnique, for example. (ex. [https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/))
    type: keyword
    example: [https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/)
  </definition>
</definitions>


## tls

Fields related to a TLS connection. These fields focus on the TLS protocol itself and intentionally avoids in-depth analysis of the related x.509 certificate files.
<definitions>
  <definition term="tls.cipher">
    String indicating the cipher used during the current connection.
    type: keyword
    example: TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
  </definition>
  <definition term="tls.client.certificate">
    PEM-encoded stand-alone certificate offered by the client. This is usually mutually-exclusive of `client.certificate_chain` since this value also exists in that list.
    type: keyword
    example: MII...
  </definition>
  <definition term="tls.client.certificate_chain">
    Array of PEM-encoded certificates that make up the certificate chain offered by the client. This is usually mutually-exclusive of `client.certificate` since that value should be the first certificate in the chain.
    type: keyword
    example: ["MII...", "MII..."]
  </definition>
  <definition term="tls.client.hash.md5">
    Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.
    type: keyword
    example: 0F76C7F2C55BFD7D8E8B8F4BFBF0C9EC
  </definition>
  <definition term="tls.client.hash.sha1">
    Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.
    type: keyword
    example: 9E393D93138888D288266C2D915214D1D1CCEB2A
  </definition>
  <definition term="tls.client.hash.sha256">
    Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.
    type: keyword
    example: 0687F666A054EF17A08E2F2162EAB4CBC0D265E1D7875BE74BF3C712CA92DAF0
  </definition>
  <definition term="tls.client.issuer">
    Distinguished name of subject of the issuer of the x.509 certificate presented by the client.
    type: keyword
    example: CN=Example Root CA, OU=Infrastructure Team, DC=example, DC=com
  </definition>
  <definition term="tls.client.ja3">
    A hash that identifies clients based on how they perform an SSL/TLS handshake.
    type: keyword
    example: d4e5b18d6b55c71272893221c96ba240
  </definition>
  <definition term="tls.client.not_after">
    Date/Time indicating when client certificate is no longer considered valid.
    type: date
    example: 2021-01-01T00:00:00.000Z
  </definition>
  <definition term="tls.client.not_before">
    Date/Time indicating when client certificate is first considered valid.
    type: date
    example: 1970-01-01T00:00:00.000Z
  </definition>
  <definition term="tls.client.server_name">
    Also called an SNI, this tells the server which hostname to which the client is attempting to connect to. When this value is available, it should get copied to `destination.domain`.
    type: keyword
    example: www.elastic.co
  </definition>
  <definition term="tls.client.subject">
    Distinguished name of subject of the x.509 certificate presented by the client.
    type: keyword
    example: CN=myclient, OU=Documentation Team, DC=example, DC=com
  </definition>
  <definition term="tls.client.supported_ciphers">
    Array of ciphers offered by the client during the client hello.
    type: keyword
    example: ["TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "..."]
  </definition>
  <definition term="tls.client.x509.alternative_names">
    List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.
    type: keyword
    example: *.elastic.co
  </definition>
  <definition term="tls.client.x509.issuer.common_name">
    List of common name (CN) of issuing certificate authority.
    type: keyword
    example: Example SHA2 High Assurance Server CA
  </definition>
  <definition term="tls.client.x509.issuer.country">
    List of country (C) codes
    type: keyword
    example: US
  </definition>
  <definition term="tls.client.x509.issuer.distinguished_name">
    Distinguished name (DN) of issuing certificate authority.
    type: keyword
    example: C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA
  </definition>
  <definition term="tls.client.x509.issuer.locality">
    List of locality names (L)
    type: keyword
    example: Mountain View
  </definition>
  <definition term="tls.client.x509.issuer.organization">
    List of organizations (O) of issuing certificate authority.
    type: keyword
    example: Example Inc
  </definition>
  <definition term="tls.client.x509.issuer.organizational_unit">
    List of organizational units (OU) of issuing certificate authority.
    type: keyword
    example: www.example.com
  </definition>
  <definition term="tls.client.x509.issuer.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="tls.client.x509.not_after">
    Time at which the certificate is no longer considered valid.
    type: date
    example: 2020-07-16 03:15:39+00:00
  </definition>
  <definition term="tls.client.x509.not_before">
    Time at which the certificate is first considered valid.
    type: date
    example: 2019-08-16 01:40:25+00:00
  </definition>
  <definition term="tls.client.x509.public_key_algorithm">
    Algorithm used to generate the public key.
    type: keyword
    example: RSA
  </definition>
  <definition term="tls.client.x509.public_key_curve">
    The curve used by the elliptic curve public key algorithm. This is algorithm specific.
    type: keyword
    example: nistp521
  </definition>
  <definition term="tls.client.x509.public_key_exponent">
    Exponent used to derive the public key. This is algorithm specific.
    type: long
    example: 65537
  </definition>
</definitions>

Field is not indexed.
<definitions>
  <definition term="tls.client.x509.public_key_size">
    The size of the public key space in bits.
    type: long
    example: 2048
  </definition>
  <definition term="tls.client.x509.serial_number">
    Unique serial number issued by the certificate authority. For consistency, if this value is alphanumeric, it should be formatted without colons and uppercase characters.
    type: keyword
    example: 55FBB9C7DEBF09809D12CCAA
  </definition>
  <definition term="tls.client.x509.signature_algorithm">
    Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See [https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353](https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353).
    type: keyword
    example: SHA256-RSA
  </definition>
  <definition term="tls.client.x509.subject.common_name">
    List of common names (CN) of subject.
    type: keyword
    example: shared.global.example.net
  </definition>
  <definition term="tls.client.x509.subject.country">
    List of country (C) code
    type: keyword
    example: US
  </definition>
  <definition term="tls.client.x509.subject.distinguished_name">
    Distinguished name (DN) of the certificate subject entity.
    type: keyword
    example: C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net
  </definition>
  <definition term="tls.client.x509.subject.locality">
    List of locality names (L)
    type: keyword
    example: San Francisco
  </definition>
  <definition term="tls.client.x509.subject.organization">
    List of organizations (O) of subject.
    type: keyword
    example: Example, Inc.
  </definition>
  <definition term="tls.client.x509.subject.organizational_unit">
    List of organizational units (OU) of subject.
    type: keyword
  </definition>
  <definition term="tls.client.x509.subject.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="tls.client.x509.version_number">
    Version of x509 format.
    type: keyword
    example: 3
  </definition>
  <definition term="tls.curve">
    String indicating the curve used for the given cipher, when applicable.
    type: keyword
    example: secp256r1
  </definition>
  <definition term="tls.established">
    Boolean flag indicating if the TLS negotiation was successful and transitioned to an encrypted tunnel.
    type: boolean
  </definition>
  <definition term="tls.next_protocol">
    String indicating the protocol being tunneled. Per the values in the IANA registry ([https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids](https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids)), this string should be lower case.
    type: keyword
    example: http/1.1
  </definition>
  <definition term="tls.resumed">
    Boolean flag indicating if this TLS connection was resumed from an existing TLS negotiation.
    type: boolean
  </definition>
  <definition term="tls.server.certificate">
    PEM-encoded stand-alone certificate offered by the server. This is usually mutually-exclusive of `server.certificate_chain` since this value also exists in that list.
    type: keyword
    example: MII...
  </definition>
  <definition term="tls.server.certificate_chain">
    Array of PEM-encoded certificates that make up the certificate chain offered by the server. This is usually mutually-exclusive of `server.certificate` since that value should be the first certificate in the chain.
    type: keyword
    example: ["MII...", "MII..."]
  </definition>
  <definition term="tls.server.hash.md5">
    Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.
    type: keyword
    example: 0F76C7F2C55BFD7D8E8B8F4BFBF0C9EC
  </definition>
  <definition term="tls.server.hash.sha1">
    Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.
    type: keyword
    example: 9E393D93138888D288266C2D915214D1D1CCEB2A
  </definition>
  <definition term="tls.server.hash.sha256">
    Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.
    type: keyword
    example: 0687F666A054EF17A08E2F2162EAB4CBC0D265E1D7875BE74BF3C712CA92DAF0
  </definition>
  <definition term="tls.server.issuer">
    Subject of the issuer of the x.509 certificate presented by the server.
    type: keyword
    example: CN=Example Root CA, OU=Infrastructure Team, DC=example, DC=com
  </definition>
  <definition term="tls.server.ja3s">
    A hash that identifies servers based on how they perform an SSL/TLS handshake.
    type: keyword
    example: 394441ab65754e2207b1e1b457b3641d
  </definition>
  <definition term="tls.server.not_after">
    Timestamp indicating when server certificate is no longer considered valid.
    type: date
    example: 2021-01-01T00:00:00.000Z
  </definition>
  <definition term="tls.server.not_before">
    Timestamp indicating when server certificate is first considered valid.
    type: date
    example: 1970-01-01T00:00:00.000Z
  </definition>
  <definition term="tls.server.subject">
    Subject of the x.509 certificate presented by the server.
    type: keyword
    example: CN=www.example.com, OU=Infrastructure Team, DC=example, DC=com
  </definition>
  <definition term="tls.server.x509.alternative_names">
    List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.
    type: keyword
    example: *.elastic.co
  </definition>
  <definition term="tls.server.x509.issuer.common_name">
    List of common name (CN) of issuing certificate authority.
    type: keyword
    example: Example SHA2 High Assurance Server CA
  </definition>
  <definition term="tls.server.x509.issuer.country">
    List of country (C) codes
    type: keyword
    example: US
  </definition>
  <definition term="tls.server.x509.issuer.distinguished_name">
    Distinguished name (DN) of issuing certificate authority.
    type: keyword
    example: C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA
  </definition>
  <definition term="tls.server.x509.issuer.locality">
    List of locality names (L)
    type: keyword
    example: Mountain View
  </definition>
  <definition term="tls.server.x509.issuer.organization">
    List of organizations (O) of issuing certificate authority.
    type: keyword
    example: Example Inc
  </definition>
  <definition term="tls.server.x509.issuer.organizational_unit">
    List of organizational units (OU) of issuing certificate authority.
    type: keyword
    example: www.example.com
  </definition>
  <definition term="tls.server.x509.issuer.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="tls.server.x509.not_after">
    Time at which the certificate is no longer considered valid.
    type: date
    example: 2020-07-16 03:15:39+00:00
  </definition>
  <definition term="tls.server.x509.not_before">
    Time at which the certificate is first considered valid.
    type: date
    example: 2019-08-16 01:40:25+00:00
  </definition>
  <definition term="tls.server.x509.public_key_algorithm">
    Algorithm used to generate the public key.
    type: keyword
    example: RSA
  </definition>
  <definition term="tls.server.x509.public_key_curve">
    The curve used by the elliptic curve public key algorithm. This is algorithm specific.
    type: keyword
    example: nistp521
  </definition>
  <definition term="tls.server.x509.public_key_exponent">
    Exponent used to derive the public key. This is algorithm specific.
    type: long
    example: 65537
  </definition>
</definitions>

Field is not indexed.
<definitions>
  <definition term="tls.server.x509.public_key_size">
    The size of the public key space in bits.
    type: long
    example: 2048
  </definition>
  <definition term="tls.server.x509.serial_number">
    Unique serial number issued by the certificate authority. For consistency, if this value is alphanumeric, it should be formatted without colons and uppercase characters.
    type: keyword
    example: 55FBB9C7DEBF09809D12CCAA
  </definition>
  <definition term="tls.server.x509.signature_algorithm">
    Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See [https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353](https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353).
    type: keyword
    example: SHA256-RSA
  </definition>
  <definition term="tls.server.x509.subject.common_name">
    List of common names (CN) of subject.
    type: keyword
    example: shared.global.example.net
  </definition>
  <definition term="tls.server.x509.subject.country">
    List of country (C) code
    type: keyword
    example: US
  </definition>
  <definition term="tls.server.x509.subject.distinguished_name">
    Distinguished name (DN) of the certificate subject entity.
    type: keyword
    example: C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net
  </definition>
  <definition term="tls.server.x509.subject.locality">
    List of locality names (L)
    type: keyword
    example: San Francisco
  </definition>
  <definition term="tls.server.x509.subject.organization">
    List of organizations (O) of subject.
    type: keyword
    example: Example, Inc.
  </definition>
  <definition term="tls.server.x509.subject.organizational_unit">
    List of organizational units (OU) of subject.
    type: keyword
  </definition>
  <definition term="tls.server.x509.subject.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="tls.server.x509.version_number">
    Version of x509 format.
    type: keyword
    example: 3
  </definition>
  <definition term="tls.version">
    Numeric part of the version parsed from the original string.
    type: keyword
    example: 1.2
  </definition>
  <definition term="tls.version_protocol">
    Normalized lowercase protocol name parsed from original string.
    type: keyword
    example: tls
  </definition>
  <definition term="span.id">
    Unique identifier of the span within the scope of its trace. A span represents an operation within a transaction, such as a request to another service, or a database query.
    type: keyword
    example: 3ff9a8981b7ccd5a
  </definition>
  <definition term="trace.id">
    Unique identifier of the trace. A trace groups multiple events like transactions that belong together. For example, a user request handled by multiple inter-connected services.
    type: keyword
    example: 4bf92f3577b34da6a3ce929d0e0e4736
  </definition>
  <definition term="transaction.id">
    Unique identifier of the transaction within the scope of its trace. A transaction is the highest level of work measured within a service, such as a request to a server.
    type: keyword
    example: 00f067aa0ba902b7
  </definition>
</definitions>


## url

URL fields provide support for complete or partial URLs, and supports the breaking down into scheme, domain, path, and so on.
<definitions>
  <definition term="url.domain">
    Domain of the url, such as "www.elastic.co". In some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field. If the URL contains a literal IPv6 address enclosed by `[` and `]` (IETF RFC 2732), the `[` and `]` characters should also be captured in the `domain` field.
    type: keyword
    example: www.elastic.co
  </definition>
  <definition term="url.extension">
    The field contains the file extension from the original request url, excluding the leading dot. The file extension is only set if it exists, as not every url has a file extension. The leading period must not be included. For example, the value must be "png", not ".png". Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").
    type: keyword
    example: png
  </definition>
  <definition term="url.fragment">
    Portion of the url after the `#`, such as "top". The `#` is not part of the fragment.
    type: keyword
  </definition>
  <definition term="url.full">
    If full URLs are important to your use case, they should be stored in `url.full`, whether this field is reconstructed or present in the event source.
    type: wildcard
    example: https://www.elastic.co:443/search?q=elasticsearch#top
  </definition>
  <definition term="url.full.text">
    type: match_only_text
  </definition>
  <definition term="url.original">
    Unmodified original url as seen in the event source. Note that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path. This field is meant to represent the URL as it was observed, complete or not.
    type: wildcard
    example: https://www.elastic.co:443/search?q=elasticsearch#top or /search?q=elasticsearch
  </definition>
  <definition term="url.original.text">
    type: match_only_text
  </definition>
  <definition term="url.password">
    Password of the request.
    type: keyword
  </definition>
  <definition term="url.path">
    Path of the request, such as "/search".
    type: wildcard
  </definition>
  <definition term="url.port">
    Port of the request, such as 443.
    type: long
    example: 443
    format: string
  </definition>
  <definition term="url.query">
    The query field describes the query string of the request, such as "q=elasticsearch". The `?` is excluded from the query string. If a URL contains no `?`, there is no query field. If there is a `?` but no query, the query field exists with an empty string. The `exists` query can be used to differentiate between the two cases.
    type: keyword
  </definition>
  <definition term="url.registered_domain">
    The highest registered url domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".
    type: keyword
    example: example.com
  </definition>
  <definition term="url.scheme">
    Scheme of the request, such as "https". Note: The `:` is not part of the scheme.
    type: keyword
    example: https
  </definition>
  <definition term="url.subdomain">
    The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain. For example the subdomain portion of "www.east.example.com" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.
    type: keyword
    example: east
  </definition>
  <definition term="url.top_level_domain">
    The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".
    type: keyword
    example: co.uk
  </definition>
  <definition term="url.username">
    Username of the request.
    type: keyword
  </definition>
</definitions>


## user

The user fields describe information about the user that is relevant to the event.
Fields can have one entry or multiple entries. If a user has more than one id, provide an array that includes all of them.
<definitions>
  <definition term="user.changes.domain">
    Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="user.changes.email">
    User email address.
    type: keyword
  </definition>
  <definition term="user.changes.full_name">
    User's full name, if available.
    type: keyword
    example: Albert Einstein
  </definition>
  <definition term="user.changes.full_name.text">
    type: match_only_text
  </definition>
  <definition term="user.changes.group.domain">
    Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="user.changes.group.id">
    Unique identifier for the group on the system/platform.
    type: keyword
  </definition>
  <definition term="user.changes.group.name">
    Name of the group.
    type: keyword
  </definition>
  <definition term="user.changes.hash">
    Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used.
    type: keyword
  </definition>
  <definition term="user.changes.id">
    Unique identifier of the user.
    type: keyword
    example: S-1-5-21-202424912787-2692429404-2351956786-1000
  </definition>
  <definition term="user.changes.name">
    Short name or login of the user.
    type: keyword
    example: a.einstein
  </definition>
  <definition term="user.changes.name.text">
    type: match_only_text
  </definition>
  <definition term="user.changes.roles">
    Array of user roles at the time of the event.
    type: keyword
    example: ["kibana_admin", "reporting_user"]
  </definition>
  <definition term="user.domain">
    Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="user.effective.domain">
    Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="user.effective.email">
    User email address.
    type: keyword
  </definition>
  <definition term="user.effective.full_name">
    User's full name, if available.
    type: keyword
    example: Albert Einstein
  </definition>
  <definition term="user.effective.full_name.text">
    type: match_only_text
  </definition>
  <definition term="user.effective.group.domain">
    Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="user.effective.group.id">
    Unique identifier for the group on the system/platform.
    type: keyword
  </definition>
  <definition term="user.effective.group.name">
    Name of the group.
    type: keyword
  </definition>
  <definition term="user.effective.hash">
    Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used.
    type: keyword
  </definition>
  <definition term="user.effective.id">
    Unique identifier of the user.
    type: keyword
    example: S-1-5-21-202424912787-2692429404-2351956786-1000
  </definition>
  <definition term="user.effective.name">
    Short name or login of the user.
    type: keyword
    example: a.einstein
  </definition>
  <definition term="user.effective.name.text">
    type: match_only_text
  </definition>
  <definition term="user.effective.roles">
    Array of user roles at the time of the event.
    type: keyword
    example: ["kibana_admin", "reporting_user"]
  </definition>
  <definition term="user.email">
    User email address.
    type: keyword
  </definition>
  <definition term="user.full_name">
    User's full name, if available.
    type: keyword
    example: Albert Einstein
  </definition>
  <definition term="user.full_name.text">
    type: match_only_text
  </definition>
  <definition term="user.group.domain">
    Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="user.group.id">
    Unique identifier for the group on the system/platform.
    type: keyword
  </definition>
  <definition term="user.group.name">
    Name of the group.
    type: keyword
  </definition>
  <definition term="user.hash">
    Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used.
    type: keyword
  </definition>
  <definition term="user.id">
    Unique identifier of the user.
    type: keyword
    example: S-1-5-21-202424912787-2692429404-2351956786-1000
  </definition>
  <definition term="user.name">
    Short name or login of the user.
    type: keyword
    example: a.einstein
  </definition>
  <definition term="user.name.text">
    type: match_only_text
  </definition>
  <definition term="user.roles">
    Array of user roles at the time of the event.
    type: keyword
    example: ["kibana_admin", "reporting_user"]
  </definition>
  <definition term="user.target.domain">
    Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="user.target.email">
    User email address.
    type: keyword
  </definition>
  <definition term="user.target.full_name">
    User's full name, if available.
    type: keyword
    example: Albert Einstein
  </definition>
  <definition term="user.target.full_name.text">
    type: match_only_text
  </definition>
  <definition term="user.target.group.domain">
    Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.
    type: keyword
  </definition>
  <definition term="user.target.group.id">
    Unique identifier for the group on the system/platform.
    type: keyword
  </definition>
  <definition term="user.target.group.name">
    Name of the group.
    type: keyword
  </definition>
  <definition term="user.target.hash">
    Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used.
    type: keyword
  </definition>
  <definition term="user.target.id">
    Unique identifier of the user.
    type: keyword
    example: S-1-5-21-202424912787-2692429404-2351956786-1000
  </definition>
  <definition term="user.target.name">
    Short name or login of the user.
    type: keyword
    example: a.einstein
  </definition>
  <definition term="user.target.name.text">
    type: match_only_text
  </definition>
  <definition term="user.target.roles">
    Array of user roles at the time of the event.
    type: keyword
    example: ["kibana_admin", "reporting_user"]
  </definition>
</definitions>


## user_agent

The user_agent fields normally come from a browser request.
They often show up in web service logs coming from the parsed user agent string.
<definitions>
  <definition term="user_agent.device.name">
    Name of the device.
    type: keyword
    example: iPhone
  </definition>
  <definition term="user_agent.name">
    Name of the user agent.
    type: keyword
    example: Safari
  </definition>
  <definition term="user_agent.original">
    Unparsed user_agent string.
    type: keyword
    example: Mozilla/5.0 (iPhone; CPU iPhone OS 12_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 Mobile/15E148 Safari/604.1
  </definition>
  <definition term="user_agent.original.text">
    type: match_only_text
  </definition>
  <definition term="user_agent.os.family">
    OS family (such as redhat, debian, freebsd, windows).
    type: keyword
    example: debian
  </definition>
  <definition term="user_agent.os.full">
    Operating system name, including the version or code name.
    type: keyword
    example: Mac OS Mojave
  </definition>
  <definition term="user_agent.os.full.text">
    type: match_only_text
  </definition>
  <definition term="user_agent.os.kernel">
    Operating system kernel version as a raw string.
    type: keyword
    example: 4.4.0-112-generic
  </definition>
  <definition term="user_agent.os.name">
    Operating system name, without the version.
    type: keyword
    example: Mac OS X
  </definition>
  <definition term="user_agent.os.name.text">
    type: match_only_text
  </definition>
  <definition term="user_agent.os.platform">
    Operating system platform (such centos, ubuntu, windows).
    type: keyword
    example: darwin
  </definition>
  <definition term="user_agent.os.type">
    Use the `os.type` field to categorize the operating system into one of the broad commercial families. One of these following values should be used (lowercase): linux, macos, unix, windows. If the OS you're dealing with is not in the list, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition.
    type: keyword
    example: macos
  </definition>
  <definition term="user_agent.os.version">
    Operating system version as a raw string.
    type: keyword
    example: 10.14.1
  </definition>
  <definition term="user_agent.version">
    Version of the user agent.
    type: keyword
    example: 12.0
  </definition>
</definitions>


## vlan

The VLAN fields are used to identify 802.1q tag(s) of a packet, as well as ingress and egress VLAN associations of an observer in relation to a specific packet or connection.
Network.vlan fields are used to record a single VLAN tag, or the outer tag in the case of q-in-q encapsulations, for a packet or connection as observed, typically provided by a network sensor (e.g. Zeek, Wireshark) passively reporting on traffic.
Network.inner VLAN fields are used to report inner q-in-q 802.1q tags (multiple 802.1q encapsulations) as observed, typically provided by a network sensor  (e.g. Zeek, Wireshark) passively reporting on traffic. Network.inner VLAN fields should only be used in addition to network.vlan fields to indicate q-in-q tagging.
Observer.ingress and observer.egress VLAN values are used to record observer specific information when observer events contain discrete ingress and egress VLAN information, typically provided by firewalls, routers, or load balancers.
<definitions>
  <definition term="vlan.id">
    VLAN ID as reported by the observer.
    type: keyword
    example: 10
  </definition>
  <definition term="vlan.name">
    Optional VLAN name as reported by the observer.
    type: keyword
    example: outside
  </definition>
</definitions>


## vulnerability

The vulnerability fields describe information about a vulnerability that is relevant to an event.
<definitions>
  <definition term="vulnerability.category">
    The type of system or architecture that the vulnerability affects. These may be platform-specific (for example, Debian or SUSE) or general (for example, Database or Firewall). For example (https://qualysguard.qualys.com/qwebhelp/fo_portal/knowledgebase/vulnerability_categories.htm[Qualys vulnerability categories]) This field must be an array.
    type: keyword
    example: ["Firewall"]
  </definition>
  <definition term="vulnerability.classification">
    The classification of the vulnerability scoring system. For example ([https://www.first.org/cvss/](https://www.first.org/cvss/))
    type: keyword
    example: CVSS
  </definition>
  <definition term="vulnerability.description">
    The description of the vulnerability that provides additional context of the vulnerability. For example (https://cve.mitre.org/about/faqs.html#cve_entry_descriptions_created[Common Vulnerabilities and Exposure CVE description])
    type: keyword
    example: In macOS before 2.12.6, there is a vulnerability in the RPC...
  </definition>
  <definition term="vulnerability.description.text">
    type: match_only_text
  </definition>
  <definition term="vulnerability.enumeration">
    The type of identifier used for this vulnerability. For example ([https://cve.mitre.org/about/](https://cve.mitre.org/about/))
    type: keyword
    example: CVE
  </definition>
  <definition term="vulnerability.id">
    The identification (ID) is the number portion of a vulnerability entry. It includes a unique identification number for the vulnerability. For example ([https://cve.mitre.org/about/faqs.html#what_is_cve_id](https://cve.mitre.org/about/faqs.html#what_is_cve_id))[Common Vulnerabilities and Exposure CVE ID]
    type: keyword
    example: CVE-2019-00001
  </definition>
  <definition term="vulnerability.reference">
    A resource that provides additional information, context, and mitigations for the identified vulnerability.
    type: keyword
    example: [https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-6111](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-6111)
  </definition>
  <definition term="vulnerability.report_id">
    The report or scan identification number.
    type: keyword
    example: 20191018.0001
  </definition>
  <definition term="vulnerability.scanner.vendor">
    The name of the vulnerability scanner vendor.
    type: keyword
    example: Tenable
  </definition>
  <definition term="vulnerability.score.base">
    Scores can range from 0.0 to 10.0, with 10.0 being the most severe. Base scores cover an assessment for exploitability metrics (attack vector, complexity, privileges, and user interaction), impact metrics (confidentiality, integrity, and availability), and scope. For example ([https://www.first.org/cvss/specification-document](https://www.first.org/cvss/specification-document))
    type: float
    example: 5.5
  </definition>
  <definition term="vulnerability.score.environmental">
    Scores can range from 0.0 to 10.0, with 10.0 being the most severe. Environmental scores cover an assessment for any modified Base metrics, confidentiality, integrity, and availability requirements. For example ([https://www.first.org/cvss/specification-document](https://www.first.org/cvss/specification-document))
    type: float
    example: 5.5
  </definition>
  <definition term="vulnerability.score.temporal">
    Scores can range from 0.0 to 10.0, with 10.0 being the most severe. Temporal scores cover an assessment for code maturity, remediation level, and confidence. For example ([https://www.first.org/cvss/specification-document](https://www.first.org/cvss/specification-document))
    type: float
  </definition>
  <definition term="vulnerability.score.version">
    The National Vulnerability Database (NVD) provides qualitative severity rankings of "Low", "Medium", and "High" for CVSS v2.0 base score ranges in addition to the severity ratings for CVSS v3.0 as they are defined in the CVSS v3.0 specification. CVSS is owned and managed by FIRST.Org, Inc. (FIRST), a US-based non-profit organization, whose mission is to help computer security incident response teams across the world. For example ([https://nvd.nist.gov/vuln-metrics/cvss](https://nvd.nist.gov/vuln-metrics/cvss))
    type: keyword
    example: 2.0
  </definition>
  <definition term="vulnerability.severity">
    The severity of the vulnerability can help with metrics and internal prioritization regarding remediation. For example ([https://nvd.nist.gov/vuln-metrics/cvss](https://nvd.nist.gov/vuln-metrics/cvss))
    type: keyword
    example: Critical
  </definition>
</definitions>


## x509

This implements the common core fields for x509 certificates. This information is likely logged with TLS sessions, digital signatures found in executable binaries, S/MIME information in email bodies, or analysis of files on disk.
When the certificate relates to a file, use the fields at `file.x509`. When hashes of the DER-encoded certificate are available, the `hash` data set should be populated as well (e.g. `file.hash.sha256`).
Events that contain certificate information about network connections, should use the x509 fields under the relevant TLS fields: `tls.server.x509` and/or `tls.client.x509`.
<definitions>
  <definition term="x509.alternative_names">
    List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.
    type: keyword
    example: *.elastic.co
  </definition>
  <definition term="x509.issuer.common_name">
    List of common name (CN) of issuing certificate authority.
    type: keyword
    example: Example SHA2 High Assurance Server CA
  </definition>
  <definition term="x509.issuer.country">
    List of country (C) codes
    type: keyword
    example: US
  </definition>
  <definition term="x509.issuer.distinguished_name">
    Distinguished name (DN) of issuing certificate authority.
    type: keyword
    example: C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA
  </definition>
  <definition term="x509.issuer.locality">
    List of locality names (L)
    type: keyword
    example: Mountain View
  </definition>
  <definition term="x509.issuer.organization">
    List of organizations (O) of issuing certificate authority.
    type: keyword
    example: Example Inc
  </definition>
  <definition term="x509.issuer.organizational_unit">
    List of organizational units (OU) of issuing certificate authority.
    type: keyword
    example: www.example.com
  </definition>
  <definition term="x509.issuer.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="x509.not_after">
    Time at which the certificate is no longer considered valid.
    type: date
    example: 2020-07-16 03:15:39+00:00
  </definition>
  <definition term="x509.not_before">
    Time at which the certificate is first considered valid.
    type: date
    example: 2019-08-16 01:40:25+00:00
  </definition>
  <definition term="x509.public_key_algorithm">
    Algorithm used to generate the public key.
    type: keyword
    example: RSA
  </definition>
  <definition term="x509.public_key_curve">
    The curve used by the elliptic curve public key algorithm. This is algorithm specific.
    type: keyword
    example: nistp521
  </definition>
  <definition term="x509.public_key_exponent">
    Exponent used to derive the public key. This is algorithm specific.
    type: long
    example: 65537
  </definition>
</definitions>

Field is not indexed.
<definitions>
  <definition term="x509.public_key_size">
    The size of the public key space in bits.
    type: long
    example: 2048
  </definition>
  <definition term="x509.serial_number">
    Unique serial number issued by the certificate authority. For consistency, if this value is alphanumeric, it should be formatted without colons and uppercase characters.
    type: keyword
    example: 55FBB9C7DEBF09809D12CCAA
  </definition>
  <definition term="x509.signature_algorithm">
    Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See [https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353](https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353).
    type: keyword
    example: SHA256-RSA
  </definition>
  <definition term="x509.subject.common_name">
    List of common names (CN) of subject.
    type: keyword
    example: shared.global.example.net
  </definition>
  <definition term="x509.subject.country">
    List of country (C) code
    type: keyword
    example: US
  </definition>
  <definition term="x509.subject.distinguished_name">
    Distinguished name (DN) of the certificate subject entity.
    type: keyword
    example: C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net
  </definition>
  <definition term="x509.subject.locality">
    List of locality names (L)
    type: keyword
    example: San Francisco
  </definition>
  <definition term="x509.subject.organization">
    List of organizations (O) of subject.
    type: keyword
    example: Example, Inc.
  </definition>
  <definition term="x509.subject.organizational_unit">
    List of organizational units (OU) of subject.
    type: keyword
  </definition>
  <definition term="x509.subject.state_or_province">
    List of state or province names (ST, S, or P)
    type: keyword
    example: California
  </definition>
  <definition term="x509.version_number">
    Version of x509 format.
    type: keyword
    example: 3
  </definition>
</definitions>