﻿---
title: Common fields
description: These fields contain data about the environment in which the transaction or flow was captured. 
url: https://www.elastic.co/docs/reference/beats/packetbeat/exported-fields-common
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Common fields
These fields contain data about the environment in which the transaction or flow was captured.
<definitions>
  <definition term="type">
    The type of the transaction (for example, HTTP, MySQL, Redis, or RUM) or "flow" in case of flows.
    required: True
  </definition>
  <definition term="server.process.name">
    The name of the process that served the transaction.
  </definition>
  <definition term="server.process.args">
    The command-line of the process that served the transaction.
  </definition>
  <definition term="server.process.executable">
    Absolute path to the server process executable.
  </definition>
  <definition term="server.process.working_directory">
    The working directory of the server process.
  </definition>
  <definition term="server.process.start">
    The time the server process started.
  </definition>
  <definition term="client.process.name">
    The name of the process that initiated the transaction.
  </definition>
  <definition term="client.process.args">
    The command-line of the process that initiated the transaction.
  </definition>
  <definition term="client.process.executable">
    Absolute path to the client process executable.
  </definition>
  <definition term="client.process.working_directory">
    The working directory of the client process.
  </definition>
  <definition term="client.process.start">
    The time the client process started.
  </definition>
  <definition term="real_ip">
    If the server initiating the transaction is a proxy, this field contains the original client IP address. For HTTP, for example, the IP address extracted from a configurable HTTP header, by default `X-Forwarded-For`. Unless this field is disabled, it always has a value, and it matches the `client_ip` for non proxy clients.
    type: alias
    alias to: network.forwarded_ip
  </definition>
  <definition term="transport">
    The transport protocol used for the transaction. If not specified, then tcp is assumed.
    type: alias
    alias to: network.transport
  </definition>
</definitions>