﻿---
title: AMQP fields
description: AMQP specific event fields. 
url: https://www.elastic.co/docs/reference/beats/packetbeat/exported-fields-amqp
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# AMQP fields
AMQP specific event fields.
<definitions>
  <definition term="amqp.reply-code">
    AMQP reply code to an error, similar to http reply-code
    type: long
    example: 404
  </definition>
  <definition term="amqp.reply-text">
    Text explaining the error.
    type: keyword
  </definition>
  <definition term="amqp.class-id">
    Failing method class.
    type: long
  </definition>
  <definition term="amqp.method-id">
    Failing method ID.
    type: long
  </definition>
  <definition term="amqp.exchange">
    Name of the exchange.
    type: keyword
  </definition>
  <definition term="amqp.exchange-type">
    Exchange type.
    type: keyword
    example: fanout
  </definition>
  <definition term="amqp.passive">
    If set, do not create exchange/queue.
    type: boolean
  </definition>
  <definition term="amqp.durable">
    If set, request a durable exchange/queue.
    type: boolean
  </definition>
  <definition term="amqp.exclusive">
    If set, request an exclusive queue.
    type: boolean
  </definition>
  <definition term="amqp.auto-delete">
    If set, auto-delete queue when unused.
    type: boolean
  </definition>
  <definition term="amqp.no-wait">
    If set, the server will not respond to the method.
    type: boolean
  </definition>
  <definition term="amqp.consumer-tag">
    Identifier for the consumer, valid within the current channel.
  </definition>
  <definition term="amqp.delivery-tag">
    The server-assigned and channel-specific delivery tag.
    type: long
  </definition>
  <definition term="amqp.message-count">
    The number of messages in the queue, which will be zero for newly-declared queues.
    type: long
  </definition>
  <definition term="amqp.consumer-count">
    The number of consumers of a queue.
    type: long
  </definition>
  <definition term="amqp.routing-key">
    Message routing key.
    type: keyword
  </definition>
  <definition term="amqp.no-ack">
    If set, the server does not expect acknowledgements for messages.
    type: boolean
  </definition>
  <definition term="amqp.no-local">
    If set, the server will not send messages to the connection that published them.
    type: boolean
  </definition>
  <definition term="amqp.if-unused">
    Delete only if unused.
    type: boolean
  </definition>
  <definition term="amqp.if-empty">
    Delete only if empty.
    type: boolean
  </definition>
  <definition term="amqp.queue">
    The queue name identifies the queue within the vhost.
    type: keyword
  </definition>
  <definition term="amqp.redelivered">
    Indicates that the message has been previously delivered to this or another client.
    type: boolean
  </definition>
  <definition term="amqp.multiple">
    Acknowledge multiple messages.
    type: boolean
  </definition>
  <definition term="amqp.arguments">
    Optional additional arguments passed to some methods. Can be of various types.
    type: object
  </definition>
  <definition term="amqp.mandatory">
    Indicates mandatory routing.
    type: boolean
  </definition>
  <definition term="amqp.immediate">
    Request immediate delivery.
    type: boolean
  </definition>
  <definition term="amqp.content-type">
    MIME content type.
    type: keyword
    example: text/plain
  </definition>
  <definition term="amqp.content-encoding">
    MIME content encoding.
    type: keyword
  </definition>
  <definition term="amqp.headers">
    Message header field table.
    type: object
  </definition>
  <definition term="amqp.delivery-mode">
    Non-persistent (1) or persistent (2).
    type: keyword
  </definition>
  <definition term="amqp.priority">
    Message priority, 0 to 9.
    type: long
  </definition>
  <definition term="amqp.correlation-id">
    Application correlation identifier.
    type: keyword
  </definition>
  <definition term="amqp.reply-to">
    Address to reply to.
    type: keyword
  </definition>
  <definition term="amqp.expiration">
    Message expiration specification.
    type: keyword
  </definition>
  <definition term="amqp.message-id">
    Application message identifier.
    type: keyword
  </definition>
  <definition term="amqp.timestamp">
    Message timestamp.
    type: keyword
  </definition>
  <definition term="amqp.type">
    Message type name.
    type: keyword
  </definition>
  <definition term="amqp.user-id">
    Creating user id.
    type: keyword
  </definition>
  <definition term="amqp.app-id">
    Creating application id.
    type: keyword
  </definition>
</definitions>