﻿---
title: Configure the Elasticsearch output
description: The Elasticsearch output sends events directly to Elasticsearch using the Elasticsearch HTTP API. Example configuration: When sending data to a secured...
url: https://www.elastic.co/docs/reference/beats/packetbeat/elasticsearch-output
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure the Elasticsearch output
The Elasticsearch output sends events directly to Elasticsearch using the Elasticsearch HTTP API.
Example configuration:
```yaml
output.elasticsearch:
  hosts: ["https://myEShost:9200"] 
```

When sending data to a secured cluster through the `elasticsearch` output, Packetbeat can use any of the following authentication methods:
- Basic authentication credentials (username and password).
- Token-based (API key) authentication.
- Public Key Infrastructure (PKI) certificates.

**Basic authentication:**
```yaml
output.elasticsearch:
  hosts: ["https://myEShost:9200"]
  username: "packetbeat_writer"
  password: "YOUR_PASSWORD"
```

**API key authentication:**
```yaml
output.elasticsearch:
  hosts: ["https://myEShost:9200"]
  api_key: "ZCV7VnwBgnX0T19fN8Qe:KnR6yE41RrSowb0kQ0HWoA"
```

**PKI certificate authentication:**
```yaml
output.elasticsearch:
  hosts: ["https://myEShost:9200"]
  ssl.certificate: "/etc/pki/client/cert.pem"
  ssl.key: "/etc/pki/client/cert.key"
```

See [*Secure communication with Elasticsearch*](https://www.elastic.co/docs/reference/beats/packetbeat/securing-communication-elasticsearch) for details on each authentication method.

## Compatibility

This output works with all compatible versions of Elasticsearch. See the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_compatibility).
Optionally, you can set Packetbeat to only connect to instances that are at least on the same version as the Beat. The check can be enabled by setting `output.elasticsearch.allow_older_versions` to `false`. Leaving the setting at it’s default value of `true` avoids an issue where Packetbeat cannot connect to Elasticsearch after having been upgraded to a version higher than the Elastic Stack.

## Configuration options

You can specify the following options in the `elasticsearch` section of the `packetbeat.yml` config file:

### `enabled`

The enabled config is a boolean setting to enable or disable the output. If set to `false`, the output is disabled.
The default value is `true`.

### `hosts`

The list of Elasticsearch nodes to connect to. The events are distributed to these nodes in round robin order. If one node becomes unreachable, the event is automatically sent to another node. Each Elasticsearch node can be defined as a `URL` or `IP:PORT`. For example: `http://192.15.3.2`, `https://es.found.io:9230` or `192.24.3.2:9300`. If no port is specified, `9200` is used.
<note>
  When a node is defined as an `IP:PORT`, the *scheme* and *path* are taken from the [`protocol`](#protocol-option) and [`path`](#path-option) config options.
</note>

<warning>
  All configured hosts must belong to the same Elasticsearch cluster; using nodes from different clusters may result in split or inconsistent data.
</warning>

```yaml
output.elasticsearch:
  hosts: ["10.45.3.2:9220", "10.45.3.1:9230"] 
  protocol: https
  path: /elasticsearch
```


### `compression_level`

The gzip compression level. Setting this value to `0` disables compression. The compression level must be in the range of `1` (best speed) to `9` (best compression).
Increasing the compression level will reduce the network usage but will increase the cpu usage.
The default value is `1`.

### `escape_html`

Configure escaping of HTML in strings. Set to `true` to enable escaping.
The default value is `false`.

### `worker` or `workers`

`worker` or `workers` specifies the number of connections created per host for publishing events.
Refer to the `loadblance` setting for details about how the load balancing works to distribute requests across the Elasticsearch cluster nodes.
The default value is `1`.

### `loadbalance`

When `loadbalance: true` is set, Packetbeat connects to all configured hosts and sends data through all connections in parallel. If a connection fails, data is sent to the remaining hosts until it can be reestablished. Data will still be sent as long as Packetbeat can connect to at least one of its configured hosts.
Use the `worker` or `workers` setting to specify the number of connections per host.
When `loadbalance: false` is set, Packetbeat sends data to a single host at a time. The target host is chosen at random from the list of configured hosts, and all data is sent to that target until the connection fails, when a new target is selected. Data will still be sent as long as Packetbeat can connect to at least one of its configured hosts.
The default value is `true`.
```yaml
output.elasticsearch:
  hosts: ["localhost:9200", "localhost:9201"]
  loadbalance: true
```


### `api_key`

Instead of using a username and password, you can use API keys to secure communication with Elasticsearch. The value must be the ID of the API key and the API key joined by a colon: `id:api_key`.
See [*Grant access using API keys*](https://www.elastic.co/docs/reference/beats/packetbeat/beats-api-keys) for more information.

### `username`

The basic authentication username for connecting to Elasticsearch.
This user needs the privileges required to publish events to Elasticsearch. To create a user like this, see [Create a *publishing* user](https://www.elastic.co/docs/reference/beats/packetbeat/privileges-to-publish-events).

### `password`

The basic authentication password for connecting to Elasticsearch.

### `parameters`

Dictionary of HTTP parameters to pass within the url with index operations.

### `protocol`

The name of the protocol Elasticsearch is reachable on. The options are: `http` or `https`. The default is `http`. However, if you specify a URL for [`hosts`](#hosts-option), the value of `protocol` is overridden by whatever scheme you specify in the URL.

### `path`

An HTTP path prefix that is prepended to the HTTP API calls. This is useful for the cases where Elasticsearch listens behind an HTTP reverse proxy that exports the API under a custom prefix.

### `headers`

Custom HTTP headers to add to each request created by the Elasticsearch output. Example:
```yaml
output.elasticsearch.headers:
  X-My-Header: Header contents
```

It is possible to specify multiple header values for the same header name by separating them with a comma.

### `proxy_disable`

If set to `true` all proxy settings, including `HTTP_PROXY` and `HTTPS_PROXY` variables are ignored.

### `proxy_url`

The URL of the proxy to use when connecting to the Elasticsearch servers. The value must be a complete URL. If a value is not specified through the configuration file then proxy environment variables are used. See the [Go documentation](https://golang.org/pkg/net/http/#ProxyFromEnvironment) for more information about the environment variables.

### `proxy_headers`

Additional headers to send to proxies during CONNECT requests.

### `index`

The indexing target to write events to. Can point to an [index](https://www.elastic.co/guide/en/elasticsearch/reference/current/index-mgmt.html), [alias](https://www.elastic.co/docs/manage-data/data-store/aliases), or [data stream](https://www.elastic.co/docs/manage-data/data-store/data-streams). When using daily indices, this will be the index name. The default is `"packetbeat-%{[agent.version]}-%{+yyyy.MM.dd}"`, for example, `"packetbeat-[version]-2025-01-30"`. If you change this setting, you also need to configure the `setup.template.name` and `setup.template.pattern` options (see [Elasticsearch index template](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-template)).
If you are using the pre-built Kibana dashboards, you also need to set the `setup.dashboards.index` option (see [Kibana dashboards](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-dashboards)).
When [index lifecycle management (ILM)](https://www.elastic.co/docs/reference/beats/packetbeat/ilm) is enabled, the default `index` is `"packetbeat-%{[agent.version]}-%{+yyyy.MM.dd}-%{{index_num}}"`, for example, `"packetbeat-[version]-2025-01-30-000001"`. Custom `index` settings are ignored when ILM is enabled. If you’re sending events to a cluster that supports index lifecycle management, see [Index lifecycle management (ILM)](https://www.elastic.co/docs/reference/beats/packetbeat/ilm) to learn how to change the index name.
You can set the index dynamically by using a format string to access any event field. For example, this configuration uses a custom field, `fields.log_type`, to set the index:
```yaml
output.elasticsearch:
  hosts: ["http://localhost:9200"]
  index: "%{[fields.log_type]}-%{[agent.version]}-%{+yyyy.MM.dd}" 
```

With this configuration, all events with `log_type: normal` are sent to an index named `normal-[version]-2025-01-30`, and all events with `log_type: critical` are sent to an index named `critical-[version]-2025-01-30`.
<tip>
  To learn how to add custom fields to events, see the [`fields`](/docs/reference/beats/packetbeat/configuration-general-options#libbeat-configuration-fields) option.
</tip>

See the [`indices`](#indices-option-es) setting for other ways to set the index dynamically.

### `indices`

An array of index selector rules. Each rule specifies the index to use for events that match the rule. During publishing, Packetbeat uses the first matching rule in the array. Rules can contain conditionals, format string-based fields, and name mappings. If the `indices` setting is missing or no rule matches, the [`index`](#index-option-es) setting is used.
Similar to `index`, defining custom `indices` will disable [Index lifecycle management (ILM)](https://www.elastic.co/docs/reference/beats/packetbeat/ilm).
Rule settings:
<definitions>
  <definition term="index">
    The index format string to use. If this string contains field references, such as `%{[fields.name]}`, the fields must exist, or the rule fails.
  </definition>
  <definition term="mappings">
    A dictionary that takes the value returned by `index` and maps it to a new name.
  </definition>
  <definition term="default">
    The default string value to use if `mappings` does not find a match.
  </definition>
  <definition term="when">
    A condition that must succeed in order to execute the current rule. All the [conditions](/docs/reference/beats/packetbeat/defining-processors#conditions) supported by processors are also supported here.
  </definition>
</definitions>

The following example sets the index based on whether the `message` field contains the specified string:
```yaml
output.elasticsearch:
  hosts: ["http://localhost:9200"]
  indices:
    - index: "warning-%{[agent.version]}-%{+yyyy.MM.dd}"
      when.contains:
        message: "WARN"
    - index: "error-%{[agent.version]}-%{+yyyy.MM.dd}"
      when.contains:
        message: "ERR"
```

This configuration results in indices named `warning-[version]-2025-01-30` and `error-[version]-2025-01-30` (plus the default index if no matches are found).
The following example sets the index by taking the name returned by the `index` format string and mapping it to a new name that’s used for the index:
```yaml
output.elasticsearch:
  hosts: ["http://localhost:9200"]
  indices:
    - index: "%{[fields.log_type]}"
      mappings:
        critical: "sev1"
        normal: "sev2"
      default: "sev3"
```

This configuration results in indices named `sev1`, `sev2`, and `sev3`.
The `mappings` setting simplifies the configuration, but is limited to string values. You cannot specify format strings within the mapping pairs.

### `ilm`

Configuration options for index lifecycle management.
See [Index lifecycle management (ILM)](https://www.elastic.co/docs/reference/beats/packetbeat/ilm) for more information.

### `pipeline`

A format string value that specifies the ingest pipeline to write events to.
```yaml
output.elasticsearch:
  hosts: ["http://localhost:9200"]
  pipeline: my_pipeline_id
```

<important>
  The `pipeline` is always lowercased. If `pipeline: Foo-Bar`, then the pipeline name in Elasticsearch needs to be defined as `foo-bar`.
</important>

For more information, see [*Parse data using an ingest pipeline*](https://www.elastic.co/docs/reference/beats/packetbeat/configuring-ingest-node).
You can set the ingest pipeline dynamically by using a format string to access any event field. For example, this configuration uses a custom field, `fields.log_type`, to set the pipeline for each event:
```yaml
output.elasticsearch:
  hosts: ["http://localhost:9200"]
  pipeline: "%{[fields.log_type]}_pipeline"
```

With this configuration, all events with `log_type: normal` are sent to a pipeline named `normal_pipeline`, and all events with `log_type: critical` are sent to a pipeline named `critical_pipeline`.
<tip>
  To learn how to add custom fields to events, see the [`fields`](/docs/reference/beats/packetbeat/configuration-general-options#libbeat-configuration-fields) option.
</tip>

See the [`pipelines`](#pipelines-option-es) setting for other ways to set the ingest pipeline dynamically.

### `pipelines`

An array of pipeline selector rules. Each rule specifies the ingest pipeline to use for events that match the rule. During publishing, Packetbeat uses the first matching rule in the array. Rules can contain conditionals, format string-based fields, and name mappings. If the `pipelines` setting is missing or no rule matches, the [`pipeline`](#pipeline-option-es) setting is used.
Rule settings:
<definitions>
  <definition term="pipeline">
    The pipeline format string to use. If this string contains field references, such as `%{[fields.name]}`, the fields must exist, or the rule fails.
  </definition>
  <definition term="mappings">
    A dictionary that takes the value returned by `pipeline` and maps it to a new name.
  </definition>
  <definition term="default">
    The default string value to use if `mappings` does not find a match.
  </definition>
  <definition term="when">
    A condition that must succeed in order to execute the current rule. All the [conditions](/docs/reference/beats/packetbeat/defining-processors#conditions) supported by processors are also supported here.
  </definition>
</definitions>

The following example sends events to a specific pipeline based on whether the `message` field contains the specified string:
```yaml
output.elasticsearch:
  hosts: ["http://localhost:9200"]
  pipelines:
    - pipeline: "warning_pipeline"
      when.contains:
        message: "WARN"
    - pipeline: "error_pipeline"
      when.contains:
        message: "ERR"
```

The following example sets the pipeline by taking the name returned by the `pipeline` format string and mapping it to a new name that’s used for the pipeline:
```yaml
output.elasticsearch:
  hosts: ["http://localhost:9200"]
  pipelines:
    - pipeline: "%{[fields.log_type]}"
      mappings:
        critical: "sev1_pipeline"
        normal: "sev2_pipeline"
      default: "sev3_pipeline"
```

With this configuration, all events with `log_type: critical` are sent to `sev1_pipeline`, all events with `log_type: normal` are sent to a `sev2_pipeline`, and all other events are sent to `sev3_pipeline`.
For more information about ingest pipelines, see [*Parse data using an ingest pipeline*](https://www.elastic.co/docs/reference/beats/packetbeat/configuring-ingest-node).

### `max_retries`

The number of times to retry publishing an event after a publishing failure. After the specified number of retries, the events are typically dropped.
Set `max_retries` to a value less than 0 to retry until all events are published.
The default is 3.

### `bulk_max_size`

The maximum number of events to bulk in a single Elasticsearch bulk API index request. The default is 1600.
Events can be collected into batches. Packetbeat will split batches read from the queue which are larger than `bulk_max_size` into multiple batches.
Specifying a larger batch size can improve performance by lowering the overhead of sending events. However big batch sizes can also increase processing times, which might result in API errors, killed connections, timed-out publishing requests, and, ultimately, lower throughput.
Setting `bulk_max_size` to values less than or equal to 0 disables the splitting of batches. When splitting is disabled, the queue decides on the number of events to be contained in a batch.

### `backoff.init`

The number of seconds to wait before trying to reconnect to Elasticsearch after a network error. After waiting `backoff.init` seconds, Packetbeat tries to reconnect. If the attempt fails, the backoff timer is increased exponentially up to `backoff.max`. After a successful connection, the backoff timer is reset. The default is `1s`.

### `backoff.max`

The maximum number of seconds to wait before attempting to connect to Elasticsearch after a network error. The default is `60s`.

### `idle_connection_timeout`

The maximum amount of time an idle connection will remain idle before closing itself. Zero means no limit. The format is a Go language duration (example 60s is 60 seconds). The default is 3s.

### `timeout`

The http request timeout in seconds for the Elasticsearch request. The default is 90.

### `allow_older_versions`

By default, Packetbeat expects the Elasticsearch instance to be on the same or newer version to provide optimal experience. We suggest you connect to the same version to make sure all features Packetbeat is using are available in your Elasticsearch instance.
You can disable the check for example during updating the Elastic Stack, so data collection can go on.

### `ssl`

Configuration options for SSL parameters like the certificate authority to use for HTTPS-based connections. If the `ssl` section is missing, the host CAs are used for HTTPS connections to Elasticsearch.
See the [secure communication with Elasticsearch](https://www.elastic.co/docs/reference/beats/packetbeat/securing-communication-elasticsearch) guide or [SSL configuration reference](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-ssl) for more information.

### `kerberos`

Configuration options for Kerberos authentication.
See [Kerberos](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-kerberos) for more information.

### `queue`

Configuration options for internal queue.
See [Internal queue](https://www.elastic.co/docs/reference/beats/packetbeat/configuring-internal-queue) for more information.
Note:`queue` options can be set under `packetbeat.yml` or the `output` section but not both.

### `non_indexable_policy`

Specifies the behavior when the elasticsearch cluster explicitly rejects documents, for example on mapping conflicts.

#### `drop`

The default behaviour, when an event is explicitly rejected by elasticsearch it is dropped.
```yaml
output.elasticsearch:
  hosts: ["http://localhost:9200"]
  non_indexable_policy.drop: ~
```


#### `dead_letter_index`

<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

On an explicit rejection, this policy will retry the event in the next batch. However, the target index will change to index specified. In addition, the structure of the event will be change to the following fields:
<definitions>
  <definition term="message">
    Contains the escaped json of the original event.
  </definition>
  <definition term="error.type">
    Contains the status code
  </definition>
  <definition term="error.message">
    Contains status returned by elasticsearch, describing the reason
  </definition>
  <definition term="index">
    The index to send rejected events to.
  </definition>
</definitions>

```yaml
output.elasticsearch:
  hosts: ["http://localhost:9200"]
  non_indexable_policy.dead_letter_index:
    index: "my-dead-letter-index"
```


### `preset`

The performance preset to apply to the output configuration.
```yaml
output.elasticsearch:
  hosts: ["http://localhost:9200"]
  preset: balanced
```

Performance presets apply a set of configuration overrides based on a desired performance goal. If set, a performance preset will override other configuration flags to match the recommended settings for that preset. If a preset doesn’t set a value for a particular field, the user-specified value will be used if present, otherwise the default. Valid options are:
- `balanced`: good starting point for general efficiency
- `throughput`: good for high data volumes, may increase cpu and memory requirements
- `scale`: reduces ambient resource use in large low-throughput deployments
- `latency`: minimize the time for fresh data to become visible in Elasticsearch
- `custom`: apply user configuration directly with no overrides

The default if unspecified is `custom`.
Presets represent current recommendations based on the intended goal; their effect may change between versions to better suit those goals. Currently the presets have the following effects:

| preset                                                                                                                        | balanced | throughput | scale  | latency |
|-------------------------------------------------------------------------------------------------------------------------------|----------|------------|--------|---------|
| [`bulk_max_size`](#bulk-max-size-option)                                                                                      | 1600     | 1600       | 1600   | 50      |
| [`worker`](#worker-option)                                                                                                    | 1        | 4          | 1      | 1       |
| [`queue.mem.events`](/docs/reference/beats/packetbeat/configuring-internal-queue#queue-mem-events-option)                     | 3200     | 12800      | 3200   | 4100    |
| [`queue.mem.flush.min_events`](/docs/reference/beats/packetbeat/configuring-internal-queue#queue-mem-flush-min-events-option) | 1600     | 1600       | 1600   | 2050    |
| [`queue.mem.flush.timeout`](/docs/reference/beats/packetbeat/configuring-internal-queue#queue-mem-flush-timeout-option)       | `10s`    | `5s`       | `20s`  | `1s`    |
| [`compression_level`](#compression-level-option)                                                                              | 1        | 1          | 1      | 1       |
| [`idle_connection_timeout`](#idle-connection-timeout-option)                                                                  | `3s`     | `15s`      | `1s`   | `60s`   |
| [`backoff.init`](#backoff-init-option)                                                                                        | none     | none       | `5s`   | none    |
| [`backoff.max`](#backoff-max-option)                                                                                          | none     | none       | `300s` | none    |


## Elasticsearch APIs

Packetbeat will use the `_bulk` API from Elasticsearch, the events are sent in the order they arrive to the publishing pipeline, a single `_bulk` request may contain events from different inputs/modules. Temporary failures are re-tried.
The status code for each event is checked and handled as:
- `< 300`: The event is counted as `events.acked`
- `409` (Conflict): The event is counted as `events.duplicates`
- `429` (Too Many Requests): The event is counted as `events.toomany`
- `> 399 and < 500`: The `non_indexable_policy` is applied.