﻿---
title: Configure the Discard output
description: The Discard output throws away data. This can be useful if you want to work on your input configuration without needing to configure an output. It can...
url: https://www.elastic.co/docs/reference/beats/packetbeat/discard-output
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure the Discard output
The Discard output throws away data.
<warning>
  The Discard output should be used only for development or debugging issues. Data is lost.
</warning>

This can be useful if you want to work on your input configuration without needing to configure an output. It can also be useful to test how changes in input and processor configuration affect performance.
Example configuration:
```yaml
output.discard:
  enabled: true
```


## Configuration options

You can specify the following `output.discard` options in the `packetbeat.yml` config file:

### `enabled`

The enabled config is a boolean setting to enable or disable the output. If set to false, the output is disabled.
The default value is `true`.