﻿---
title: Directory layout
description: The directory layout of an installation is as follows: You can change these settings by using CLI flags or setting path options in the configuration file...
url: https://www.elastic.co/docs/reference/beats/packetbeat/directory-layout
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Directory layout
The directory layout of an installation is as follows:
<tip>
  Archive installation has a different layout. See [zip, tar.gz, or tgz](#directory-layout-archive).
</tip>


| Type   | Description                                      | Default Location   | Config Option |
|--------|--------------------------------------------------|--------------------|---------------|
| home   | Home of the Packetbeat installation.             |                    | `path.home`   |
| bin    | The location for the binary files.               | `{path.home}/bin`  |               |
| config | The location for configuration files.            | `{path.home}`      | `path.config` |
| data   | The location for persistent data files.          | `{path.home}/data` | `path.data`   |
| logs   | The location for the logs created by Packetbeat. | `{path.home}/logs` | `path.logs`   |

You can change these settings by using CLI flags or setting [path options](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-path) in the configuration file.

## Default paths

Packetbeat uses the following default paths unless you explicitly change them.

#### deb and rpm


| Type   | Description                                      | Location                    |
|--------|--------------------------------------------------|-----------------------------|
| home   | Home of the Packetbeat installation.             | `/usr/share/packetbeat`     |
| bin    | The location for the binary files.               | `/usr/share/packetbeat/bin` |
| config | The location for configuration files.            | `/etc/packetbeat`           |
| data   | The location for persistent data files.          | `/var/lib/packetbeat`       |
| logs   | The location for the logs created by Packetbeat. | `/var/log/packetbeat`       |

For the deb and rpm distributions, these paths are set in the init script or in the systemd unit file.  Make sure that you start the Packetbeat service by using the preferred operating system method (init scripts or `systemctl`). Otherwise the paths might be set incorrectly.

#### docker


| Type   | Description                                      | Location                     |
|--------|--------------------------------------------------|------------------------------|
| home   | Home of the Packetbeat installation.             | `/usr/share/packetbeat`      |
| bin    | The location for the binary files.               | `/usr/share/packetbeat`      |
| config | The location for configuration files.            | `/usr/share/packetbeat`      |
| data   | The location for persistent data files.          | `/usr/share/packetbeat/data` |
| logs   | The location for the logs created by Packetbeat. | `/usr/share/packetbeat/logs` |


#### zip, tar.gz, or tgz


| Type   | Description                                      | Location              |
|--------|--------------------------------------------------|-----------------------|
| home   | Home of the Packetbeat installation.             | `{extract.path}`      |
| bin    | The location for the binary files.               | `{extract.path}`      |
| config | The location for configuration files.            | `{extract.path}`      |
| data   | The location for persistent data files.          | `{extract.path}/data` |
| logs   | The location for the logs created by Packetbeat. | `{extract.path}/logs` |

For the zip, tar.gz, or tgz distributions, these paths are based on the location of the extracted binary file. This means that if you start Packetbeat with the following simple command, all paths are set correctly:
```sh
./packetbeat
```