﻿---
title: Configure Packetbeat
description: To configure Packetbeat, edit the configuration file. The default configuration file is called  packetbeat.yml. The location of the file varies by platform...
url: https://www.elastic.co/docs/reference/beats/packetbeat/configuring-howto-packetbeat
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure Packetbeat
<tip>
  To get started quickly, read [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/packetbeat/packetbeat-installation-configuration).
</tip>

To configure Packetbeat, edit the configuration file. The default configuration file is called  `packetbeat.yml`. The location of the file varies by platform. To locate the file, see [Directory layout](https://www.elastic.co/docs/reference/beats/packetbeat/directory-layout).
There’s also a full example configuration file called `packetbeat.reference.yml` that shows all non-deprecated options.
<tip>
  See the [Config File Format](https://www.elastic.co/docs/reference/beats/libbeat/config-file-format) for more about the structure of the config file.
</tip>

The following topics describe how to configure Packetbeat:
- [Network flows](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-flows)
- [Protocols](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-protocols)
- [Processes](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-processes)
- [General settings](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-general-options)
- [Project paths](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-path)
- [Traffic sniffing](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-interfaces)
- [Output](https://www.elastic.co/docs/reference/beats/packetbeat/configuring-output)
- [SSL](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-ssl)
- [Index lifecycle management (ILM)](https://www.elastic.co/docs/reference/beats/packetbeat/ilm)
- [Elasticsearch index template](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-template)
- [Kibana endpoint](https://www.elastic.co/docs/reference/beats/packetbeat/setup-kibana-endpoint)
- [Kibana dashboards](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-dashboards)
- [Processors](https://www.elastic.co/docs/reference/beats/packetbeat/filtering-enhancing-data)
- [Internal queue](https://www.elastic.co/docs/reference/beats/packetbeat/configuring-internal-queue)
- [Logging](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-logging)
- [HTTP endpoint](https://www.elastic.co/docs/reference/beats/packetbeat/http-endpoint)
- [Instrumentation](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-instrumentation)
- [Feature flags](https://www.elastic.co/docs/reference/beats/packetbeat/configuration-feature-flags)
- [*packetbeat.reference.yml*](https://www.elastic.co/docs/reference/beats/packetbeat/packetbeat-reference-yml)