﻿---
title: Configure the output for Elastic Cloud Hosted
description: Packetbeat comes with two settings that simplify the output configuration when used together with Elastic Cloud Hosted. When defined, these setting overwrite...
url: https://www.elastic.co/docs/reference/beats/packetbeat/configure-cloud-id
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure the output for Elastic Cloud Hosted
Packetbeat comes with two settings that simplify the output configuration when used together with [Elastic Cloud Hosted](https://www.elastic.co/cloud?page=docs&placement=docs-body). When defined, these setting overwrite settings from other parts in the configuration.
Example:
```yaml
cloud.id: "staging:dXMtZWFzdC0xLmF3cy5mb3VuZC5pbyRjZWM2ZjI2MWE3NGJmMjRjZTMzYmI4ODExYjg0Mjk0ZiRjNmMyY2E2ZDA0MjI0OWFmMGNjN2Q3YTllOTYyNTc0Mw=="
cloud.auth: "elastic:YOUR_PASSWORD"
```

These settings can be also specified at the command line, like this:
```sh
packetbeat -e -E cloud.id="<cloud-id>" -E cloud.auth="<cloud.auth>"
```


## `cloud.id`

The Cloud ID, which can be found in the [Elastic Cloud console](https://cloud.elastic.co/?page=docs&placement=docs-body), is used by Packetbeat to resolve the Elasticsearch and Kibana URLs. This setting overwrites the `output.elasticsearch.hosts` and `setup.kibana.host` settings. For more on locating and configuring the Cloud ID, see [Find your Cloud ID](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/find-cloud-id).

## `cloud.auth`

<important>
  `cloud.auth` should not be confused with API keys generated in Elastic Cloud stack management. Although these values look similar, they are unrelated.
</important>

When specified, the `cloud.auth` overwrites the `output.elasticsearch.username` and `output.elasticsearch.password` settings. Because the Kibana settings inherit the username and password from the Elasticsearch output, this can also be used to set the `setup.kibana.username` and `setup.kibana.password` options.