﻿---
title: Configure general settings
description: You can specify settings in the packetbeat.yml config file to control the general behavior of Packetbeat. These options are supported by all Elastic Beats...
url: https://www.elastic.co/docs/reference/beats/packetbeat/configuration-general-options
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure general settings
You can specify settings in the `packetbeat.yml` config file to control the general behavior of Packetbeat.

## General configuration options

These options are supported by all Elastic Beats. Because they are common options, they are not namespaced.
Here is an example configuration:
```yaml
name: "my-shipper"
tags: ["service-X", "web-tier"]
```


### `name`

The name of the Beat. If this option is empty, the `hostname` of the server is used. The name is included as the `agent.name` field in each published transaction. You can use the name to group all transactions sent by a single Beat.
Example:
```yaml
name: "my-shipper"
```


### `tags`

A list of tags that the Beat includes in the `tags` field of each published transaction. Tags make it easy to group servers by different logical properties. For example, if you have a cluster of web servers, you can add the "webservers" tag to the Beat on each server, and then use filters and queries in the Kibana web interface to get visualisations for the whole group of servers.
Example:
```yaml
tags: ["my-service", "hardware", "test"]
```


### `fields`

Optional fields that you can specify to add additional information to the output. Fields can be scalar values, arrays, dictionaries, or any nested combination of these. By default, the fields that you specify here will be grouped under a `fields` sub-dictionary in the output document. To store the custom fields as top-level fields, set the `fields_under_root` option to true.
Example:
```yaml
fields: {project: "myproject", instance-id: "574734885120952459"}
```


### `fields_under_root`

If this option is set to true, the custom [fields](#libbeat-configuration-fields) are stored as top-level fields in the output document instead of being grouped under a `fields` sub-dictionary. If the custom field names conflict with other field names, then the custom fields overwrite the other fields.
Example:
```yaml
fields_under_root: true
fields:
  instance_id: i-10a64379
  region: us-east-1
```


### `processors`

A list of processors to apply to the data generated by the beat.
See [Processors](https://www.elastic.co/docs/reference/beats/packetbeat/filtering-enhancing-data) for information about specifying processors in your config.

### `max_procs`

Sets the maximum number of CPUs that can be executing simultaneously. The default is the number of logical CPUs available in the system.

### `timestamp.precision`

Configure the precision of all timestamps. By default it is set to millisecond. Available options: millisecond, microsecond, nanosecond