﻿---
title: Capture Cassandra traffic
description: The following settings are specific to the Cassandra protocol. Here is a sample configuration for the cassandra section of the packetbeat.yml config file:...
url: https://www.elastic.co/docs/reference/beats/packetbeat/configuration-cassandra
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Generally available
---

# Capture Cassandra traffic
The following settings are specific to the Cassandra protocol. Here is a sample configuration for the `cassandra` section of the `packetbeat.yml` config file:
```yaml
packetbeat.protocols:
- type: cassandra
  send_request_header: true
  send_response_header: true
  compressor: "snappy"
  ignored_ops: ["SUPPORTED","OPTIONS"]
```


## Configuration options

Also see [Common protocol options](https://www.elastic.co/docs/reference/beats/packetbeat/common-protocol-options).

### `send_request_header`

If this option is enabled, the raw message of the response (`cassandra_request.request_headers` field) is sent to Elasticsearch. The default is true. enable `send_request` first before enable this option.

### `send_response_header`

If this option is enabled, the raw message of the response (`cassandra_response.response_headers` field) is included in published events. The default is true. enable `send_response` first before enable this option.

### `ignored_ops`

This option indicates which Operator/Operators captured will be ignored. currently support: `ERROR` ,`STARTUP` ,`READY` ,`AUTHENTICATE` ,`OPTIONS` ,`SUPPORTED` , `QUERY` ,`RESULT` ,`PREPARE` ,`EXECUTE` ,`REGISTER`  ,`EVENT` , `BATCH` ,`AUTH_CHALLENGE`,`AUTH_RESPONSE` ,`AUTH_SUCCESS` .

### `compressor`

Configures the default compression algorithm being used to uncompress compressed frames by name. Currently only `snappy` is can be configured. By default no compressor is configured.