﻿---
title: Add Nomad metadata
description: The add_nomad_metadata processor adds fields with relevant metadata for applications deployed in Nomad. Each event is annotated with the following information:...
url: https://www.elastic.co/docs/reference/beats/packetbeat/add-nomad-metadata
products:
  - Beats
  - Packetbeat
applies_to:
  - Elastic Stack: Preview
---

# Add Nomad metadata
<warning>
  This functionality is in technical preview and may be changed or removed in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.
</warning>

The `add_nomad_metadata` processor adds fields with relevant metadata for applications deployed in Nomad.
Each event is annotated with the following information:
- Allocation name, identifier and status.
- Job name and type.
- Namespace where the job is deployed.
- Datacenter and region where the agent running the allocation is located.

```yaml
processors:
  - add_nomad_metadata: ~
```

It has the following settings to configure the connection:
<definitions>
  <definition term="address">
    (Optional) The URL of the agent API used to request the metadata. It uses `http://127.0.0.1:4646` by default.
  </definition>
  <definition term="namespace">
    (Optional) Namespace to watch. If set, only events for allocations in this namespace will be annotated.
  </definition>
  <definition term="region">
    (Optional) Region to watch. If set, only events for allocations in this region will be annotated.
  </definition>
  <definition term="secret_id">
    (Optional) SecretID to use when connecting with the agent API. This is an example ACL policy to apply to the token.
  </definition>
</definitions>

```json
namespace "*" {
  policy = "read"
}
node {
  policy = "read"
}
agent {
  policy = "read"
}
```

<definitions>
  <definition term="refresh_interval">
    (Optional) Interval used to update the cached metadata. It defaults to 30 seconds.
  </definition>
  <definition term="cleanup_timeout">
    (Optional) After an allocation has been removed, time to wait before cleaning up their associated resources. This is useful if you expect to receive events after an allocation has been removed, which can happen when collecting logs. It defaults to 60 seconds.
  </definition>
</definitions>

You can decide if Packetbeat should annotate events related to allocations in local node or on the whole cluster configuring the scope with the following settings:
<definitions>
  <definition term="scope">
    (Optional) Scope of the resources to watch. It can be `node` to get metadata only for the allocations in a single agent, or `global`, to get metadata for allocations running on any agent. It defaults to `node`.
  </definition>
  <definition term="node">
    (Optional) When using `scope: node`, use `node` to specify the name of the local node if it cannot be discovered automatically.
  </definition>
</definitions>

For example the following configuration could be used if Packetbeat is collecting events from all the allocations in the cluster:
```yaml
processors:
  - add_nomad_metadata:
      scope: global
```


## Indexers and matchers

Indexers and matchers are used to correlate fields in events with actual metadata. Packetbeat uses this information to know what metadata to include in each event.

### Indexers

Indexers use allocation metadata to create unique identifiers for each one of the pods.
Avaliable indexers are:
<definitions>
  <definition term="allocation_name">
    Identifies allocations by its name and namespace (as `<namespace>/<name>`)
  </definition>
  <definition term="allocation_uuid">
    Identifies allocations by its unique identifier.
  </definition>
</definitions>


### Matchers

Matchers are used to construct the lookup keys that match with the identifiers created by indexes.

### `field_format`

Looks up allocation metadata using a key created with a string format that can include event fields.
This matcher has an option `format` to define the string format. This string format can contain placeholders for any field in the event.
For example, the following configuration uses the `allocation_name` indexer to identify the allocation metadata by its name and namespace, and uses custom fields existing in the event as match keys:
```yaml
processors:
- add_nomad_metadata:
    ...
    default_indexers.enabled: false
    default_matchers.enabled: false
    indexers:
      - allocation_name:
    matchers:
      - field_format:
          format: '%{[labels.nomad_namespace]}/%{[fields.nomad_alloc_name]}'
```


### `fields`

Looks up allocation metadata using as key the value of some specific fields. When multiple fields are defined, the first one included in the event is used.
This matcher has an option `lookup_fields` to define the fields whose value will be used for lookup.
For example, the following configuration uses the `allocation_uuid` indexer to identify allocations, and defines a matcher that uses some fields where the allocation UUID can be found for lookup, the first it finds in the event:
```yaml
processors:
- add_nomad_metadata:
    ...
    default_indexers.enabled: false
    default_matchers.enabled: false
    indexers:
      - allocation_uuid:
    matchers:
      - fields:
          lookup_fields: ['host.name', 'fields.nomad_alloc_uuid']
```