﻿---
title: Run Metricbeat on Docker
description: Docker images for Metricbeat are available from the Elastic Docker registry. The base image is Red Hat Universal Base Image 9 Minimal. A list of all published...
url: https://www.elastic.co/docs/reference/beats/metricbeat/running-on-docker
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Run Metricbeat on Docker
Docker images for Metricbeat are available from the Elastic Docker registry. The base image is [Red Hat Universal Base Image 9 Minimal](https://hub.docker.com/r/redhat/ubi9-minimal).
A list of all published Docker images and tags is available at [www.docker.elastic.co](https://www.docker.elastic.co).
These images are free to use under the Elastic license. They contain open source and free commercial features and access to paid commercial features. [Start a 30-day trial](https://www.elastic.co/docs/deploy-manage/license/manage-your-license-in-self-managed-cluster) to try out all of the paid commercial features. See the [Subscriptions](https://www.elastic.co/subscriptions) page for information about Elastic license levels.

## Pull the image

Obtaining Metricbeat for Docker is as simple as issuing a `docker pull` command against the Elastic Docker registry.
```sh
docker pull docker.elastic.co/beats/metricbeat:9.3.0
```

Alternatively, you can download other Docker images that contain only features available under the Apache 2.0 license. To download the images, go to [www.docker.elastic.co](https://www.docker.elastic.co).
As another option, you can use the hardened [Wolfi](https://wolfi.dev/) image. Using Wolfi images requires Docker version 20.10.10 or higher. For details about why the Wolfi images have been introduced, refer to our article [Reducing CVEs in Elastic container images](https://www.elastic.co/blog/reducing-cves-in-elastic-container-images).
```bash
docker pull docker.elastic.co/beats/metricbeat-wolfi:9.3.0
```


## Optional: Verify the image

You can use the [Cosign application](https://docs.sigstore.dev/cosign/installation/) to verify the Metricbeat Docker image signature.
```sh
wget https://artifacts.elastic.co/cosign.pub
cosign verify --key cosign.pub docker.elastic.co/beats/metricbeat:9.3.0
```

The `cosign` command prints the check results and the signature payload in JSON format:
```sh
Verification for docker.elastic.co/beats/metricbeat:9.3.0 --
The following checks were performed on each of these signatures:
  - The cosign claims were validated
  - Existence of the claims in the transparency log was verified offline
  - The signatures were verified against the specified public key
```


## Run the Metricbeat setup

<important>
  A [known issue](https://github.com/elastic/beats/issues/42038) in version 8.17.0 prevents Beats Docker images from starting when no options are provided. When running an image on that version, add an `--environment container` parameter to avoid the problem. This is planned to be addressed in issue [#42060](https://github.com/elastic/beats/pull/42060).
</important>

Running Metricbeat with the setup command will create the index pattern and load visualizations , dashboards, and machine learning jobs.  Run this command:
```sh
docker run --rm \
docker.elastic.co/beats/metricbeat:9.3.0 \
setup -E setup.kibana.host=kibana:5601 \
-E output.elasticsearch.hosts=["elasticsearch:9200"] 
```

```


## Run Metricbeat on a read-only file system [_run_metricbeat_on_a_read_only_file_system]

If you’d like to run Metricbeat in a Docker container on a read-only file system, you can do so by specifying the `--read-only` option. Metricbeat requires a stateful directory to store application data, so with the `--read-only` option you also need to use the `--mount` option to specify a path to where that data can be stored.

For example:

```sh subs=true
docker run --rm \
--mount type=bind,source=$(pwd)/data,destination=/usr/share/metricbeat/data \
--read-only \
docker.elastic.co/beats/metricbeat:{{version.stack}}
```


## Configure Metricbeat on Docker

The Docker image provides several methods for configuring Metricbeat. The conventional approach is to provide a configuration file via a volume mount, but it’s also possible to create a custom image with your configuration included.

### Example configuration file

Download this example configuration file as a starting point:
```sh
curl -L -O https://raw.githubusercontent.com/elastic/beats/9.3/deploy/docker/metricbeat.docker.yml
```


### Volume-mounted configuration

One way to configure Metricbeat on Docker is to provide `metricbeat.docker.yml` via a volume mount. With `docker run`, the volume mount can be specified like this.
```sh
docker run -d \
  --name=metricbeat \
  --user=root \
  --volume="$(pwd)/metricbeat.docker.yml:/usr/share/metricbeat/metricbeat.yml:ro" \
  --volume="/var/run/docker.sock:/var/run/docker.sock:ro" \
  --volume="/sys/fs/cgroup:/hostfs/sys/fs/cgroup:ro" \
  --volume="/proc:/hostfs/proc:ro" \
  --volume="/:/hostfs:ro" \
  docker.elastic.co/beats/metricbeat:9.3.0 metricbeat -e \
  -E output.elasticsearch.hosts=["elasticsearch:9200"] 
```


### Customize your configuration

The `metricbeat.docker.yml` file you downloaded earlier is configured to deploy Beats modules based on the Docker labels applied to your containers.  See [Hints based autodiscover](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-autodiscover-hints) for more details. Add labels to your application Docker containers, and they will be picked up by the Beats autodiscover feature when they are deployed.  Here is an example command for an Apache HTTP Server container with labels to configure the Filebeat and Metricbeat modules for the Apache HTTP Server:
```sh
docker run \
  --label co.elastic.logs/module=apache2 \
  --label co.elastic.logs/fileset.stdout=access \
  --label co.elastic.logs/fileset.stderr=error \
  --label co.elastic.metrics/module=apache \
  --label co.elastic.metrics/metricsets=status \
  --label co.elastic.metrics/hosts='${data.host}:${data.port}' \
  --detach=true \
  --name my-apache-app \
  -p 8080:80 \
  httpd:2.4
```


### Custom image configuration

It’s possible to embed your Metricbeat configuration in a custom image. Here is an example Dockerfile to achieve this:
```dockerfile
FROM docker.elastic.co/beats/metricbeat:9.3.0
COPY --chown=root:metricbeat metricbeat.yml /usr/share/metricbeat/metricbeat.yml
```


### Monitor the host machine

When executing Metricbeat in a container, there are some important things to be aware of if you want to monitor the host machine or other containers. Let’s walk-through some examples using Docker as our container orchestration tool.
This example highlights the changes required to make the system module work properly inside of a container. This enables Metricbeat to monitor the host machine from within the container.
```sh
docker run \
  --mount type=bind,source=/proc,target=/hostfs/proc,readonly \ 
  --mount type=bind,source=/sys/fs/cgroup,target=/hostfs/sys/fs/cgroup,readonly \ 
  --mount type=bind,source=/,target=/hostfs,readonly \ 
  --mount type=bind,source=/var/run/dbus/system_bus_socket,target=/hostfs/var/run/dbus/system_bus_socket,readonly \ 
  --env DBUS_SYSTEM_BUS_ADDRESS='unix:path=/hostfs/var/run/dbus/system_bus_socket' \ 
  --net=host \ 
  --cgroupns=host \ 
  docker.elastic.co/beats/metricbeat:9.3.0 -e --system.hostfs=/hostfs
```

<note>
  The special filesystems `/proc` and `/sys` are only available if the host system is running Linux. Attempts to bind-mount these filesystems will fail on Windows and MacOS.
</note>

If the [system socket metricset](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-system-socket) is being used on Linux, more privileges will need to be granted to Metricbeat. This metricset reads files from `/proc` that are an interface to internal objects owned by other users. The capabilities needed to read all these files (`sys_ptrace` and `dac_read_search`) are disabled by default on Docker. To grant these permissions these flags are needed too:
```sh
--user root --cap-add sys_ptrace --cap-add dac_read_search
```


### Monitor a service in another container

Next, let’s look at an example of monitoring a containerized service from a Metricbeat container.
```sh
docker run \
  --network=mysqlnet \ 
  -e MYSQL_PASSWORD=secret \ 
  docker.elastic.co/beats/metricbeat:9.3.0
```

The mysql module configuration would look like this:
```yaml
metricbeat.modules:
- module: mysql
  metricsets: ["status"]
  hosts: ["tcp(mysql:3306)/"] 
  username: root
  password: ${MYSQL_PASSWORD} 
```