﻿---
title: Publishing to Logstash fails with "connection reset by peer" message
description: Metricbeat requires a persistent TCP connection to Logstash. If a firewall interferes with the connection, you might see errors like this: To solve the...
url: https://www.elastic.co/docs/reference/beats/metricbeat/publishing-ls-fails-connection-reset-by-peer
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Publishing to Logstash fails with "connection reset by peer" message
Metricbeat requires a persistent TCP connection to Logstash. If a firewall interferes with the connection, you might see errors like this:
```shell
Failed to publish events caused by: write tcp ... write: connection reset by peer
```

To solve the problem:
- make sure the firewall is not closing connections between Metricbeat and Logstash, or
- set the `ttl` value in the [Logstash output](https://www.elastic.co/docs/reference/beats/metricbeat/logstash-output) to a value that’s lower than the maximum time allowed by the firewall, and set `pipelining` to 0 (pipelining cannot be enabled when `ttl` is used).