﻿---
title: Grant privileges and roles needed for monitoring
description: Elasticsearch security features provides built-in users and roles for monitoring. The privileges and roles needed depend on the method used to collect...
url: https://www.elastic.co/docs/reference/beats/metricbeat/privileges-to-publish-monitoring
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Grant privileges and roles needed for monitoring
Elasticsearch security features provides built-in users and roles for monitoring. The privileges and roles needed depend on the method used to collect monitoring data.
<admonition title="Important note for Elastic Cloud users">
  Built-in users are not available when running [Elastic Cloud Hosted](https://www.elastic.co/cloud). To send monitoring data securely, create a monitoring user and grant it the roles described in the following sections.
</admonition>

- If you’re using [internal collection](https://www.elastic.co/docs/reference/beats/metricbeat/monitoring-internal-collection) to collect metrics about Metricbeat, Elasticsearch security features provides the `beats_system` [built-in user](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users) and `beats_system` [built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles) to send monitoring information. You can use the built-in user, if it’s available in your environment, or create a user who has the privileges needed to send monitoring information.
  If you use the `beats_system` user, make sure you set the password.
  If you don’t use the `beats_system` user:
  1. Create a **monitoring role**, called something like `metricbeat_monitoring`, that has the following privileges:
   | Type    | Privilege                                       | Purpose                                    |
   |---------|-------------------------------------------------|--------------------------------------------|
   | Cluster | `monitor`                                       | Retrieve cluster details (e.g. version)    |
   | Index   | `create_index` on `.monitoring-beats-*` indices | Create monitoring indices in Elasticsearch |
   | Index   | `create_doc` on `.monitoring-beats-*` indices   | Write monitoring events into Elasticsearch |
2. Assign the **monitoring role**, along with the following built-in roles, to users who need to monitor Metricbeat:
   | Role              | Purpose                                                  |
   |-------------------|----------------------------------------------------------|
   | `kibana_admin`    | Use Kibana                                               |
   | `monitoring_user` | Use **Stack Monitoring** in Kibana to monitor Metricbeat |
- If you’re [using Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/monitoring-metricbeat-collection) to collect metrics about Metricbeat, Elasticsearch security features provides the `remote_monitoring_user` [built-in user](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users), and the `remote_monitoring_collector` and `remote_monitoring_agent` [built-in roles](https://www.elastic.co/docs/reference/elasticsearch/roles) for collecting and sending monitoring information. You can use the built-in user, if it’s available in your environment, or create a user who has the privileges needed to collect and send monitoring information.
  If you use the `remote_monitoring_user` user, make sure you set the password.
  If you don’t use the `remote_monitoring_user` user:
  1. Create a user on the production cluster who will collect and send monitoring information.
2. Assign the following roles to the user:
   | Role                          | Purpose                                        |
   |-------------------------------|------------------------------------------------|
   | `remote_monitoring_collector` | Collect monitoring metrics from Metricbeat     |
   | `remote_monitoring_agent`     | Send monitoring data to the monitoring cluster |
3. Assign the following role to users who will view the monitoring data in Kibana:
   | Role              | Purpose                                                  |
   |-------------------|----------------------------------------------------------|
   | `monitoring_user` | Use **Stack Monitoring** in Kibana to monitor Metricbeat |