﻿---
title: Start Metricbeat
description: Before starting Metricbeat: Follow the steps in Quick start: installation and configuration to install, configure, and set up the Metricbeat environment.Make...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-starting
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Start Metricbeat
Before starting Metricbeat:
- Follow the steps in [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-configuration) to install, configure, and set up the Metricbeat environment.
- Make sure Kibana and Elasticsearch are running.
- Make sure the user specified in `metricbeat.yml` is [authorized to publish events](https://www.elastic.co/docs/reference/beats/metricbeat/privileges-to-publish-events).

To start Metricbeat, run:
<tab-set>
  <tab-item title="DEB">
    ```sh
    sudo service metricbeat start
    ```

    <note>
      If you use an `init.d` script to start Metricbeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/metricbeat/command-line-options)). To specify flags, start Metricbeat in the foreground.
    </note>
    Also see [Metricbeat and systemd](https://www.elastic.co/docs/reference/beats/metricbeat/running-with-systemd).
  </tab-item>

  <tab-item title="RPM">
    ```sh
    sudo service metricbeat start
    ```

    <note>
      If you use an `init.d` script to start Metricbeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/metricbeat/command-line-options)). To specify flags, start Metricbeat in the foreground.
    </note>
    Also see [Metricbeat and systemd](https://www.elastic.co/docs/reference/beats/metricbeat/running-with-systemd).
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    sudo chown root metricbeat.yml 
    sudo chown root modules.d/{modulename}.yml 
    sudo ./metricbeat -e
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    sudo chown root metricbeat.yml 
    sudo chown root modules.d/{modulename}.yml 
    sudo ./metricbeat -e
    ```
  </tab-item>

  <tab-item title="Windows">
    ```sh
    PS C:\Program Files\metricbeat> Start-Service metricbeat
    ```
    By default Windows log files are stored in `C:\Program Files\Metricbeat-Data\logs`.
    <note>
      In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\metricbeat\logs`.
    </note>

    <note>
      On Windows, statistics about system load and swap usage are currently not captured
    </note>
  </tab-item>
</tab-set>