﻿---
title: ZooKeeper module
description: The ZooKeeper module fetches statistics from the ZooKeeper service. The default metricsets are mntr and server. The ZooKeeper metricsets were tested with...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-zookeeper
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# ZooKeeper module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/zookeeper).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

The ZooKeeper module fetches statistics from the ZooKeeper service. The default metricsets are `mntr` and `server`.

## Compatibility

The ZooKeeper metricsets were tested with ZooKeeper 3.4.8, 3.6.0 and 3.7.0. They are expected to work with all versions >= 3.4.0. Versions prior to 3.4 do not support the `mntr` command.
Note that from ZooKeeper 3.6.0, `mntr`, `stat`, `ruok`, `conf`, `isro`, `cons` command must be explicitly enabled at ZooKeeper side using the `4lw.commands.whitelist` configuration parameter.

## Dashboard

The Zookeeper module comes with a predefined dashboard:
![metricbeat zookeeper](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-zookeeper.png)

## Example configuration

The ZooKeeper module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: zookeeper
  enabled: true
  metricsets: ["mntr", "server"]
  period: 10s
  hosts: ["localhost:2181"]
```


## Metricsets

The following metricsets are available:
- [connection](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-zookeeper-connection)
- [mntr](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-zookeeper-mntr)
- [server](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-zookeeper-server)