﻿---
title: Windows module
description: This is the windows module which collects metrics from Windows systems. The module contains the service metricset, which is set up by default when the...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-windows
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Windows module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/windows).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

This is the `windows` module which collects metrics from Windows systems. The module contains the `service` metricset, which is set up by default when the `windows` module is enabled. The `service` metricset will retrieve status information of the services on the Windows machines. The second `windows` metricset is `perfmon` which collects Windows performance counter values.

## Example configuration

The Windows module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: windows
  metricsets: ["perfmon"]
  enabled: true
  period: 10s
  perfmon.ignore_non_existent_counters: false
  perfmon.group_measurements_by_instance: false
  perfmon.queries:
#  - object: 'Process'
#    instance: ["*"]
#    counters:
#    - name: '% Processor Time'
#      field: cpu_usage
#      format: "float"
#    - name: "Thread Count"

- module: windows
  metricsets: ["service"]
  enabled: true
  period: 60s

- module: windows
  metricsets: ["wmi"]
  period: 10m
  wmi:
    # Do not include the query string in the output
    include_queries: false
    # Exclude properties with null values from the output
    include_null_properties: false
    # Exclude properties with empty string values from the output
    include_empty_string_properties: false
    # Maximum time to wait for a query result before logging a warning (defaults to period)
    warning_threshold: 10m
    # Default WMI namespace for all queries (if not specified per query)
    # Uncomment to override the default, which is "root\\cimv2".
    # namespace: "root\\cimv2"
    queries:
    - class: Win32_OperatingSystem         
      properties:                          
       - FreePhysicalMemory
       - FreeSpaceInPagingFiles
       - FreeVirtualMemory
       - LocalDateTime
       - NumberOfUsers
      where: ""                            
      # Override the WMI namespace for this specific query (optional).
      # If set, this takes precedence over the default namespace above.
      # namespace: "root\\cimv2"
```


## Metricsets

The following metricsets are available:
- [perfmon](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-windows-perfmon)
- [service](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-windows-service)
- [wmi](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-windows-wmi)  <applies-to>Elastic Stack: Beta since 9.1</applies-to>