﻿---
title: vSphere module
description: The vSphere module uses the Govmomi library to collect metrics from any VMware SDK URL (ESXi/VCenter). This module has been tested against ESXi and vCenter...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-vsphere
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# vSphere module
The vSphere module uses the [Govmomi](https://github.com/vmware/govmomi) library to collect metrics from any VMware SDK URL (ESXi/VCenter).
This module has been tested against ESXi and vCenter versions 5.5, 6.0, 6.5, and 7.0.3.
By default, the vSphere module enables the following metricsets:
1. cluster
2. datastore
3. datastorecluster
4. host
5. network
6. resourcepool
7. virtualmachine


## Supported Periods:

The Datastore and Host metricsets support performance data collection using the vSphere performance API. Given that the performance API imposes usage restrictions based on data collection intervals, users should configure the period optimally to ensure the receipt of real-time data. This configuration can be determined based on the [Data Collection Intervals](https://docs.vmware.com/en/VMware-vSphere/7.0/com.vmware.vsphere.monitoring.doc/GUID-247646EA-A04B-411A-8DD4-62A3DCFCF49B.md) and [Data Collection Levels](https://docs.vmware.com/en/VMware-vSphere/7.0/com.vmware.vsphere.monitoring.doc/GUID-25800DE4-68E5-41CC-82D9-8811E27924BC.md).
<important>
  Only host and datastore metricsets have limitation of system configured period from vSphere instance. Users can still collect summary metrics if performance metrics are not supported for the configured instance.
</important>


### Real-time data collection default interval:

- 20s


### Historical data collection default intervals:

- 300s
- 1800s
- 7200s
- 86400s


## Example:

If you need to configure multiple metricsets with different periods, you can achieve this by setting up multiple vSphere modules with different metricsets as demonstrated below:
```yaml
- module: vsphere
  metricsets:
   - cluster
   - datastorecluster
   - network
   - resourcepool
   - virtualmachine
  period: 10s
  hosts: ["https://localhost/sdk"]
  username: "user"
  password: "password"
  insecure: false

- module: vsphere
  metricsets:
   - datastore
   - host
  period: 300s
  hosts: ["https://localhost/sdk"]
  username: "user"
  password: "password"
  insecure: false
```


## Dashboard

The vSphere module includes a predefined dashboard. For example:
![metricbeat vsphere dashboard](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat_vsphere_dashboard.png)
![metricbeat vsphere vm dashboard](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat_vsphere_vm_dashboard.png)

## Example configuration

The vSphere module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: vsphere
  enabled: true
  metricsets: ["cluster", "datastore", "datastorecluster", "host", "network", "resourcepool", "virtualmachine"]
  
  # Real-time data collection – An ESXi Server collects data for each performance counter every 20 seconds by default.
  # Supported Periods:
  # The Datastore and Host metricsets support performance data collection using the vSphere performance API.
  # Since the performance API has usage restrictions based on data collection intervals,
  # users should ensure that the period is configured optimally to receive real-time data.
  # users can still collect summary metrics if performance metrics are not supported for the configured instance.
  # This configuration can be determined based on the Data Collection Intervals and Data Collection Levels.
  # Reference Links:
  # Data Collection Intervals: https://docs.vmware.com/en/VMware-vSphere/7.0/com.vmware.vsphere.monitoring.doc/GUID-247646EA-A04B-411A-8DD4-62A3DCFCF49B.html
  # Data Collection Levels: https://docs.vmware.com/en/VMware-vSphere/7.0/com.vmware.vsphere.monitoring.doc/GUID-25800DE4-68E5-41CC-82D9-8811E27924BC.html
  period: 20s
  hosts: ["https://localhost/sdk"]

  username: "user"
  password: "password"
  # If insecure is true, don't verify the server's certificate chain
  insecure: false
  # Get custom fields when using virtualmachine metricset. Default false.
  # get_custom_fields: false
```


## Metricsets

The following metricsets are available:
- [cluster](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-vsphere-cluster)  <applies-to>Elastic Stack: Beta</applies-to>
- [datastore](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-vsphere-datastore)
- [datastorecluster](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-vsphere-datastorecluster)  <applies-to>Elastic Stack: Beta</applies-to>
- [host](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-vsphere-host)
- [network](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-vsphere-network)  <applies-to>Elastic Stack: Beta</applies-to>
- [resourcepool](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-vsphere-resourcepool)  <applies-to>Elastic Stack: Beta</applies-to>
- [virtualmachine](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-vsphere-virtualmachine)