﻿---
title: uWSGI module
description: This is the uwsgi module. By default collects the stats metricset, using StatsServer. The uWSGI module has these additional config options: The uwsgi...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-uwsgi
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# uWSGI module
This is the uwsgi module. By default collects the `stats` metricset, using [StatsServer](http://uwsgi-docs.readthedocs.io/en/latest/StatsServer.html).

## Module-specific configuration notes

The uWSGI module has these additional config options:
<definitions>
  <definition term="hosts">
    host URLs to get data from (e.g: `tcp://127.0.0.1:9191`). Can obtain data from 3 types of schemes: tcp (`tcp://ip:port`), unix socket (`unix:///tmp/uwsgi.sock`) and http/https server (`http://ip:port`)
  </definition>
</definitions>


## Dashboard

The uwsgi module comes with a predefined dashboard. For example:
![uwsgi dashboard](https://www.elastic.co/docs/reference/beats/metricbeat/images/uwsgi_dashboard.png)

## Example configuration

The uWSGI module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: uwsgi
  metricsets: ["status"]
  enable: true
  period: 10s
  hosts: ["tcp://127.0.0.1:9191"]
```


## Metricsets

The following metricsets are available:
- [status](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-uwsgi-status)