﻿---
title: Traefik module
description: This module periodically fetches metrics from a Traefik instance. The Traefik instance must be configured to expose it’s HTTP API. The Traefik metricsets...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-traefik
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Traefik module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/traefik).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

This module periodically fetches metrics from a [Traefik](https://traefik.io/) instance. The Traefik instance must be configured to expose it’s HTTP API.

## Compatibility

The Traefik metricsets were tested with Traefik 1.6.

## Example configuration

The Traefik module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: traefik
  metricsets: ["health"]
  period: 10s
  hosts: ["localhost:8080"]
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [health](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-traefik-health)