﻿---
title: Tomcat module
description: This module periodically fetches JMX metrics from Apache Tomcat. The module has been tested with Tomcat 7.0.24 and 9.0.24. Other versions are expected...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-tomcat
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Tomcat module
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/tomcat).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

This module periodically fetches JMX metrics from Apache Tomcat.

### Compatibility

The module has been tested with Tomcat 7.0.24 and 9.0.24. Other versions are expected to work.

## Dashboard

An overview dashboard for Kibana is already included:
![metricbeat tomcat overview](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-tomcat-overview.png)

### Usage

The Tomcat module requires [Jolokia](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-jolokia)to fetch JMX metrics. Refer to the link for instructions about how to use Jolokia.

## Example configuration

The Tomcat module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: tomcat
  metricsets: ['threading', 'cache', 'memory', 'requests']
  period: 10s
  hosts: ['localhost:8080']
  path: "/jolokia/?ignoreErrors=true&canonicalNaming=false"
```


## Metricsets

The following metricsets are available:
- [cache](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-tomcat-cache)  <applies-to>Elastic Stack: Beta</applies-to>
- [memory](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-tomcat-memory)  <applies-to>Elastic Stack: Beta</applies-to>
- [requests](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-tomcat-requests)  <applies-to>Elastic Stack: Beta</applies-to>
- [threading](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-tomcat-threading)  <applies-to>Elastic Stack: Beta</applies-to>